/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.filter;

import java.util.ArrayList;
import java.util.List;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.anodoc.util.context.ContextManager;
import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.asg.util.filter.FilterTrigger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MissingTranslationFilter
implements DocumentFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(MissingTranslationFilter.class);
    private List<FilterTrigger> triggerer;
    private List<String> supportedLanguages;
    private String defaultLanguage;

    public MissingTranslationFilter() {
        try {
            this.setSupportedLanguages(ContextManager.getCallContext().getSupportedLanguages());
            this.defaultLanguage = ContextManager.getCallContext().getDefaultLanguage();
        }
        catch (Exception e) {
            LOGGER.warn("CallContext can not be getted by ContextManager. Setting default language and supported languages to EN", (Throwable)e);
            ArrayList<String> defaultSupportedLanguages = new ArrayList<String>();
            defaultSupportedLanguages.add("EN");
            this.setSupportedLanguages(defaultSupportedLanguages);
            this.setDefaultLanguage("EN");
        }
    }

    public MissingTranslationFilter(List<String> supportedLanguages, String defaultLanguage) {
        this.setSupportedLanguages(supportedLanguages);
        this.setDefaultLanguage(defaultLanguage);
    }

    @Override
    public List<FilterTrigger> getTriggerer(String storedFilterParameter) {
        return this.triggerer;
    }

    @Override
    public boolean mayPass(DataObject document, String attributeName, String filterParameter) {
        boolean mayPass;
        if (filterParameter == null || filterParameter.length() == 0) {
            return true;
        }
        Object propertyValue = "";
        Object defaultLanguagePropertyValue = "";
        try {
            propertyValue = "" + document.getPropertyValue(attributeName + "_" + filterParameter);
            if (filterParameter.equals(this.defaultLanguage)) {
                defaultLanguagePropertyValue = propertyValue;
                mayPass = ((String)defaultLanguagePropertyValue).isEmpty() || ((String)defaultLanguagePropertyValue).equals("null");
            } else {
                defaultLanguagePropertyValue = "" + document.getPropertyValue(attributeName + "_" + this.defaultLanguage);
                mayPass = (((String)propertyValue).isEmpty() || ((String)propertyValue).equals("null")) && !((String)defaultLanguagePropertyValue).equals("null") && !((String)defaultLanguagePropertyValue).isEmpty();
            }
        }
        catch (NoSuchPropertyException e) {
            mayPass = false;
        }
        catch (Exception e) {
            mayPass = false;
        }
        return mayPass;
    }

    public void setSupportedLanguages(List<String> supportedLanguages) {
        this.supportedLanguages = supportedLanguages;
        this.triggerer = new ArrayList<FilterTrigger>();
        this.triggerer.add(new FilterTrigger("All", ""));
        for (String language : supportedLanguages) {
            if (language.equals(this.defaultLanguage)) continue;
            this.triggerer.add(new FilterTrigger(language, language));
        }
    }

    public List<String> getSupportedLanguages() {
        return this.supportedLanguages;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }
}

