/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.listener;

import net.anotheria.asg.data.DataObject;
import net.anotheria.asg.util.CmsChangesTracker;
import net.anotheria.asg.util.DocumentChange;
import net.anotheria.asg.util.listener.IServiceListener;

public class ContentChangeTrackerListener
implements IServiceListener {
    @Override
    public void documentCreated(DataObject doc) {
        this.trackChanges(doc, CmsChangesTracker.Action.CREATE);
    }

    @Override
    public void documentImported(DataObject doc) {
        this.trackChanges(doc, CmsChangesTracker.Action.IMPORT);
    }

    @Override
    public void documentDeleted(DataObject doc) {
        this.trackChanges(doc, CmsChangesTracker.Action.DELETE);
    }

    @Override
    public void documentUpdated(DataObject oldVersion, DataObject newVersion) {
        this.trackChanges(newVersion, CmsChangesTracker.Action.UPDATE);
    }

    private void trackChanges(DataObject doc, CmsChangesTracker.Action action) {
        DocumentChange dc = new DocumentChange();
        dc.setAction(action);
        dc.setDocumentName(doc.getDefinedName());
        dc.setParentName(doc.getDefinedParentName().toLowerCase());
        dc.setTimestamp(doc.getLastUpdateTimestamp());
        dc.setUserName(doc.getObjectInfo().getAuthor());
        dc.setId(doc.getId());
        CmsChangesTracker.saveChange(dc);
    }

    @Override
    public void persistenceChanged() {
    }
}

