/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.locking.config;

import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="lockingconfig")
public class LockingConfig {
    @Configure
    private boolean autolocking = false;
    @Configure
    private long timeout = 0L;

    public static LockingConfig getInstance() {
        return LockingConfigInstanceHolder.instance;
    }

    private LockingConfig() {
    }

    public boolean isAutolocking() {
        return this.autolocking;
    }

    public void setAutolocking(boolean autolocking) {
        this.autolocking = autolocking;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    private static class LockingConfigInstanceHolder {
        private static final LockingConfig instance = new LockingConfig();

        private LockingConfigInstanceHolder() {
        }

        static {
            try {
                ConfigurationManager.INSTANCE.configure((Object)instance);
            }
            catch (Exception e) {
                try {
                    LoggerFactory.getLogger(LockingConfig.class).warn("Couldn't configure LockingConfig, stick to defaults: " + instance);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

