/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.asg.util.locking.helper;

import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;

public enum DocumentLockingHelper {
    show,
    search,
    linksToMe,
    duplicate,
    create,
    update{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, update action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    }
    ,
    delete{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, delete action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    }
    ,
    edit,
    newDoc,
    lock{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked()) {
                String messageContent = document.getLockerId().equals(currentUser) ? currentUser + ". Can't perform locking operation, document is allready locked by You!" : currentUser + ". Permission denied, lock action can't be performed on allready locked document. Locked by - " + document.getLockerId();
                throw new LockingException(messageContent);
            }
        }
    }
    ,
    unLock{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked()) {
                if (!userInAdminRole && !document.getLockerId().equals(currentUser)) {
                    throw new LockingException(currentUser + ". Permission denied, expected one of those: 'user with - admin role', or  locker: user - " + document.getLockerId());
                }
            } else {
                throw new LockingException(currentUser + ". Permission denied, document is not locked. Can't perform unlocking");
            }
        }
    }
    ,
    multiLanguageSwitch{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, multiLanguageSwitch action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    }
    ,
    copyLang{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, copyLang action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    }
    ,
    versionInfo,
    containerDelete{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, containerDelete action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    }
    ,
    containerMove{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, containerMove action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    }
    ,
    containerListAddRow{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, containerListAddRow action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    }
    ,
    containerTableAddAction{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, containerTableAddAction action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    }
    ,
    containerListQuickAdd{

        @Override
        public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
            if (document.isLocked() && !document.getLockerId().equals(currentUser)) {
                throw new LockingException(currentUser + ". Permission denied, containerListQuickAdd action can't be performed, document isLocked by - " + document.getLockerId() + ".");
            }
        }
    };


    public void checkExecutionPermission(LockableObject document, boolean userInAdminRole, String currentUser) {
    }
}

