/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.maf;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.MAFExecutionContext;
import net.anotheria.maf.action.AbortExecutionException;
import net.anotheria.maf.action.Action;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionFactory;
import net.anotheria.maf.action.ActionFactoryException;
import net.anotheria.maf.action.ActionForward;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.maf.action.ActionMappings;
import net.anotheria.maf.action.ActionMappingsConfigurator;
import net.anotheria.maf.action.CommandForward;
import net.anotheria.maf.action.CommandRedirect;
import net.anotheria.maf.action.DefaultActionFactory;
import net.anotheria.maf.annotation.ActionAnnotation;
import net.anotheria.maf.annotation.ActionsAnnotation;
import net.anotheria.maf.annotation.CommandForwardAnnotation;
import net.anotheria.maf.bean.ErrorBean;
import net.anotheria.maf.bean.FormBean;
import net.anotheria.maf.util.FormObjectMapper;
import net.anotheria.maf.validation.ValidationAware;
import net.anotheria.maf.validation.ValidationError;
import net.anotheria.maf.validation.ValidationException;
import net.anotheria.moskito.core.predefined.Constants;
import net.anotheria.moskito.core.predefined.FilterStats;
import net.anotheria.moskito.core.predefined.ServletStats;
import net.anotheria.moskito.core.producers.IStats;
import net.anotheria.moskito.core.producers.IStatsProducer;
import net.anotheria.moskito.core.registry.ProducerRegistryFactory;
import net.anotheria.moskito.core.stats.Interval;
import net.anotheria.util.StringUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class MAFFilter
implements Filter,
IStatsProducer {
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private ServletStats getStats;
    private List<IStats> cachedStatList;
    private String path;
    private String producerId;
    private String subsystem;
    private String category;
    private static Logger log = LoggerFactory.getLogger(MAFFilter.class);
    private ActionMappings mappings;
    private ActionFactory actionFactory = new DefaultActionFactory();

    public void destroy() {
    }

    public void init(FilterConfig config) throws ServletException {
        this.getStats = new FilterStats("cumulated", this.getMonitoringIntervals());
        this.cachedStatList = new ArrayList<IStats>();
        this.cachedStatList.add((IStats)this.getStats);
        this.path = config.getInitParameter("path");
        if (this.path == null) {
            this.path = "";
        }
        this.producerId = config.getInitParameter("producerId");
        if (this.producerId == null) {
            this.producerId = "maffilter";
        }
        this.subsystem = config.getInitParameter("subsystem");
        if (this.subsystem == null) {
            this.subsystem = "maf";
        }
        this.category = config.getInitParameter("category");
        if (this.category == null) {
            this.category = "filter";
        }
        ProducerRegistryFactory.getProducerRegistryInstance().registerProducer((IStatsProducer)this);
        String actionFactoryClazzName = config.getInitParameter("actionFactory");
        if (!StringUtils.isEmpty((String)actionFactoryClazzName)) {
            try {
                this.actionFactory = (ActionFactory)Class.forName(actionFactoryClazzName).newInstance();
            }
            catch (Exception e) {
                log.error("Couldn't initialize custom actionFactory: " + actionFactoryClazzName, (Throwable)e);
            }
        }
        this.mappings = new ActionMappings();
        List<ActionMappingsConfigurator> configurators = this.getConfigurators();
        for (ActionMappingsConfigurator configurator : configurators) {
            try {
                configurator.configureActionMappings(this.mappings);
            }
            catch (Throwable t) {
                log.error(FATAL, "Configuration failed by configurator " + configurator, t);
            }
        }
        String annotatedActionsPackage = config.getInitParameter("configureByAnnotations");
        if (!StringUtils.isEmpty((String)annotatedActionsPackage)) {
            this.configureByAnnotations(annotatedActionsPackage);
        }
    }

    private void configureByAnnotations(String annotatedActionsPackage) {
        Reflections reflections = new Reflections(annotatedActionsPackage, new Scanner[0]);
        HashSet actionTypes = new HashSet();
        actionTypes.addAll(reflections.getTypesAnnotatedWith(ActionAnnotation.class));
        actionTypes.addAll(reflections.getTypesAnnotatedWith(ActionsAnnotation.class));
        for (Class clazz : actionTypes) {
            ActionsAnnotation mapsAnnotation;
            if (!Action.class.isAssignableFrom(clazz)) {
                String message = "Class " + clazz.getName() + " annotated with " + ActionAnnotation.class.getName() + " or " + ActionsAnnotation.class.getName() + " is not inherited from " + Action.class.getName();
                log.error(message);
                throw new RuntimeException(message);
            }
            ArrayList<ActionAnnotation> maps = new ArrayList<ActionAnnotation>();
            ActionAnnotation mapAnnotation = clazz.getAnnotation(ActionAnnotation.class);
            if (mapAnnotation != null) {
                maps.add(mapAnnotation);
            }
            if ((mapsAnnotation = clazz.getAnnotation(ActionsAnnotation.class)) != null) {
                Collections.addAll(maps, mapsAnnotation.maps());
            }
            for (ActionAnnotation map : maps) {
                if (!this.path.equals(map.context())) continue;
                ArrayList<ActionCommand> forwards = new ArrayList<ActionCommand>();
                for (CommandForwardAnnotation commandForwardAnnotation : map.forwards()) {
                    forwards.add(new CommandForward(commandForwardAnnotation.name(), commandForwardAnnotation.path()));
                }
                for (Annotation annotation : map.redirects()) {
                    forwards.add(new CommandRedirect(annotation.name(), annotation.target(), annotation.code()));
                }
                this.mappings.addMapping(map.path(), (Class<? extends Action>)clazz, forwards.toArray(new ActionCommand[forwards.size()]));
            }
        }
    }

    public void doFilter(ServletRequest sreq, ServletResponse sres, FilterChain chain) throws IOException, ServletException {
        if (!(sreq instanceof HttpServletRequest)) {
            chain.doFilter(sreq, sres);
            return;
        }
        MAFExecutionContext executionContext = MAFExecutionContext.currentExecutionContext();
        executionContext.setFilter(this);
        executionContext.setMappings(this.mappings);
        HttpServletRequest req = (HttpServletRequest)sreq;
        HttpServletResponse res = (HttpServletResponse)sres;
        String servletPath = req.getServletPath();
        if (servletPath == null || servletPath.length() == 0) {
            servletPath = req.getPathInfo();
        }
        if (servletPath != null && (this.path.length() == 0 || servletPath.startsWith(this.path)) && !this.isPathExcluded(servletPath)) {
            this.doPerform(req, res, servletPath);
            return;
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
    }

    protected boolean isPathExcluded(String servletPath) {
        return false;
    }

    private void doPerform(HttpServletRequest req, HttpServletResponse res, String servletPath) throws ServletException, IOException {
        this.getStats.addRequest();
        long startTime = System.nanoTime();
        try {
            Action action;
            ActionMapping mapping;
            String actionPath = servletPath.substring(this.path.length());
            if ((actionPath == null || actionPath.length() == 0) && this.getDefaultActionName() != null) {
                actionPath = this.getDefaultActionName();
            }
            if ((mapping = this.mappings.findMapping(actionPath)) == null) {
                res.sendError(404, "Action " + actionPath + " not found.");
                return;
            }
            try {
                action = this.actionFactory.getInstanceOf(mapping.getType());
            }
            catch (ActionFactoryException e) {
                throw new ServletException("Can't instantiate " + mapping.getType() + " for path: " + actionPath + ", because: " + e.getMessage(), (Throwable)e);
            }
            ActionCommand command = null;
            try {
                List<ValidationError> errors;
                action.preProcess(mapping, req, res);
                FormBean bean = FormObjectMapper.getModelObjectMapped(req, action);
                if (bean != null && !(errors = FormObjectMapper.validate(req, bean)).isEmpty()) {
                    if (action instanceof ValidationAware) {
                        command = ((ValidationAware)((Object)action)).executeOnValidationError(mapping, bean, errors, req, res);
                    } else {
                        throw new ServletException("Mapper validation failed: " + errors);
                    }
                }
                if (command == null) {
                    command = action.execute(mapping, bean, req, res);
                }
                action.postProcess(mapping, req, res);
            }
            catch (ValidationException e) {
                throw new ServletException("Error in processing: " + e.getMessage(), (Throwable)e);
            }
            catch (AbortExecutionException e) {
            }
            catch (Exception e) {
                log.error("Unexpected exception in processing", (Throwable)e);
                ActionCommand onError = this.mappings.getOnError();
                if (onError == null) {
                    throw new ServletException("Error in processing: " + e.getMessage(), (Throwable)e);
                }
                req.setAttribute("maf.error", (Object)new ErrorBean(e));
                this.executeCommand(onError, req, res);
            }
            if (command != null) {
                this.executeCommand(command, req, res);
            }
        }
        catch (ServletException e) {
            this.getStats.notifyServletException((Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.getStats.notifyIOException((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            this.getStats.notifyRuntimeException((Throwable)e);
            throw e;
        }
        catch (Error e) {
            this.getStats.notifyError();
            throw e;
        }
        finally {
            long executionTime = System.nanoTime() - startTime;
            this.getStats.addExecutionTime(executionTime);
            this.getStats.notifyRequestFinished();
        }
    }

    private void executeCommand(ActionCommand command, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ActionCommand forward;
        if (command instanceof ActionForward) {
            forward = (ActionForward)command;
            req.getRequestDispatcher(((ActionForward)forward).getPath()).forward((ServletRequest)req, (ServletResponse)res);
        }
        if (command instanceof CommandForward) {
            forward = (CommandForward)command;
            req.getRequestDispatcher(((CommandForward)forward).getPath()).forward((ServletRequest)req, (ServletResponse)res);
        }
        if (command instanceof CommandRedirect) {
            CommandRedirect redirect = (CommandRedirect)command;
            if (redirect.getCode() == 302) {
                res.sendRedirect(redirect.getTarget());
            } else {
                res.setHeader("Location", redirect.getTarget());
                res.setStatus(redirect.getCode());
            }
        }
    }

    public List<IStats> getStats() {
        return this.cachedStatList;
    }

    protected Interval[] getMonitoringIntervals() {
        return Constants.getDefaultIntervals();
    }

    protected boolean operationAllowed(HttpServletRequest req, HttpServletResponse res) {
        return true;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public String getCategory() {
        return this.category;
    }

    protected List<ActionMappingsConfigurator> getConfigurators() {
        return new ArrayList<ActionMappingsConfigurator>();
    }

    protected String getDefaultActionName() {
        return null;
    }

    protected ActionFactory getActionFactory() {
        return this.actionFactory;
    }

    protected void setActionFactory(ActionFactory actionFactory) {
        this.actionFactory = actionFactory;
    }
}

