/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.maf.action;

import java.util.HashMap;
import java.util.Map;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionForward;
import net.anotheria.maf.action.CommandRedirect;

public class ActionMapping {
    private String path;
    private String type;
    private Map<String, ActionCommand> commands;

    public ActionMapping(String aPath, String aType, ActionCommand ... someCommands) {
        this.path = aPath;
        this.type = aType;
        this.commands = new HashMap<String, ActionCommand>();
        if (someCommands != null) {
            for (ActionCommand c : someCommands) {
                this.commands.put(c.getName(), c);
            }
        }
    }

    public ActionForward findForward(String name) {
        ActionCommand c = this.findCommand(name);
        if (c instanceof ActionForward) {
            return (ActionForward)c;
        }
        if (c != null) {
            throw new IllegalArgumentException("Command " + name + " is not a forward");
        }
        return null;
    }

    public ActionCommand findCommand(String name) {
        return this.commands.get(name);
    }

    public String getPath() {
        return this.path;
    }

    public String getType() {
        return this.type;
    }

    public ActionCommand success() {
        return this.findCommand("success");
    }

    public ActionCommand error() {
        return this.findCommand("error");
    }

    public ActionCommand dialog() {
        return this.findCommand("dialog");
    }

    public CommandRedirect redirect() {
        return (CommandRedirect)CommandRedirect.class.cast(this.findCommand("redirect"));
    }

    public String toString() {
        return this.getPath() + " - " + this.getType() + " - " + this.commands;
    }

    public Map<String, ActionCommand> getCommands() {
        return new HashMap<String, ActionCommand>(this.commands);
    }
}

