/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.maf.action;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.maf.action.Action;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionForward;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.maf.action.ForwardAction;
import net.anotheria.maf.builtin.ShowMappingsAction;

public final class ActionMappings {
    private final ConcurrentMap<String, String> aliases = new ConcurrentHashMap<String, String>();
    private final ConcurrentMap<String, ActionMapping> mappings = new ConcurrentHashMap<String, ActionMapping>();
    private ActionCommand onError;
    private ActionCommand onNotFound;

    public void addMapping(String path, String type, ActionCommand ... commands) {
        this.mappings.put(path, new ActionMapping(path, type, commands));
    }

    public void addMapping(String path, String type, ActionForward ... forwards) {
        this.mappings.put(path, new ActionMapping(path, type, forwards));
    }

    public void addForward(String actionPath, String forwardPath) {
        this.addMapping(actionPath, ForwardAction.class, new ActionForward("forward", forwardPath));
    }

    public void addMapping(String path, Class<? extends Action> type, ActionCommand ... commands) {
        this.mappings.put(path, new ActionMapping(path, type.getName(), commands));
    }

    public void addMapping(String path, Class<? extends Action> type, ActionForward ... forwards) {
        this.mappings.put(path, new ActionMapping(path, type.getName(), forwards));
    }

    public void addAlias(String sourcePath, String targetPath) {
        this.aliases.put(sourcePath, targetPath);
    }

    public ActionMapping findMapping(String actionPath) {
        String alias = (String)this.aliases.get(actionPath);
        if (alias != null) {
            return this.findMapping(alias);
        }
        return (ActionMapping)this.mappings.get(actionPath);
    }

    public Map<String, String> getAliases() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.putAll(this.aliases);
        return ret;
    }

    public Map<String, ActionMapping> getMappings() {
        HashMap<String, ActionMapping> ret = new HashMap<String, ActionMapping>();
        ret.putAll(this.mappings);
        return ret;
    }

    public ActionMappings() {
        this.addAlias("maf/showMappings", "/maf/showMappings");
        this.addMapping("/maf/showMappings", ShowMappingsAction.class, new ActionForward[0]);
    }

    public ActionCommand getOnError() {
        return this.onError;
    }

    public void setOnError(ActionCommand onError) {
        this.onError = onError;
    }

    public ActionCommand getOnNotFound() {
        return this.onNotFound;
    }

    public void setOnNotFound(ActionCommand onNotFound) {
        this.onNotFound = onNotFound;
    }
}

