/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.maf.action;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.anotheria.maf.action.Action;
import net.anotheria.maf.action.ActionFactory;
import net.anotheria.maf.action.ActionFactoryException;

public final class DefaultActionFactory
implements ActionFactory {
    private static final ConcurrentMap<String, Action> instances = new ConcurrentHashMap<String, Action>();

    @Override
    public Action getInstanceOf(String actionType) throws ActionFactoryException {
        Action action = (Action)instances.get(actionType);
        if (action != null) {
            return action;
        }
        try {
            action = (Action)Class.forName(actionType).newInstance();
        }
        catch (Exception e) {
            throw new ActionFactoryException(e);
        }
        Action old = instances.putIfAbsent(actionType, action);
        return old != null ? old : action;
    }
}

