/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.maf.json;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.anotheria.maf.json.JSONErrorScope;
import net.anotheria.util.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONResponse
implements JSONErrorScope {
    private static final long serialVersionUID = 5890081951501938183L;
    public static final String STATUS_JSON_FIELD = "status";
    public static final String ROOT_DATA_SCOPE = "data";
    public static final String ROOT_COMMANDS_SCOPE = "commands";
    public static final String ROOT_ERRORS_SCOPE = "errors";
    public static final String ERRORS_SCOPE_GLOBAL_ERRORS = "_global";
    private final String innerScopeName;
    private JSONObject data;
    private final Map<String, String> rawData = new HashMap<String, String>();
    private final Map<String, String> commands = new HashMap<String, String>();
    private final Set<String> globalErrors = new HashSet<String>();
    private final Map<String, Set<String>> fieldErrors = new HashMap<String, Set<String>>();
    private final Map<String, JSONResponse> innerScopes = new HashMap<String, JSONResponse>();

    public JSONResponse() {
        this("ROOT");
    }

    private JSONResponse(String aScopeName) {
        this.innerScopeName = aScopeName;
    }

    public void setData(JSONObject aData) {
        if (aData == null) {
            throw new IllegalArgumentException("Null data.");
        }
        this.data = aData;
    }

    public void addRawData(String key, String value) {
        this.rawData.put(key, value);
    }

    public Map<String, String> getRawData() {
        return new HashMap<String, String>(this.rawData);
    }

    public void addCommand(String name, String param) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Name is empty or null.");
        }
        if (StringUtils.isEmpty((String)param)) {
            throw new IllegalArgumentException("Param is empty or null.");
        }
        this.commands.put(name, param);
    }

    @Override
    public void addError(String error) {
        if (StringUtils.isEmpty((String)error)) {
            throw new IllegalArgumentException("Error is empty or null.");
        }
        this.globalErrors.add(error);
    }

    @Override
    public void addError(String fieldName, String error) {
        if (StringUtils.isEmpty((String)fieldName)) {
            throw new IllegalArgumentException("FieldName is empty or null.");
        }
        if (StringUtils.isEmpty((String)error)) {
            throw new IllegalArgumentException("Error is empty or null.");
        }
        Set<String> fieldErrorsSet = this.fieldErrors.get(fieldName);
        if (fieldErrorsSet == null) {
            fieldErrorsSet = new HashSet<String>();
            this.fieldErrors.put(fieldName, fieldErrorsSet);
        }
        fieldErrorsSet.add(error);
    }

    @Override
    public JSONErrorScope getErrorObject(String objectName) {
        if (StringUtils.isEmpty((String)objectName)) {
            throw new IllegalArgumentException("ObjectName is empty or null.");
        }
        JSONResponse innerScope = this.innerScopes.get(objectName);
        if (innerScope == null) {
            innerScope = new JSONResponse(objectName);
            this.innerScopes.put(objectName, innerScope);
        }
        return innerScope;
    }

    public boolean hasErrors() {
        if (!this.globalErrors.isEmpty() || !this.fieldErrors.isEmpty()) {
            return true;
        }
        for (JSONResponse innerResponse : this.innerScopes.values()) {
            if (!innerResponse.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public JSONObject toJSON() {
        try {
            JSONObject result = new JSONObject();
            result.put(STATUS_JSON_FIELD, (Object)(this.hasErrors() ? "ERROR" : "OK"));
            result.put(ROOT_DATA_SCOPE, (Object)this.getDataJSON());
            result.put(ROOT_COMMANDS_SCOPE, (Object)this.getCommandsJSON());
            if (this.hasErrors()) {
                result.put(ROOT_ERRORS_SCOPE, (Object)this.getErrorsJSON());
            }
            return result;
        }
        catch (JSONException e) {
            throw new RuntimeException("Preparing JSON Response fail.", e);
        }
    }

    private JSONObject getDataJSON() throws JSONException {
        if (this.data == null) {
            return new JSONObject();
        }
        return this.data;
    }

    private JSONObject getCommandsJSON() throws JSONException {
        JSONObject commandsScope = new JSONObject();
        for (Map.Entry<String, String> command : this.commands.entrySet()) {
            commandsScope.put(command.getKey(), (Object)command.getValue());
        }
        return commandsScope;
    }

    private JSONObject getErrorsJSON() throws JSONException {
        JSONObject errorsScope = new JSONObject();
        if (!this.globalErrors.isEmpty()) {
            errorsScope.put(ERRORS_SCOPE_GLOBAL_ERRORS, (Object)new JSONArray(this.globalErrors));
        }
        for (Map.Entry<String, Set<String>> entry : this.fieldErrors.entrySet()) {
            errorsScope.put(entry.getKey(), (Object)new JSONArray((Collection)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.innerScopes.entrySet()) {
            errorsScope.put(entry.getKey(), (Object)((JSONResponse)entry.getValue()).getErrorsJSON());
        }
        return errorsScope;
    }

    public String toString() {
        return this.toJSON().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.innerScopeName == null ? 0 : this.innerScopeName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONResponse other = (JSONResponse)obj;
        return !(this.innerScopeName == null ? other.innerScopeName != null : !this.innerScopeName.equals(other.innerScopeName));
    }
}

