/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.maf.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.Action;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.maf.bean.FormBean;
import net.anotheria.maf.bean.RequestMapBean;
import net.anotheria.maf.bean.annotations.Form;
import net.anotheria.maf.bean.annotations.RequestMap;
import net.anotheria.maf.validation.ValidationError;
import net.anotheria.maf.validation.Validator;
import net.anotheria.maf.validation.annotations.ValidateCustom;
import net.anotheria.maf.validation.annotations.ValidateNotEmpty;
import net.anotheria.maf.validation.annotations.ValidateNumber;
import net.anotheria.util.StringUtils;
import net.anotheria.util.mapper.PopulateMe;
import net.anotheria.util.mapper.PopulateWith;
import net.anotheria.util.mapper.ValueObjectMapperUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FormObjectMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormObjectMapper.class);
    private static final String EXECUTE = "execute";

    private FormObjectMapper() {
    }

    public static void map(HttpServletRequest req, Object destination) {
        Field[] fields;
        Map<String, String> parameterMap = FormObjectMapper.getRequestParameterMap(req);
        Class<?> destinationClass = destination.getClass();
        for (Field field : fields = destinationClass.getDeclaredFields()) {
            PopulateMe populateMe;
            PopulateWith populateWith = field.getAnnotation(PopulateWith.class);
            if (populateWith != null) {
                try {
                    field.setAccessible(true);
                    field.set(destination, parameterMap.get(populateWith.value()));
                }
                catch (IllegalAccessException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }
            if ((populateMe = field.getAnnotation(PopulateMe.class)) == null) continue;
            try {
                field.setAccessible(true);
                field.set(destination, parameterMap.get(field.getName()));
            }
            catch (IllegalAccessException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static Map<String, String> getRequestParameterMap(HttpServletRequest req) {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        for (Object key : req.getParameterMap().keySet()) {
            String reqKey = String.valueOf(key);
            parameterMap.put(reqKey, req.getParameter(reqKey));
        }
        return parameterMap;
    }

    public static FormBean getModelObjectMapped(HttpServletRequest req, Action action) {
        try {
            Annotation[] formAnnotations;
            Method executeMethod = action.getClass().getMethod(EXECUTE, ActionMapping.class, FormBean.class, HttpServletRequest.class, HttpServletResponse.class);
            for (Annotation formAnnotation : formAnnotations = executeMethod.getParameterAnnotations()[1]) {
                if (Form.class.equals(formAnnotation.annotationType())) {
                    Form bean = (Form)formAnnotation;
                    FormBean formBean = bean.value().newInstance();
                    Map<String, String> parameterMap = FormObjectMapper.getRequestParameterMap(req);
                    ValueObjectMapperUtil.map(parameterMap, (Object)formBean);
                    return formBean;
                }
                if (!RequestMap.class.equals(formAnnotation.annotationType())) continue;
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                FormObjectMapper.map(req, parameters);
                Enumeration headerNames = req.getHeaderNames();
                HashMap<String, String> headerMap = new HashMap<String, String>();
                while (headerNames.hasMoreElements()) {
                    String name = (String)headerNames.nextElement();
                    headerMap.put(name, req.getHeader(name));
                }
                HashMap<String, String> cookieMap = new HashMap<String, String>();
                for (Cookie cookie : req.getCookies()) {
                    cookieMap.put(cookie.getName(), cookie.getValue());
                }
                return new RequestMapBean(parameters, cookieMap, headerMap);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("getModelObjectMapped", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOGGER.error("getModelObjectMapped", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("getModelObjectMapped", (Throwable)e);
        }
        return null;
    }

    public static List<ValidationError> validate(HttpServletRequest req, Object bean) {
        Field[] fields;
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        Class<?> beanClass = bean.getClass();
        block3: for (Field field : fields = beanClass.getDeclaredFields()) {
            try {
                Annotation[] annotations;
                field.setAccessible(true);
                Object value = field.get(bean);
                for (Annotation annotation : annotations = field.getAnnotations()) {
                    String zero;
                    String pValue;
                    if (annotation instanceof ValidateNotEmpty) {
                        if (value != null && !String.valueOf(value).isEmpty()) continue;
                        ValidateNotEmpty validateNotEmpty = (ValidateNotEmpty)annotation;
                        errors.add(new ValidationError(field.getName(), validateNotEmpty.message(), validateNotEmpty.key()));
                        continue block3;
                    }
                    if (annotation instanceof ValidateCustom) {
                        ValidateCustom validateCustom = (ValidateCustom)annotation;
                        Validator<?> validator = validateCustom.validator().newInstance();
                        if (validator.validate(value)) continue;
                        errors.add(new ValidationError(field.getName(), validateCustom.message(), validateCustom.key()));
                        continue block3;
                    }
                    if (!(annotation instanceof ValidateNumber) || StringUtils.isEmpty((String)(pValue = req.getParameter(field.getName())))) continue;
                    ValidateNumber validateNumber = (ValidateNumber)annotation;
                    String string = zero = validateNumber.fractional() ? "0.0" : "0";
                    if (value != null && (!(value instanceof Number) || !String.valueOf(value).equals(zero) || pValue.equals(zero))) continue;
                    errors.add(new ValidationError(field.getName(), validateNumber.message() + ". \"" + req.getParameter(field.getName()) + "\" is incorrect", ""));
                    continue block3;
                }
            }
            catch (IllegalAccessException e) {
                LOGGER.error("validate", (Throwable)e);
            }
            catch (InstantiationException e) {
                LOGGER.error("validate", (Throwable)e);
            }
        }
        return errors;
    }
}

