/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.cache;

import net.anotheria.anoprise.cache.Cache;
import net.anotheria.anoprise.cache.CacheFactory;
import net.anotheria.anoprise.cache.ExpiringCache;
import net.anotheria.anoprise.cache.FailoverCache;
import net.anotheria.anoprise.cache.ModableTypeHandler;
import net.anotheria.moskito.core.predefined.CacheStats;
import org.configureme.annotations.AfterConfiguration;
import org.configureme.annotations.BeforeConfiguration;
import org.configureme.annotations.BeforeInitialConfiguration;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@ConfigureMe
public class CacheController<K, V>
implements Cache<K, V> {
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    @Configure
    private boolean cacheOn;
    @Configure
    private int startSize;
    @Configure
    private int maxSize;
    @Configure
    private String factoryClazz;
    @Configure
    private long expirationTime;
    private boolean prevCacheOn;
    private int prevStartSize;
    private int prevMaxSize;
    private long preExpirationTime;
    private Cache<K, V> cache;
    private String configurationName;
    private ModableTypeHandler typeHandler;
    private int instanceAmount = 1;
    private int currentInstanceNumber = 0;
    private int outOfMemoryErrors;
    public static final boolean DEF_CACHE_ON = true;
    public static final int DEF_START_SIZE = 1000;
    public static final int DEF_MAX_SIZE = 5000;
    public static final int DEF_EXPIRATION_TIME = 0;
    public static final int DEF_INSTANCE_AMOUNT = 1;
    public static final int DEF_CURRENT_INSTANCE_NUMBER = -1;
    private static Logger log = LoggerFactory.getLogger(CacheController.class);
    private CacheFactory<K, V> factory;

    public CacheController(String aConfigurationName, CacheFactory<K, V> aFactory) {
        this.configurationName = aConfigurationName;
        this.factory = aFactory;
    }

    public CacheController(String aConfigurationName) {
        this(aConfigurationName, null);
    }

    public CacheController(String aConfigurationName, CacheFactory<K, V> aFactory, int aInstanceAmount, int aCurrentInstanceNumber, ModableTypeHandler aTypeHandler) {
        this(aConfigurationName, aFactory);
        this.typeHandler = aTypeHandler;
        this.instanceAmount = aInstanceAmount;
        this.currentInstanceNumber = aCurrentInstanceNumber;
    }

    @BeforeInitialConfiguration
    public void preInit() {
        this.prevCacheOn = false;
        this.prevStartSize = -1;
        this.prevMaxSize = -1;
        this.preExpirationTime = -1L;
    }

    private void init() {
        if (this.factory == null) {
            try {
                CacheFactory newFactory;
                this.factory = newFactory = (CacheFactory)Class.forName(this.factoryClazz).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                log.error(FATAL, "can't init cache", (Throwable)e);
                throw new AssertionError((Object)("Unproperly configured factory: " + this.factoryClazz + " --> " + e.getMessage()));
            }
        }
        log.debug("re-initing cache for " + this.configurationName);
        if (!this.cacheOn) {
            if (this.prevCacheOn) {
                log.debug("switching cache off.");
                this.cache.clear();
                this.cache = null;
            } else {
                log.debug("cache remains off.");
            }
        } else if (this.prevCacheOn) {
            if (this.prevMaxSize == this.maxSize && this.prevStartSize == this.startSize && this.preExpirationTime == this.expirationTime) {
                log.debug("Cache remains on, settings unchanged.");
            } else {
                log.debug("Cache remains on, settings changed, cache will be renewed.");
                if (this.cache != null) {
                    this.cache.clear();
                } else {
                    log.warn("Cache is null, when it shouldn't be.");
                }
                if (this.factory == null) {
                    throw new IllegalStateException("No factory is configured or submitted for cache creation!");
                }
                this.cache = this.createCaches();
            }
        } else {
            log.debug("switching cache on.");
            this.cache = this.createCaches();
        }
    }

    protected Cache<K, V> createCache(int aStartSize, int aMaxSize) {
        if (this.factory == null) {
            throw new IllegalStateException("No factory is configured or submitted for cache creation!");
        }
        return this.factory.create(this.configurationName, aStartSize, aMaxSize);
    }

    protected Cache<K, V> createExpiringCache(int aStartSize, int aMaxSize, long expirationTime) {
        if (this.factory == null) {
            throw new IllegalStateException("No factory is configured or submitted for cache creation!");
        }
        return this.factory.createExpiring(this.configurationName, aStartSize, aMaxSize, expirationTime);
    }

    protected Cache<K, V> createCacheFailover(int aStartSize, int aMaxSize, int aInstanceAmount, int aCurrentInstanceNumber) {
        if (this.factory == null) {
            throw new IllegalStateException("No factory is configured or submitted for cache creation!");
        }
        Cache<K, V> underlyingCache = this.factory.create(this.configurationName, aStartSize, aMaxSize);
        return new FailoverCache<K, V>(this.configurationName, this.instanceAmount, this.currentInstanceNumber, this.typeHandler, underlyingCache);
    }

    protected Cache<K, V> createExpiringCacheFailover(int aStartSize, int aMaxSize, long expirationTime, int aInstanceAmount, int aCurrentInstanceNumber) {
        if (this.factory == null) {
            throw new IllegalStateException("No factory is configured or submitted for cache creation!");
        }
        ExpiringCache<K, V> underlyingCache = this.factory.createExpiring(this.configurationName, aStartSize, aMaxSize, expirationTime);
        return new FailoverCache<K, V>(this.configurationName, aStartSize, aMaxSize, this.typeHandler, underlyingCache);
    }

    protected Cache<K, V> createCaches() {
        if (this.instanceAmount <= 1 || this.currentInstanceNumber <= -1) {
            if (this.expirationTime == 0L) {
                return this.createCache(this.startSize, this.maxSize);
            }
            return this.createExpiringCache(this.startSize, this.maxSize, this.expirationTime);
        }
        if (this.expirationTime == 0L) {
            return this.createCacheFailover(this.startSize, this.maxSize, this.instanceAmount, this.currentInstanceNumber);
        }
        return this.createExpiringCacheFailover(this.startSize, this.maxSize, this.expirationTime, this.instanceAmount, this.currentInstanceNumber);
    }

    @Override
    public void clear() {
        if (this.cacheOn) {
            this.cache.clear();
        }
    }

    @Override
    public V get(K id) {
        if (!this.cacheOn) {
            return null;
        }
        return this.cache.get(id);
    }

    @Override
    public void put(K id, V cacheable) {
        if (!this.cacheOn) {
            return;
        }
        try {
            this.cache.put(id, cacheable);
        }
        catch (OutOfMemoryError error) {
            ++this.outOfMemoryErrors;
            throw error;
        }
    }

    @Override
    public void remove(K id) {
        if (!this.cacheOn) {
            return;
        }
        this.cache.remove(id);
    }

    @AfterConfiguration
    public void configurationFinished() {
        log.info("configuration " + this.configurationName + " finished, settings are:");
        log.info("cacheOn " + this.prevCacheOn + " -> " + this.cacheOn);
        log.info("startSize " + this.prevStartSize + " -> " + this.startSize);
        log.info("maxSize " + this.prevMaxSize + " -> " + this.maxSize);
        log.info("expirationTime " + this.preExpirationTime + " -> " + this.expirationTime);
        this.init();
    }

    @BeforeConfiguration
    public void configurationStarted() {
        this.prevCacheOn = this.cacheOn;
        this.prevMaxSize = this.maxSize;
        this.prevStartSize = this.startSize;
        this.preExpirationTime = this.expirationTime;
        this.cacheOn = true;
        this.startSize = 1000;
        this.maxSize = 5000;
        this.expirationTime = 0L;
    }

    public String getStats() {
        String stats;
        String string = stats = this.cacheOn ? "On, " + this.startSize + ", " + this.maxSize : "Off";
        if (this.cacheOn) {
            stats = stats + " " + this.cache.getCacheStats().toString() + ", OOME: " + this.outOfMemoryErrors;
        }
        return stats;
    }

    public String getDetails() {
        if (!this.cacheOn) {
            return "off";
        }
        return this.cache.toString();
    }

    protected Cache<K, V> getCache() {
        return this.cache;
    }

    @Override
    public CacheStats getCacheStats() {
        if (!this.cacheOn) {
            return new CacheStats();
        }
        CacheStats stats = this.getCache().getCacheStats();
        return stats;
    }

    public void setCacheOn(boolean cacheOn) {
        this.cacheOn = cacheOn;
    }

    public void setStartSize(int startSize) {
        this.startSize = startSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    protected boolean isCacheOn() {
        return this.cacheOn;
    }

    protected int getStartSize() {
        return this.startSize;
    }

    protected int getMaxSize() {
        return this.maxSize;
    }

    public void setFactoryClazz(String factoryClazz) {
        this.factoryClazz = factoryClazz;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
    }

    public int getInstanceAmount() {
        return this.instanceAmount;
    }

    public void setInstanceAmount(int instanceAmount) {
        this.instanceAmount = instanceAmount;
    }

    public int getCurrentInstanceNumber() {
        return this.currentInstanceNumber;
    }

    public void setCurrentInstanceNumber(int currentInstanceNumber) {
        this.currentInstanceNumber = currentInstanceNumber;
    }
}

