/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.cache;

import net.anotheria.anoprise.cache.Cache;
import net.anotheria.anoprise.cache.CacheFactory;
import net.anotheria.anoprise.cache.CachedObjectWrapper;
import net.anotheria.moskito.core.predefined.CacheStats;

public class ExpiringCache<K, V>
implements Cache<K, V> {
    private long expirationTime;
    private Cache<K, CachedObjectWrapper<V>> cache;
    private CacheStats moskitoCacheStats;

    public ExpiringCache(String name, int aStartSize, int aMaxSize, long anExpirationTime, CacheFactory<K, CachedObjectWrapper<V>> underlyingCacheFactory) {
        this(name, anExpirationTime, underlyingCacheFactory.create(name, aStartSize, aMaxSize));
    }

    public ExpiringCache(String name, long anExpirationTime, Cache<K, CachedObjectWrapper<V>> underlyingCache) {
        this.cache = underlyingCache;
        this.expirationTime = anExpirationTime;
        this.moskitoCacheStats = this.cache.getCacheStats();
    }

    @Override
    public V get(K id) {
        CachedObjectWrapper<V> wrapper = this.cache.get(id);
        if (wrapper == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (now - wrapper.getTimestamp() > this.expirationTime) {
            this.moskitoCacheStats.addExpired();
            this.remove(id);
            return null;
        }
        return wrapper.getObj();
    }

    @Override
    public void put(K id, V cacheable) {
        this.cache.put(id, new CachedObjectWrapper<V>(cacheable));
    }

    public String toString() {
        return this.cache.toString() + ", ExpirationTime: " + this.expirationTime;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void remove(K id) {
        this.cache.remove(id);
    }

    @Override
    public CacheStats getCacheStats() {
        return this.moskitoCacheStats;
    }

    void setExpirationTime(long anExpirationTime) {
        this.expirationTime = anExpirationTime;
    }
}

