/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import net.anotheria.anoprise.cache.AbstractCache;
import net.anotheria.anoprise.cache.Cache;
import net.anotheria.moskito.core.predefined.CacheStats;

public class RoundRobinSoftReferenceExperimentalCache<K, V>
extends AbstractCache
implements Cache<K, V> {
    public static final int DEF_START_SIZE = 1000;
    public static final int DEF_MAX_SIZE = 3000;
    public static final float DEF_INCREMENT = 0.5f;
    private SoftReference<V>[] cache;
    private HashMap<K, Integer> id2index;
    private HashMap<Integer, K> index2id;
    private int maxSize;
    private int startSize;
    private float increment;
    private int currentSize;
    private int lastElement;
    private boolean firstCycleComplete;
    private boolean enlargeable;
    private CacheStats cacheStatsCopy = null;

    public RoundRobinSoftReferenceExperimentalCache() {
        this(RoundRobinSoftReferenceExperimentalCache.getUnnamedInstanceName(RoundRobinSoftReferenceExperimentalCache.class));
    }

    public RoundRobinSoftReferenceExperimentalCache(int aStartSize, int aMaxSize) {
        this(RoundRobinSoftReferenceExperimentalCache.getUnnamedInstanceName(RoundRobinSoftReferenceExperimentalCache.class), aStartSize, aMaxSize);
    }

    public RoundRobinSoftReferenceExperimentalCache(int aStartSize, int aMaxSize, float anIncrement) {
        this(RoundRobinSoftReferenceExperimentalCache.getUnnamedInstanceName(RoundRobinSoftReferenceExperimentalCache.class), aStartSize, aMaxSize, anIncrement);
    }

    public RoundRobinSoftReferenceExperimentalCache(String name) {
        this(name, 1000, 3000, 0.5f);
    }

    public RoundRobinSoftReferenceExperimentalCache(String name, int aStartSize, int aMaxSize) {
        this(name, aStartSize, aMaxSize, 0.5f);
    }

    public RoundRobinSoftReferenceExperimentalCache(String name, int aStartSize, int aMaxSize, float anIncrement) {
        super(name);
        this.startSize = aStartSize;
        this.maxSize = aMaxSize;
        this.increment = anIncrement;
        this.cacheStatsCopy = this.getCacheStats();
        this.init();
    }

    @Override
    public synchronized void remove(K id) {
        this.cacheStatsCopy.addDelete();
        Integer index = this.getCachePosition(id);
        if (index == null) {
            return;
        }
        this.id2index.remove(id);
        this.index2id.remove(index);
        SoftReference<V> ref = this.cache[index];
        this.cache[index.intValue()] = null;
        if (ref.get() == null) {
            this.cacheStatsCopy.addGarbageCollected();
        } else {
            ref.clear();
        }
    }

    @Override
    public synchronized V get(K id) {
        this.cacheStatsCopy.addRequest();
        Integer index = this.getCachePosition(id);
        if (index == null) {
            return null;
        }
        V toRet = this.cache[index].get();
        if (toRet == null) {
            this.cacheStatsCopy.addGarbageCollected();
            this.id2index.remove(id);
            this.index2id.remove(index);
        } else {
            this.cacheStatsCopy.addHit();
        }
        return toRet;
    }

    private Integer getCachePosition(K id) {
        return this.id2index.get(id);
    }

    @Override
    public synchronized void put(K id, V cacheable) {
        SoftReference<V> toPut = new SoftReference<V>(cacheable);
        this.cacheStatsCopy.addWrite();
        Integer oldPosition = this.getCachePosition(id);
        if (oldPosition != null) {
            this.cache[oldPosition.intValue()] = toPut;
            return;
        }
        if (this.lastElement < this.currentSize - 1 && !this.firstCycleComplete) {
            ++this.lastElement;
            Integer tmpIndex = this.lastElement;
            this.index2id.put(tmpIndex, (Integer)id);
            this.id2index.put(id, tmpIndex);
            this.cache[this.lastElement] = toPut;
            return;
        }
        if (this.firstCycleComplete) {
            Integer tmp;
            K oldId;
            ++this.lastElement;
            if (this.lastElement == this.cache.length) {
                this.lastElement = 0;
            }
            if ((oldId = this.index2id.get(tmp = Integer.valueOf(this.lastElement))) != null) {
                this.id2index.remove(oldId);
            }
            this.id2index.put(id, tmp);
            this.index2id.put(tmp, (Integer)id);
            this.cache[this.lastElement] = toPut;
            this.cacheStatsCopy.addRollover();
            return;
        }
        if (!this.firstCycleComplete) {
            if (this.enlargeable) {
                float wishedSize = (float)this.currentSize * (1.0f + this.increment);
                int newsize = (int)wishedSize;
                if (newsize > this.maxSize) {
                    newsize = this.maxSize;
                }
                SoftReference<V>[] oldCache = this.cache;
                this.cache = new SoftReference[newsize];
                System.arraycopy(oldCache, 0, this.cache, 0, this.currentSize);
                this.currentSize = newsize;
                this.enlargeable = newsize < this.maxSize;
                this.firstCycleComplete = false;
                this.put(id, cacheable);
                return;
            }
            this.firstCycleComplete = true;
            this.put(id, cacheable);
            return;
        }
        throw new AssertionError((Object)("You couldn't reach this point in code! (" + this + ")"));
    }

    private void init() {
        this.clear();
    }

    @Override
    public synchronized void clear() {
        this.cache = new SoftReference[this.startSize];
        this.id2index = new HashMap(this.startSize);
        this.index2id = new HashMap(this.startSize);
        this.lastElement = -1;
        this.firstCycleComplete = false;
        this.enlargeable = this.startSize < this.maxSize;
        this.currentSize = this.startSize;
    }

    public String toString() {
        if (this.cache == null) {
            return "Not initialized cache " + this.getName();
        }
        String ret = this.getName() + " ";
        ret = ret + "CurrentSize: " + this.cache.length + ", MaxSize: " + this.maxSize;
        ret = ret + " Enlargement possible: " + this.enlargeable + ", FirstCycleComplete: " + this.firstCycleComplete;
        ret = ret + " lastElement: " + this.lastElement;
        return ret;
    }
}

