/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.dataspace;

import net.anotheria.anoprise.cache.Cache;
import net.anotheria.anoprise.cache.Caches;
import net.anotheria.anoprise.dataspace.Dataspace;
import net.anotheria.anoprise.dataspace.DataspacePersistenceFailedException;
import net.anotheria.anoprise.dataspace.DataspaceService;
import net.anotheria.anoprise.dataspace.DataspaceServiceException;
import net.anotheria.anoprise.dataspace.DataspaceType;
import net.anotheria.anoprise.dataspace.persistence.DataspaceNotFoundException;
import net.anotheria.anoprise.dataspace.persistence.DataspacePersistenceService;
import net.anotheria.anoprise.dataspace.persistence.DataspacePersistenceServiceException;
import net.anotheria.anoprise.dataspace.persistence.DataspacePersistenceServiceFactory;
import net.anotheria.util.BasicComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataspaceServiceImpl
implements DataspaceService {
    private Cache<DataspaceKey, Dataspace> cache;
    private static final int CACHE_START_SIZE = 5000;
    private static final int CACHE_MAX_SIZE = 50000;
    private DataspacePersistenceService persistenceService = DataspacePersistenceServiceFactory.getInstance();
    private static final Logger log = LoggerFactory.getLogger(DataspaceServiceImpl.class);

    public DataspaceServiceImpl() {
        try {
            this.cache = Caches.createConfigurableHardwiredCache("ano-prise-dataspace-cache");
        }
        catch (IllegalArgumentException e) {
            log.warn("Can't find cache configuration for ano-prise-dataspace-cache, falling back to min cache.");
            this.cache = Caches.createHardwiredCache("ano-prise-dataspace-cache", 5000, 50000);
        }
    }

    @Override
    public Dataspace getDataspace(String userId, DataspaceType dataspaceType) throws DataspaceServiceException {
        if (userId == null) {
            throw new IllegalArgumentException("User id null");
        }
        if (dataspaceType == null) {
            throw new IllegalArgumentException("Dataspace type null");
        }
        DataspaceKey key = new DataspaceKey(userId, dataspaceType);
        Dataspace fromCache = this.cache.get(key);
        if (fromCache != null) {
            return fromCache;
        }
        Dataspace fromPersistence = null;
        try {
            fromPersistence = this.persistenceService.loadDataspace(userId, dataspaceType);
        }
        catch (DataspaceNotFoundException notFound) {
            Dataspace newInstance = new Dataspace(userId, dataspaceType);
            this.cache.put(key, newInstance);
            return newInstance;
        }
        catch (DataspacePersistenceServiceException e) {
            log.error("Persistence service filed.", (Throwable)e);
            throw new DataspacePersistenceFailedException(e);
        }
        this.cache.put(key, fromPersistence);
        return fromPersistence;
    }

    @Override
    public void saveDataspace(Dataspace dataspace) throws DataspaceServiceException {
        if (dataspace == null) {
            throw new IllegalArgumentException("Dataspace null");
        }
        if (dataspace.getUserId() == null) {
            throw new IllegalArgumentException("User id null");
        }
        if (dataspace.getDataspaceType() == null) {
            throw new IllegalArgumentException("Dataspace type null");
        }
        try {
            this.persistenceService.saveDataspace(dataspace);
        }
        catch (DataspacePersistenceServiceException e) {
            log.error("Persistence service filed.", (Throwable)e);
            throw new DataspacePersistenceFailedException(e);
        }
        this.cache.put(new DataspaceKey(dataspace.getUserId(), dataspace.getDataspaceType()), dataspace);
    }

    private final class DataspaceKey {
        private String userId;
        private int dataspaceId;

        public DataspaceKey(String aUserId, DataspaceType aDataspaceType) {
            this.userId = aUserId;
            this.dataspaceId = aDataspaceType.getId();
        }

        public boolean equals(Object o) {
            return o instanceof DataspaceKey ? BasicComparable.compareString((String)this.userId, (String)((DataspaceKey)o).userId) == 0 && this.dataspaceId == ((DataspaceKey)o).dataspaceId : false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.dataspaceId;
            result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
            return result;
        }

        public String toString() {
            return "DataspaceKey [dataspaceId=" + this.dataspaceId + ", userId=" + this.userId + "]";
        }
    }
}

