/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.dataspace.attribute;

import java.io.Serializable;
import net.anotheria.anoprise.dataspace.attribute.AttributeType;
import net.anotheria.anoprise.dataspace.attribute.BooleanAttribute;
import net.anotheria.anoprise.dataspace.attribute.IntAttribute;
import net.anotheria.anoprise.dataspace.attribute.LongAttribute;
import net.anotheria.anoprise.dataspace.attribute.StringAttribute;
import net.anotheria.util.BasicComparable;

public abstract class Attribute
implements Serializable {
    private static final long serialVersionUID = -7944645330790901903L;
    private String name;

    public Attribute(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public abstract String getValueAsString();

    public abstract AttributeType getType();

    public static Attribute createAttribute(int aTypeId, String aName, String aStringValue) {
        return Attribute.createAttribute(AttributeType.getTypeById(aTypeId), aName, aStringValue);
    }

    public static Attribute createAttribute(AttributeType aType, String aName, String aStringValue) {
        switch (aType) {
            case LONG: {
                return new LongAttribute(aName, aStringValue);
            }
            case INT: {
                return new IntAttribute(aName, aStringValue);
            }
            case STRING: {
                return new StringAttribute(aName, aStringValue);
            }
            case BOOLEAN: {
                return new BooleanAttribute(aName, aStringValue);
            }
        }
        throw new AssertionError((Object)("Unsupported AttributeType: " + (Object)((Object)aType)));
    }

    public String toString() {
        return this.getName() + " = " + this.getValueAsString();
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public final boolean equals(Object o) {
        return o instanceof Attribute ? BasicComparable.compareString((String)this.getName(), (String)((Attribute)o).getName()) == 0 && this.getType() == ((Attribute)o).getType() && BasicComparable.compareString((String)this.getValueAsString(), (String)((Attribute)o).getValueAsString()) == 0 : false;
    }
}

