/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.dualcrud;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoprise.dualcrud.CrudSaveable;
import net.anotheria.anoprise.dualcrud.CrudService;
import net.anotheria.anoprise.dualcrud.CrudServiceException;
import net.anotheria.anoprise.dualcrud.ItemNotFoundException;
import net.anotheria.anoprise.dualcrud.Query;
import net.anotheria.anoprise.dualcrud.SaveableID;

public class CrudServiceFixture<T extends CrudSaveable>
implements CrudService<T> {
    private final ConcurrentHashMap<String, T> holder = new ConcurrentHashMap();

    @Override
    public T create(T t) throws CrudServiceException {
        if (this.exists(t)) {
            throw new CrudServiceException("Object already exist. Owner id: " + t.getOwnerId());
        }
        return (T)((CrudSaveable)this.holder.put(t.getOwnerId(), t));
    }

    @Override
    public T read(SaveableID id) throws CrudServiceException, ItemNotFoundException {
        String saveableId = id.getSaveableId();
        if (!this.exist(saveableId)) {
            throw new ItemNotFoundException(saveableId);
        }
        return (T)((CrudSaveable)this.holder.get(saveableId));
    }

    @Override
    public T update(T t) throws CrudServiceException {
        if (!this.exists(t)) {
            throw new ItemNotFoundException(t.getOwnerId());
        }
        return (T)((CrudSaveable)this.holder.put(t.getOwnerId(), t));
    }

    @Override
    public void delete(T t) throws CrudServiceException {
        this.holder.remove(t.getOwnerId());
    }

    @Override
    public T save(T t) throws CrudServiceException {
        return (T)((CrudSaveable)this.holder.put(t.getOwnerId(), t));
    }

    @Override
    public boolean exists(T t) throws CrudServiceException {
        return this.exist(t.getOwnerId());
    }

    private boolean exist(String ownerId) {
        return this.holder.containsKey(ownerId);
    }

    @Override
    public List<T> query(Query q) throws CrudServiceException {
        return new ArrayList();
    }
}

