/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.dualcrud;

import net.anotheria.anoprise.dualcrud.CrudSaveable;
import net.anotheria.anoprise.dualcrud.CrudService;

public class DualCrudConfig {
    private Direction migrationDirection;
    private boolean readFromBoth;
    private boolean migrateOnRead;
    private boolean writeToBoth;
    private boolean deleteUponMigration;
    private boolean migrateOnWrite;

    public static final DualCrudConfig migrateOnTheFly() {
        DualCrudConfig config = new DualCrudConfig();
        config.migrationDirection = Direction.LEFTTORIGHT;
        config.readFromBoth = true;
        config.migrateOnRead = true;
        config.migrateOnWrite = true;
        config.writeToBoth = false;
        config.deleteUponMigration = true;
        return config;
    }

    public static final DualCrudConfig migrateOnTheFlyButMaintainBoth() {
        DualCrudConfig config = new DualCrudConfig();
        config.migrationDirection = Direction.LEFTTORIGHT;
        config.readFromBoth = true;
        config.migrateOnRead = true;
        config.migrateOnWrite = false;
        config.writeToBoth = true;
        config.deleteUponMigration = false;
        return config;
    }

    public static final DualCrudConfig migrateBackOnTheFly() {
        DualCrudConfig config = DualCrudConfig.migrateOnTheFly();
        config.migrationDirection = Direction.RIGHTTOLEFT;
        return config;
    }

    public static final DualCrudConfig migrateOnCallOnly() {
        DualCrudConfig config = new DualCrudConfig();
        config.migrationDirection = Direction.LEFTTORIGHT;
        config.readFromBoth = true;
        config.migrateOnRead = false;
        config.migrateOnWrite = false;
        config.writeToBoth = false;
        config.deleteUponMigration = true;
        return config;
    }

    public static final DualCrudConfig migrateBackOnCallOnly() {
        DualCrudConfig config = DualCrudConfig.migrateOnCallOnly();
        config.migrationDirection = Direction.RIGHTTOLEFT;
        return config;
    }

    public static final DualCrudConfig duplicate() {
        DualCrudConfig config = new DualCrudConfig();
        config.migrationDirection = Direction.LEFTTORIGHT;
        config.readFromBoth = false;
        config.migrateOnRead = false;
        config.migrateOnWrite = false;
        config.writeToBoth = true;
        config.deleteUponMigration = false;
        return config;
    }

    public static final DualCrudConfig useLeftOnly() {
        DualCrudConfig config = new DualCrudConfig();
        config.migrationDirection = Direction.LEFT;
        config.readFromBoth = false;
        config.migrateOnRead = false;
        config.migrateOnWrite = false;
        config.writeToBoth = false;
        config.deleteUponMigration = false;
        return config;
    }

    public static final DualCrudConfig useRightOnly() {
        DualCrudConfig config = DualCrudConfig.useLeftOnly();
        config.migrationDirection = Direction.RIGHT;
        return config;
    }

    public <T extends CrudSaveable> CrudService<T> getPrimaryReader(CrudService<T> left, CrudService<T> right) {
        switch (this.migrationDirection) {
            case LEFT: {
                return left;
            }
            case RIGHT: {
                return right;
            }
            case LEFTTORIGHT: {
                return right;
            }
            case RIGHTTOLEFT: {
                return left;
            }
        }
        throw new AssertionError((Object)("Can't happen, migration direction " + (Object)((Object)this.migrationDirection) + " is not supported."));
    }

    public <T extends CrudSaveable> CrudService<T> getSecondaryReader(CrudService<T> left, CrudService<T> right) {
        switch (this.migrationDirection) {
            case LEFT: {
                return left;
            }
            case RIGHT: {
                return right;
            }
            case LEFTTORIGHT: {
                return left;
            }
            case RIGHTTOLEFT: {
                return right;
            }
        }
        throw new AssertionError((Object)("Can't happen, migration direction " + (Object)((Object)this.migrationDirection) + " is not supported."));
    }

    public <T extends CrudSaveable> CrudService<T> getPrimaryWriter(CrudService<T> left, CrudService<T> right) {
        switch (this.migrationDirection) {
            case LEFT: {
                return left;
            }
            case RIGHT: {
                return right;
            }
            case LEFTTORIGHT: {
                return right;
            }
            case RIGHTTOLEFT: {
                return left;
            }
        }
        throw new AssertionError((Object)("Can't happen, migration direction " + (Object)((Object)this.migrationDirection) + " is not supported."));
    }

    public <T extends CrudSaveable> CrudService<T> getSecondaryWriter(CrudService<T> left, CrudService<T> right) {
        switch (this.migrationDirection) {
            case LEFT: {
                return left;
            }
            case RIGHT: {
                return right;
            }
            case LEFTTORIGHT: {
                return left;
            }
            case RIGHTTOLEFT: {
                return right;
            }
        }
        throw new AssertionError((Object)("Can't happen, migration direction " + (Object)((Object)this.migrationDirection) + " is not supported."));
    }

    public boolean readFromBoth() {
        return this.readFromBoth;
    }

    public void setReadFromBoth(boolean readFromBoth) {
        this.readFromBoth = readFromBoth;
    }

    public boolean migrateOnRead() {
        return this.migrateOnRead;
    }

    public void setMigrateOnRead(boolean migrateOnRead) {
        this.migrateOnRead = migrateOnRead;
    }

    public boolean writeToBoth() {
        return this.writeToBoth;
    }

    public void setWriteToBoth(boolean writeToBoth) {
        this.writeToBoth = writeToBoth;
    }

    public boolean deleteUponMigration() {
        return this.deleteUponMigration;
    }

    public void setDeleteUponMigration(boolean deleteUponMigration) {
        this.deleteUponMigration = deleteUponMigration;
    }

    public boolean migrateOnWrite() {
        return this.migrateOnWrite;
    }

    public void setMigrateOnWrite(boolean migrateOnWrite) {
        this.migrateOnWrite = migrateOnWrite;
    }

    private static enum Direction {
        LEFT,
        RIGHT,
        LEFTTORIGHT,
        RIGHTTOLEFT;

    }
}

