/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.dualcrud;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.anotheria.anoprise.dualcrud.CrudSaveable;

public class QueryResult<T extends CrudSaveable>
implements Serializable {
    private static final long serialVersionUID = 4138579115416433003L;
    private List<T> primaryResult;
    private List<T> secondaryResult;

    public QueryResult(List<T> primary, List<T> secondary) {
        this.primaryResult = primary != null ? primary : new ArrayList<T>();
        this.secondaryResult = secondary != null ? secondary : new ArrayList<T>();
    }

    public List<T> getResult(boolean merge) {
        if (!merge) {
            return this.getResultPrimary();
        }
        return this.merge();
    }

    public List<T> getResultPrimary() {
        return new ArrayList<T>(this.primaryResult);
    }

    public List<T> getResultSecondary() {
        return new ArrayList<T>(this.secondaryResult);
    }

    private List<T> merge() {
        HashSet<T> result = new HashSet<T>(this.primaryResult);
        for (CrudSaveable o : this.secondaryResult) {
            if (result.contains(o)) continue;
            result.add(o);
        }
        return new ArrayList<T>(result);
    }
}

