/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.eventservice;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.anotheria.anoprise.eventservice.EventChannel;
import net.anotheria.anoprise.eventservice.EventChannelConsumerProxy;
import net.anotheria.anoprise.eventservice.EventChannelPushConsumerProxy;
import net.anotheria.anoprise.eventservice.EventChannelPushSupplierProxy;
import net.anotheria.anoprise.eventservice.EventChannelSupplierProxy;
import net.anotheria.anoprise.eventservice.EventService;
import net.anotheria.anoprise.eventservice.EventServiceListener;
import net.anotheria.anoprise.eventservice.EventServiceParticipant;
import net.anotheria.anoprise.eventservice.EventServicePushConsumer;
import net.anotheria.anoprise.eventservice.EventServicePushSupplier;
import net.anotheria.anoprise.eventservice.ProxyType;
import net.anotheria.anoprise.eventservice.RemoteEventChannelConsumerProxy;
import net.anotheria.anoprise.eventservice.RemoteEventChannelSupplierProxy;
import net.anotheria.anoprise.eventservice.RemoteEventChannelSupportFactory;
import net.anotheria.anoprise.eventservice.RemoteEventServiceConsumer;
import net.anotheria.anoprise.eventservice.RemoteEventServiceSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventServiceImpl
implements EventService {
    private static Logger log = LoggerFactory.getLogger(EventServiceImpl.class);
    private static EventServiceImpl instance = new EventServiceImpl();
    private ConcurrentMap<String, EventChannelPushConsumerProxy> pushConsumerProxies;
    private ConcurrentMap<String, EventChannelPushSupplierProxy> pushSupplierProxies;
    private ConcurrentMap<String, RemoteEventChannelConsumerProxy> remoteConsumerProxies;
    private ConcurrentMap<String, RemoteEventChannelSupplierProxy> remoteSupplierProxies;
    private List<EventServiceListener> listeners;
    private RemoteEventChannelSupportFactory remoteSupportFactory;

    private EventServiceImpl() {
        this.init();
    }

    private void init() {
        this.pushConsumerProxies = new ConcurrentHashMap<String, EventChannelPushConsumerProxy>(10);
        this.pushSupplierProxies = new ConcurrentHashMap<String, EventChannelPushSupplierProxy>(10);
        this.remoteConsumerProxies = new ConcurrentHashMap<String, RemoteEventChannelConsumerProxy>(10);
        this.remoteSupplierProxies = new ConcurrentHashMap<String, RemoteEventChannelSupplierProxy>(10);
        this.listeners = new CopyOnWriteArrayList<EventServiceListener>();
    }

    public void resetForUnitTesting() {
        this.init();
    }

    public static EventServiceImpl getInstance() {
        return instance;
    }

    @Override
    public EventChannel obtainEventChannel(String channelName, EventServiceParticipant participant) {
        ProxyType type = ProxyType.NONE;
        if (participant instanceof EventServicePushConsumer) {
            type = ProxyType.PUSH_CONSUMER_PROXY;
        }
        if (participant instanceof EventServicePushSupplier) {
            type = ProxyType.PUSH_SUPPLIER_PROXY;
        }
        if (participant instanceof RemoteEventServiceConsumer) {
            type = ProxyType.REMOTE_CONSUMER_PROXY;
        }
        if (participant instanceof RemoteEventServiceSupplier) {
            type = ProxyType.REMOTE_SUPPLIER_PROXY;
        }
        if (type == ProxyType.NONE) {
            throw new IllegalArgumentException("Unsupported participant type: " + participant);
        }
        return this.obtainEventChannel(channelName, type);
    }

    @Override
    public EventChannel obtainEventChannel(String channelName, ProxyType proxyType) {
        EventChannel ret = null;
        log.debug("Creating event channel: " + channelName + " of type " + (Object)((Object)proxyType));
        switch (proxyType) {
            case PUSH_CONSUMER_PROXY: {
                ret = this._obtainPushConsumerProxy(channelName);
                break;
            }
            case PUSH_SUPPLIER_PROXY: {
                ret = this._obtainPushSupplierProxy(channelName);
                break;
            }
            case REMOTE_CONSUMER_PROXY: {
                ret = this._obtainRemoteConsumerProxy(channelName);
                break;
            }
            case REMOTE_SUPPLIER_PROXY: {
                ret = this._obtainRemoteSupplierProxy(channelName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported proxy type: " + (Object)((Object)proxyType));
            }
        }
        this.dump();
        return ret;
    }

    private EventChannel _obtainRemoteConsumerProxy(String channelName) {
        RemoteEventChannelConsumerProxy proxy = (RemoteEventChannelConsumerProxy)this.remoteConsumerProxies.get(channelName);
        if (proxy != null) {
            return proxy;
        }
        proxy = this.remoteSupportFactory.createRemoteEventChannelConsumerProxy(channelName);
        RemoteEventChannelConsumerProxy old = this.remoteConsumerProxies.putIfAbsent(channelName, proxy);
        if (old != null) {
            return old;
        }
        log.debug("Created " + proxy);
        this.connectConsumerProxy(channelName, proxy);
        return proxy;
    }

    private EventChannel _obtainPushConsumerProxy(String channelName) {
        EventChannelPushConsumerProxy proxy = (EventChannelPushConsumerProxy)this.pushConsumerProxies.get(channelName);
        if (proxy != null) {
            return proxy;
        }
        proxy = new EventChannelPushConsumerProxy(channelName);
        EventChannelPushConsumerProxy old = this.pushConsumerProxies.putIfAbsent(channelName, proxy);
        if (old != null) {
            return old;
        }
        log.debug("created " + proxy);
        this.connectConsumerProxy(channelName, proxy);
        this.notifyChannelCreation(channelName, ProxyType.PUSH_CONSUMER_PROXY);
        return proxy;
    }

    private EventChannel _obtainPushSupplierProxy(String channelName) {
        EventChannelPushSupplierProxy proxy = (EventChannelPushSupplierProxy)this.pushSupplierProxies.get(channelName);
        if (proxy != null) {
            return proxy;
        }
        proxy = new EventChannelPushSupplierProxy(channelName);
        EventChannelPushSupplierProxy old = this.pushSupplierProxies.putIfAbsent(channelName, proxy);
        if (old != null) {
            return old;
        }
        log.debug("Created " + proxy);
        this.connectSupplierProxy(channelName, proxy);
        this.notifyChannelCreation(channelName, ProxyType.PUSH_SUPPLIER_PROXY);
        return proxy;
    }

    private EventChannel _obtainRemoteSupplierProxy(String channelName) {
        RemoteEventChannelSupplierProxy proxy = (RemoteEventChannelSupplierProxy)this.remoteSupplierProxies.get(channelName);
        if (proxy != null) {
            return proxy;
        }
        proxy = this.remoteSupportFactory.createRemoteEventChannelSupplierProxy(channelName);
        RemoteEventChannelSupplierProxy old = this.remoteSupplierProxies.putIfAbsent(channelName, proxy);
        if (old != null) {
            return old;
        }
        log.debug("Created " + proxy);
        this.connectSupplierProxy(channelName, proxy);
        return proxy;
    }

    private void connectSupplierProxy(String channelName, EventChannelSupplierProxy proxy) {
        List<EventChannelConsumerProxy> consumers = this.getConsumerProxies(channelName);
        log.debug("Connecting " + consumers + " to " + proxy);
        int n = consumers.size();
        for (int i = 0; i < n; ++i) {
            log.debug("connecting " + consumers.get(i));
            proxy.addConsumerProxy(consumers.get(i));
        }
    }

    private void connectConsumerProxy(String channelName, EventChannelConsumerProxy proxy) {
        List<EventChannelSupplierProxy> suppliers = this.getSupplierProxies(channelName);
        log.debug("connecting " + proxy + " to " + suppliers);
        int n = suppliers.size();
        for (int i = 0; i < n; ++i) {
            log.debug("connecting " + proxy + " to " + suppliers.get(i));
            suppliers.get(i).addConsumerProxy(proxy);
        }
    }

    private List<EventChannelConsumerProxy> getConsumerProxies(String channelName) {
        EventChannelConsumerProxy remoteConsumerProxy;
        ArrayList<EventChannelConsumerProxy> ret = new ArrayList<EventChannelConsumerProxy>();
        EventChannelConsumerProxy pushConsumerProxy = (EventChannelConsumerProxy)this.pushConsumerProxies.get(channelName);
        if (pushConsumerProxy != null) {
            ret.add(pushConsumerProxy);
        }
        if ((remoteConsumerProxy = (EventChannelConsumerProxy)this.remoteConsumerProxies.get(channelName)) != null) {
            ret.add(remoteConsumerProxy);
        }
        return ret;
    }

    private List<EventChannelSupplierProxy> getSupplierProxies(String channelName) {
        EventChannelSupplierProxy remoteSupplierProxy;
        ArrayList<EventChannelSupplierProxy> ret = new ArrayList<EventChannelSupplierProxy>();
        EventChannelSupplierProxy pushSupplierProxy = (EventChannelSupplierProxy)this.pushSupplierProxies.get(channelName);
        if (pushSupplierProxy != null) {
            ret.add(pushSupplierProxy);
        }
        if ((remoteSupplierProxy = (EventChannelSupplierProxy)this.remoteSupplierProxies.get(channelName)) != null) {
            ret.add(remoteSupplierProxy);
        }
        return ret;
    }

    private void dump() {
        log.debug("Consumer proxies: " + this.pushConsumerProxies);
        log.debug("Supplier proxies: " + this.pushSupplierProxies);
        log.debug("Remote Consumer proxies: " + this.remoteConsumerProxies);
        log.debug("Remote Supplier proxies: " + this.remoteSupplierProxies);
    }

    @Override
    public void addListener(EventServiceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(EventServiceListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyChannelCreation(String channelName, ProxyType type) {
        for (EventServiceListener listener : this.listeners) {
            try {
                listener.channelCreated(channelName, type);
            }
            catch (Exception e) {
                log.error("Un-excepted exception in listener " + listener + ", in call notifyChannelCreation(" + channelName + ", " + (Object)((Object)type) + ")", (Throwable)e);
            }
        }
    }

    public void setRemoteSupportFactory(RemoteEventChannelSupportFactory aFactory) {
        this.remoteSupportFactory = aFactory;
    }
}

