/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.fs;

import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.anotheria.anoprise.fs.FSServiceConfigException;
import org.configureme.ConfigurationManager;
import org.configureme.Environment;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.DontConfigure;
import org.configureme.environments.DynamicEnvironment;
import org.configureme.sources.ConfigurationSourceKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe
public final class FSServiceConfig
implements Serializable {
    @DontConfigure
    public static final String DEFAULT_CONFIG_NAME = "defaultFSConfig";
    @DontConfigure
    public static final String DEFAULT_FILE_EXTENSION = "dat";
    @DontConfigure
    public static final int DEFAULT_MAX_OWNER_ID_LENGTH = 10;
    @DontConfigure
    public static final int DEFAULT_FRAGMENT_LENGTH = 2;
    @DontConfigure
    public static final String VALIDATION_ERROR_PREFIX = "Validation error: ";
    @DontConfigure
    private static final long serialVersionUID = -2629878661534470687L;
    @DontConfigure
    private static final Object LOCK = new Object();
    @DontConfigure
    private static final Map<String, FSServiceConfig> CACHE = new HashMap<String, FSServiceConfig>();
    @DontConfigure
    private static Logger LOGGER = LoggerFactory.getLogger(FSServiceConfig.class);
    @Configure
    private String rootFolderPath;
    @Configure
    private String fileExtension;
    @Configure
    private int maxOwnerIdLength;
    @Configure
    private int fragmetLegth;
    @Configure
    private boolean useStringOwnerId;
    @Configure
    private boolean readOwnerIdAsFolder;
    @Configure
    private boolean saveOwnerIdAsFolder;

    private FSServiceConfig(String configuration, Environment environment) {
        block7: {
            this.useStringOwnerId = false;
            this.readOwnerIdAsFolder = false;
            this.saveOwnerIdAsFolder = false;
            try {
                if (configuration == null || configuration.trim().isEmpty()) {
                    ConfigurationManager.INSTANCE.configure((Object)this, environment);
                } else {
                    ConfigurationManager.INSTANCE.configureAs((Object)this, environment, configuration, ConfigurationSourceKey.Format.JSON);
                }
            }
            catch (RuntimeException e) {
                LOGGER.warn("FSServiceConfig(conf:" + configuration + ", env: " + environment + ") Configuration fail[" + e.getMessage() + "]. Relaying on defaults.");
                if (!LOGGER.isDebugEnabled()) break block7;
                LOGGER.debug("FSServiceConfig(" + configuration + ", " + environment + ")", (Throwable)e);
            }
        }
        if (this.fileExtension == null) {
            this.fileExtension = DEFAULT_FILE_EXTENSION;
        }
        if (this.maxOwnerIdLength == 0) {
            this.maxOwnerIdLength = 10;
        }
        if (this.fragmetLegth == 0) {
            this.fragmetLegth = 2;
        }
        LOGGER.info("FSServiceConfig(conf:" + configuration + ", env: " + environment + ") Configured with[" + this.toString() + "]");
    }

    public FSServiceConfig(String aRootFolderPath) throws FSServiceConfigException {
        this(aRootFolderPath, DEFAULT_FILE_EXTENSION, 10, 2);
    }

    public FSServiceConfig(String aRootFolderPath, String aFileExtension) throws FSServiceConfigException {
        this(aRootFolderPath, aFileExtension, 10, 2);
    }

    public FSServiceConfig(String aRootFolderPath, String aFileExtension, int aMaxOwnerIdLength, int aFragmentLength) throws FSServiceConfigException {
        this.useStringOwnerId = false;
        this.readOwnerIdAsFolder = false;
        this.saveOwnerIdAsFolder = false;
        this.rootFolderPath = FSServiceConfig.validateRootFolderPath(aRootFolderPath);
        this.fileExtension = FSServiceConfig.validateFileExtension(aFileExtension);
        this.maxOwnerIdLength = aMaxOwnerIdLength;
        this.fragmetLegth = aFragmentLength;
        this.useStringOwnerId = false;
        this.readOwnerIdAsFolder = false;
        this.saveOwnerIdAsFolder = false;
    }

    public FSServiceConfig(String aRootFolderPath, String aFileExtension, int aMaxOwnerIdLength, int aFragmentLength, boolean stringOwnerId) throws FSServiceConfigException {
        this.useStringOwnerId = false;
        this.readOwnerIdAsFolder = false;
        this.saveOwnerIdAsFolder = false;
        this.rootFolderPath = FSServiceConfig.validateRootFolderPath(aRootFolderPath);
        this.fileExtension = FSServiceConfig.validateFileExtension(aFileExtension);
        this.maxOwnerIdLength = aMaxOwnerIdLength;
        this.fragmetLegth = aFragmentLength;
        this.useStringOwnerId = stringOwnerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FSServiceConfig getInstance(String configuration, String environment) {
        FSServiceConfig config;
        String configName = String.valueOf(configuration) + "/-/" + String.valueOf(environment);
        if ((configuration == null || configuration.trim().isEmpty()) && (environment == null || environment.trim().isEmpty())) {
            configName = DEFAULT_CONFIG_NAME;
        }
        if ((config = CACHE.get(configName)) != null) {
            return config;
        }
        Environment env = ConfigurationManager.INSTANCE.getDefaultEnvironment();
        if (environment != null && !environment.trim().isEmpty()) {
            env = DynamicEnvironment.parse((String)environment);
        }
        Object object = LOCK;
        synchronized (object) {
            config = CACHE.get(configName);
            if (config == null) {
                config = new FSServiceConfig(configuration, env);
            }
            CACHE.put(configName, config);
        }
        return config;
    }

    public static FSServiceConfig getInstance() {
        return FSServiceConfig.getInstance(null, null);
    }

    public static FSServiceConfig getInstance(String configuration) {
        return FSServiceConfig.getInstance(configuration, null);
    }

    public static String getStoreFileName(String ownerId, String aFileExtension, boolean useStringOwnerId) throws FSServiceConfigException {
        return FSServiceConfig.validateOwnerId(ownerId, useStringOwnerId) + "." + aFileExtension;
    }

    private static String[] fragmentOwnerId(String ownerId, int maxOwnerIdLength, int fragmentLength) {
        if (ownerId == null || ownerId.length() == 0) {
            throw new IllegalArgumentException("OwnerId is null or empty");
        }
        while (ownerId.length() < maxOwnerIdLength) {
            ownerId = "0" + ownerId;
        }
        while (ownerId.length() % fragmentLength != 0) {
            ownerId = "0" + ownerId;
        }
        int fragmentationDepth = ownerId.length() / fragmentLength;
        String[] ret = new String[fragmentationDepth - 1];
        for (int i = 0; i < fragmentationDepth - 1; ++i) {
            String fragment;
            ret[i] = fragment = ownerId.substring(i * fragmentLength, i * fragmentLength + fragmentLength);
        }
        return ret;
    }

    public static String getStoreFolderPath(String ownerId, int maxOwnerIdLength, int fragmentLength, boolean useStringOwnerId) throws FSServiceConfigException {
        String id = FSServiceConfig.validateOwnerId(ownerId, useStringOwnerId);
        String[] fragments = FSServiceConfig.fragmentOwnerId(id, maxOwnerIdLength, fragmentLength);
        StringBuilder ret = new StringBuilder();
        for (String f : fragments) {
            ret.append(f).append(File.separatorChar);
        }
        return ret.toString();
    }

    public static String getStoreFilePath(String ownerId, int maxOwnerIdLength, int fragmentLength, String aFileExtension, boolean useStringOwnerId) throws FSServiceConfigException {
        return FSServiceConfig.getStoreFolderPath(ownerId, maxOwnerIdLength, fragmentLength, useStringOwnerId) + FSServiceConfig.getStoreFileName(ownerId, aFileExtension, useStringOwnerId);
    }

    private static String validateOwnerId(String ownerId, boolean useStringOwnerId) throws FSServiceConfigException {
        if (ownerId == null) {
            throw new FSServiceConfigException("Validation error: Null ownerId argument.");
        }
        if (ownerId.length() < 1) {
            throw new FSServiceConfigException("Validation error: Minimum length for ownerId: 1.");
        }
        try {
            if (!useStringOwnerId) {
                return Integer.valueOf(ownerId).toString();
            }
            return ownerId;
        }
        catch (NumberFormatException nfe) {
            throw new FSServiceConfigException("Validation error: NumberFormatException on parsing ownerId argument: " + nfe.getMessage());
        }
    }

    private static String validateRootFolderPath(String aRootFolderPath) throws FSServiceConfigException {
        if (aRootFolderPath == null) {
            throw new FSServiceConfigException("Validation error: Null aRootFolderPath argument.");
        }
        return aRootFolderPath;
    }

    private static String validateFileExtension(String aFileExtension) throws FSServiceConfigException {
        if (aFileExtension == null) {
            throw new FSServiceConfigException("Validation error: Null aServiceName argument.");
        }
        return aFileExtension;
    }

    public String getRootFolderPath() {
        return this.rootFolderPath;
    }

    public void setRootFolderPath(String rootFolderPath) {
        this.rootFolderPath = rootFolderPath;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    public boolean isReadOwnerIdAsFolder() {
        return this.readOwnerIdAsFolder;
    }

    public void setReadOwnerIdAsFolder(boolean readOwnerIdAsFolder) {
        this.readOwnerIdAsFolder = readOwnerIdAsFolder;
    }

    public boolean isSaveOwnerIdAsFolder() {
        return this.saveOwnerIdAsFolder;
    }

    public void setSaveOwnerIdAsFolder(boolean saveOwnerIdAsFolder) {
        this.saveOwnerIdAsFolder = saveOwnerIdAsFolder;
    }

    public String getStoreFileName(String ownerId) throws FSServiceConfigException {
        return FSServiceConfig.getStoreFileName(ownerId, this.fileExtension, this.useStringOwnerId);
    }

    public String getStoreFolderPath(String ownerId) throws FSServiceConfigException {
        String path = this.rootFolderPath;
        String lastChar = path.substring(path.length() - 1, path.length());
        if (!lastChar.equals(File.separator)) {
            path = path + File.separator;
        }
        if (this.saveOwnerIdAsFolder) {
            return path + FSServiceConfig.getStoreFolderPath(ownerId, this.maxOwnerIdLength, this.fragmetLegth, this.useStringOwnerId) + ownerId + File.separator;
        }
        return path + FSServiceConfig.getStoreFolderPath(ownerId, this.maxOwnerIdLength, this.fragmetLegth, this.useStringOwnerId);
    }

    public String getReadFolderPath(String ownerId, String saveableId) throws FSServiceConfigException {
        return this.getStoreFolderPath(ownerId) + this.getStoreFileName(saveableId);
    }

    public String getStoreFilePath(String ownerId) throws FSServiceConfigException {
        return this.getStoreFolderPath(ownerId) + this.getStoreFileName(ownerId);
    }

    public String getStoreFilePath(String folderPath, String ownerId) throws FSServiceConfigException {
        return folderPath + this.getStoreFileName(ownerId);
    }

    public void setMaxOwnerIdLength(int maxOwnerIdLength) {
        this.maxOwnerIdLength = maxOwnerIdLength;
    }

    public void setFragmetLegth(int fragmetLegth) {
        this.fragmetLegth = fragmetLegth;
    }

    public void setUseStringOwnerId(boolean useStringOwnerId) {
        this.useStringOwnerId = useStringOwnerId;
    }
}

