/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.metafactory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoprise.metafactory.FactoryResolver;
import net.anotheria.anoprise.metafactory.Service;
import net.anotheria.anoprise.metafactory.ServiceFactory;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.SetAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="factories", allfields=false, watch=true)
public final class ConfigurableFactoryResolver
implements FactoryResolver {
    private Map<String, Class<? extends ServiceFactory<? extends Service>>> factoryMap = new ConcurrentHashMap<String, Class<? extends ServiceFactory<? extends Service>>>();
    private int priority = 50;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableFactoryResolver.class);

    public static ConfigurableFactoryResolver create() {
        ConfigurableFactoryResolver resolver = new ConfigurableFactoryResolver();
        try {
            ConfigurationManager.INSTANCE.configure((Object)resolver);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("create() - no factory config found, configurable resolver remains unused.");
        }
        catch (RuntimeException e) {
            LOG.warn("create() - couldn't find factories.json file, probably packed in a jar, ignored.", (Throwable)e);
        }
        return resolver;
    }

    private ConfigurableFactoryResolver() {
    }

    @SetAll
    public void addFactory(String name, String value) {
        System.out.println("Set " + name + " = " + value);
        try {
            this.factoryMap.put(name, Class.forName(value));
        }
        catch (ClassNotFoundException e) {
            LOG.error("addFactory(" + name + ", " + value + ")", (Throwable)e);
        }
    }

    @Override
    public Class<? extends ServiceFactory<? extends Service>> resolveFactory(String serviceClass) {
        return this.factoryMap.get(serviceClass);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.factoryMap;
    }
}

