/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.metafactory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.anotheria.anoprise.metafactory.AliasResolver;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.ConfigureMe;
import org.configureme.annotations.SetAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="aliases", allfields=false, watch=true)
public class ConfigurableResolver
implements AliasResolver {
    private Map<String, String> aliasMap = new ConcurrentHashMap<String, String>();
    private int priority = 50;
    private static final Logger log = LoggerFactory.getLogger(ConfigurableResolver.class);

    public static ConfigurableResolver create() {
        ConfigurableResolver resolver = new ConfigurableResolver();
        try {
            ConfigurationManager.INSTANCE.configure((Object)resolver);
        }
        catch (IllegalArgumentException e) {
            log.warn("create() - no factory config found, configurable resolver remains unused.");
        }
        catch (RuntimeException e) {
            log.warn("create() - couldn't find aliases.json file, probably packed in a jar, ignored.", (Throwable)e);
        }
        return resolver;
    }

    private ConfigurableResolver() {
    }

    @SetAll
    public void addFactory(String name, String value) {
        this.aliasMap.put(name, value);
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public String resolveAlias(String alias) {
        return this.aliasMap.get(alias);
    }
}

