/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.mocking;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.anotheria.anoprise.mocking.Mocking;

public class Mock
implements InvocationHandler {
    private List<Class<?>> targets;
    private List<Mocking> mockings;
    private Map<Method, MockingAndMethod> cache = new HashMap<Method, MockingAndMethod>();

    Mock(Class<?> aTarget, List<Mocking> someMockings) {
        this.mockings = someMockings;
        this.targets = this.findInterfaces(aTarget);
    }

    private List<Class<?>> findInterfaces(Class<?> source) {
        Class<?>[] interfaces;
        ArrayList ret = new ArrayList();
        ret.add(source);
        for (Class<?> i : interfaces = source.getInterfaces()) {
            ret.addAll(this.findInterfaces(i));
        }
        return ret;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!this.targets.contains(method.getDeclaringClass())) {
            return method.invoke((Object)this, args);
        }
        MockingAndMethod implementor = this.findImplementor(method);
        if (implementor == null) {
            throw new IllegalArgumentException("Method: " + method + " is not mocked");
        }
        try {
            Object ret = implementor.getMethod().invoke((Object)implementor.getMocking(), args);
            return ret;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    private MockingAndMethod findImplementor(Method method) {
        MockingAndMethod fromCache = this.cache.get(method);
        if (fromCache != null) {
            return fromCache;
        }
        for (Mocking m : this.mockings) {
            Method[] methods;
            Class<?> mClazz = m.getClass();
            for (Method aMethod : methods = mClazz.getDeclaredMethods()) {
                if (!this.areMethodsEqual(aMethod, method)) continue;
                MockingAndMethod mam = new MockingAndMethod(m, aMethod);
                this.cache.put(method, mam);
                return mam;
            }
        }
        return null;
    }

    private boolean areMethodsEqual(Method first, Method second) {
        if (!first.getName().equals(second.getName())) {
            return false;
        }
        if (!first.getReturnType().equals(second.getReturnType())) {
            return false;
        }
        Object[] firstParameters = first.getParameterTypes();
        Object[] secondParameters = second.getParameterTypes();
        return Arrays.equals(firstParameters, secondParameters);
    }

    private static class MockingAndMethod {
        private Mocking mocking;
        private Method method;

        MockingAndMethod(Mocking aMocking, Method aMethod) {
            this.mocking = aMocking;
            this.method = aMethod;
        }

        Mocking getMocking() {
            return this.mocking;
        }

        Method getMethod() {
            return this.method;
        }
    }
}

