/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.processor;

import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.anotheria.anoprise.processor.PackageWorker;
import net.anotheria.anoprise.processor.QueuedMultiProcessor;
import net.anotheria.anoprise.processor.WorkProcessingListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProcessor<T> {
    private Logger log;
    private final int channelsNumber;
    private ExecutorService executorsPool;
    private PackageWorker<T> worker;
    private List<WorkProcessingListener<T>> listeners;

    public MultiProcessor(int aChannelsNumber, PackageWorker<T> aWorker, Logger aLog) {
        this.log = aLog != null ? aLog : LoggerFactory.getLogger(MultiProcessor.class);
        this.channelsNumber = aChannelsNumber;
        this.executorsPool = new ThreadPoolExecutor(aChannelsNumber, aChannelsNumber, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue<Runnable>(aChannelsNumber * 2){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean offer(Runnable command) {
                try {
                    this.put(command);
                }
                catch (InterruptedException e) {
                    return false;
                }
                return true;
            }
        });
        this.worker = aWorker;
        this.listeners = new CopyOnWriteArrayList<WorkProcessingListener<T>>();
    }

    public void process(final List<T> elementsPackage) {
        this.executorsPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    MultiProcessor.this.fireWorkStarted(elementsPackage);
                    long workingStart = System.nanoTime();
                    MultiProcessor.this.worker.doWork(elementsPackage);
                    MultiProcessor.this.fireWorkFinished(elementsPackage, System.nanoTime() - workingStart);
                }
                catch (Throwable t) {
                    try {
                        MultiProcessor.this.fireWorkInterrupted(elementsPackage);
                        MultiProcessor.this.log.error("Failure while working under element: ", t);
                    }
                    catch (Exception e) {
                        System.out.println(QueuedMultiProcessor.class + " Can't log!!!");
                        t.printStackTrace();
                    }
                }
            }
        });
    }

    public int getChannelsNumber() {
        return this.channelsNumber;
    }

    public void shutdown() {
        if (!this.executorsPool.isShutdown()) {
            this.executorsPool.shutdown();
        }
    }

    public boolean isFinished() {
        return this.executorsPool.isTerminated();
    }

    public void addListener(WorkProcessingListener<T> l) {
        this.listeners.add(l);
    }

    public boolean removeListener(WorkProcessingListener<T> l) {
        return this.listeners.remove(l);
    }

    private void fireWorkStarted(List<T> elementsPackage) {
        for (WorkProcessingListener<T> l : this.listeners) {
            try {
                l.workStarted(elementsPackage);
            }
            catch (Exception e) {
                this.log.warn("Could not fire workStarted to listener: ", (Throwable)e);
            }
        }
    }

    private void fireWorkFinished(List<T> elementsPackage, long workDuration) {
        for (WorkProcessingListener<T> l : this.listeners) {
            try {
                l.workFinished(elementsPackage, workDuration);
            }
            catch (Exception e) {
                this.log.warn("Could not fire workFinished to listener: ", (Throwable)e);
            }
        }
    }

    private void fireWorkInterrupted(List<T> elementsPackage) {
        for (WorkProcessingListener<T> l : this.listeners) {
            try {
                l.workInterrupted(elementsPackage);
            }
            catch (Exception e) {
                this.log.warn("Could not fire workInterrupted to listener: ", (Throwable)e);
            }
        }
    }
}

