/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.processor;

import java.util.List;
import net.anotheria.anoprise.processor.ElementWorker;
import net.anotheria.anoprise.processor.PackageWorker;
import net.anotheria.anoprise.processor.QueuedMultiProcessor;
import net.anotheria.anoprise.processor.QueuedMultiProcessorProducerWrapper;
import net.anotheria.anoprise.queue.BoundedFifoQueueFactory;
import net.anotheria.anoprise.queue.EnterpriseQueueFactory;
import org.slf4j.Logger;

public class QueuedMultiProcessorBuilder<E> {
    public static final long DEF_SLEEP_TIME = 50L;
    public static final int DEF_QUEUE_SIZE = 1000;
    public static final Class<?> DEF_QUEUE_FACTORY_CLASS = BoundedFifoQueueFactory.class;
    public static final int DEF_PROCESSOR_CHANNELS = 10;
    private long sleepTime = 50L;
    private int queueSize = 1000;
    private Class<EnterpriseQueueFactory<E>> queueFactoryClass = DEF_QUEUE_FACTORY_CLASS;
    private int processorChannels = 10;
    private boolean attachMoskitoLoggers = false;
    private String moskitoProducerId;
    private String moskitoCategory;
    private String moskitoSubsystem;
    private Logger processingLog = null;

    public QueuedMultiProcessor<E> build(String name, ElementWorker<E> worker) {
        return this.build(name, new PackageWorkerAdapter<E>(worker));
    }

    public QueuedMultiProcessor<E> build(String name, PackageWorker<E> worker) {
        try {
            EnterpriseQueueFactory<E> queueFactory = this.queueFactoryClass.newInstance();
            QueuedMultiProcessor<E> ret = new QueuedMultiProcessor<E>(name, worker, queueFactory, this.queueSize, this.processorChannels, this.sleepTime, this.processingLog);
            if (this.attachMoskitoLoggers) {
                new QueuedMultiProcessorProducerWrapper(ret, this.moskitoProducerId, this.moskitoCategory, this.moskitoSubsystem).attachToMoskitoLoggers();
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not build QueuedMultiProcessor with name " + name + ": ", e);
        }
    }

    public QueuedMultiProcessorBuilder<E> setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    public QueuedMultiProcessorBuilder<E> setQueueFactoryClass(Class<EnterpriseQueueFactory<E>> queueFactoryClass) {
        this.queueFactoryClass = queueFactoryClass;
        return this;
    }

    public QueuedMultiProcessorBuilder<E> setProcessorChannels(int processorChannels) {
        this.processorChannels = processorChannels;
        return this;
    }

    public QueuedMultiProcessorBuilder<E> setProcessingLog(Logger processingLog) {
        this.processingLog = processingLog;
        return this;
    }

    public QueuedMultiProcessorBuilder<E> setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
        return this;
    }

    public QueuedMultiProcessorBuilder<E> attachMoskitoLoggers(String producerId, String category, String subsystem) {
        this.attachMoskitoLoggers = true;
        this.moskitoProducerId = producerId;
        this.moskitoCategory = category;
        this.moskitoSubsystem = subsystem;
        return this;
    }

    private class PackageWorkerAdapter<T>
    implements PackageWorker<T> {
        private ElementWorker<T> elementWorker;

        public PackageWorkerAdapter(ElementWorker<T> anElementWorker) {
            this.elementWorker = anElementWorker;
        }

        @Override
        public void doWork(List<T> workingPackage) throws Exception {
            this.elementWorker.doWork(workingPackage.get(0));
        }

        @Override
        public int packageCapacity() {
            return 1;
        }
    }
}

