/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.sessiondistributor;

import net.anotheria.util.TimeUnit;
import org.configureme.ConfigurationManager;
import org.configureme.annotations.Configure;
import org.configureme.annotations.ConfigureMe;
import org.slf4j.LoggerFactory;

@ConfigureMe(name="ano-prise-session-distributor-service")
public class SessionDistributorServiceConfig {
    protected static final int DEFAULT_SD_EVEN_CHANNEL_Q_SIZE = 5000;
    protected static final long DEFAULT_SD_EVEN_CHANNEL_Q_SLEEP_TIME = 300L;
    protected static final int MAX_SESSIONS_COUNT = 1000;
    @Configure
    private long distributedSessionsCleanUpInterval = TimeUnit.MINUTE.getMillis() * 5L;
    @Configure
    private long distributedSessionMaxAge = TimeUnit.MINUTE.getMillis() * 10L;
    @Configure
    private int sessionDistributorEventQueueSize = 5000;
    @Configure
    private long sessionDistributorEventQueueSleepTime = 300L;
    @Configure
    private boolean multipleInstancesEnabled = false;
    @Configure
    private int sessionDistributorServersAmount = 1;
    @Configure
    private boolean failingStrategyEnabled = false;
    @Configure
    private boolean wrightSessionsToFsOnShutdownEnabled = false;
    @Configure
    private String sdSessionsFSRootFolder = "sessionDistributorService_sessionsState";
    @Configure
    private String sdSessionsFileExtension = "sds";
    @Configure
    private int sdCacheEventQueueSize = 5000;
    @Configure
    private long sdCacheEventQueueSleepTime = 300L;
    @Configure
    private String nodeIdSystemPropertyName = "extension";
    @Configure
    private int maxSessionsCount = 1000;
    @Configure
    private boolean sessionsLimitEnabled = false;

    public static SessionDistributorServiceConfig getInstance() {
        return SessionDistributorConfigInstanceHolder.INSTANCE;
    }

    private SessionDistributorServiceConfig() {
    }

    public long getDistributedSessionMaxAge() {
        return this.distributedSessionMaxAge;
    }

    public void setDistributedSessionMaxAge(long distributedSessionMaxAge) {
        this.distributedSessionMaxAge = distributedSessionMaxAge;
    }

    public long getDistributedSessionsCleanUpInterval() {
        return this.distributedSessionsCleanUpInterval;
    }

    public void setDistributedSessionsCleanUpInterval(long distributedSessionsCleanUpInterval) {
        this.distributedSessionsCleanUpInterval = distributedSessionsCleanUpInterval;
    }

    public int getSessionDistributorEventQueueSize() {
        return this.sessionDistributorEventQueueSize;
    }

    public void setSessionDistributorEventQueueSize(int sessionDistributorEventQueueSize) {
        this.sessionDistributorEventQueueSize = sessionDistributorEventQueueSize;
    }

    public long getSessionDistributorEventQueueSleepTime() {
        return this.sessionDistributorEventQueueSleepTime;
    }

    public void setSessionDistributorEventQueueSleepTime(long sessionDistributorEventQueueSleepTime) {
        this.sessionDistributorEventQueueSleepTime = sessionDistributorEventQueueSleepTime;
    }

    public boolean isMultipleInstancesEnabled() {
        return this.multipleInstancesEnabled;
    }

    public void setMultipleInstancesEnabled(boolean multipleInstancesEnabled) {
        this.multipleInstancesEnabled = multipleInstancesEnabled;
    }

    public int getSessionDistributorServersAmount() {
        return this.sessionDistributorServersAmount;
    }

    public void setSessionDistributorServersAmount(int sessionDistributorServersAmount) {
        this.sessionDistributorServersAmount = sessionDistributorServersAmount > 0 ? sessionDistributorServersAmount : 0;
    }

    public boolean isFailingStrategyEnabled() {
        return this.failingStrategyEnabled;
    }

    public void setFailingStrategyEnabled(boolean failingStrategyEnabled) {
        this.failingStrategyEnabled = failingStrategyEnabled;
    }

    public boolean isWrightSessionsToFsOnShutdownEnabled() {
        return this.wrightSessionsToFsOnShutdownEnabled;
    }

    public void setWrightSessionsToFsOnShutdownEnabled(boolean wrightSessionsToFsOnShutdownEnabled) {
        this.wrightSessionsToFsOnShutdownEnabled = wrightSessionsToFsOnShutdownEnabled;
    }

    public String getSdSessionsFSRootFolder() {
        return this.sdSessionsFSRootFolder;
    }

    public void setSdSessionsFSRootFolder(String sdSessionsFSRootFolder) {
        this.sdSessionsFSRootFolder = sdSessionsFSRootFolder;
    }

    public String getSdSessionsFileExtension() {
        return this.sdSessionsFileExtension;
    }

    public void setSdSessionsFileExtension(String sdSessionsFileExtension) {
        this.sdSessionsFileExtension = sdSessionsFileExtension;
    }

    public int getSdCacheEventQueueSize() {
        return this.sdCacheEventQueueSize;
    }

    public void setSdCacheEventQueueSize(int sdCacheEventQueueSize) {
        this.sdCacheEventQueueSize = sdCacheEventQueueSize;
    }

    public long getSdCacheEventQueueSleepTime() {
        return this.sdCacheEventQueueSleepTime;
    }

    public void setSdCacheEventQueueSleepTime(long sdCacheEventQueueSleepTime) {
        this.sdCacheEventQueueSleepTime = sdCacheEventQueueSleepTime;
    }

    public String getNodeIdSystemPropertyName() {
        return this.nodeIdSystemPropertyName;
    }

    public void setNodeIdSystemPropertyName(String nodeIdSystemPropertyName) {
        this.nodeIdSystemPropertyName = nodeIdSystemPropertyName;
    }

    public int getMaxSessionsCount() {
        return this.maxSessionsCount;
    }

    public void setMaxSessionsCount(int maxSessionsCount) {
        this.maxSessionsCount = maxSessionsCount;
    }

    public boolean isSessionsLimitEnabled() {
        return this.sessionsLimitEnabled;
    }

    public void setSessionsLimitEnabled(boolean sessionsLimitEnabled) {
        this.sessionsLimitEnabled = sessionsLimitEnabled;
    }

    public String toString() {
        return "SessionDistributorServiceConfig{distributedSessionsCleanUpInterval=" + this.distributedSessionsCleanUpInterval + ", distributedSessionMaxAge=" + this.distributedSessionMaxAge + ", sessionDistributorEventQueueSize=" + this.sessionDistributorEventQueueSize + ", sessionDistributorEventQueueSleepTime=" + this.sessionDistributorEventQueueSleepTime + ", multipleInstancesEnabled=" + this.multipleInstancesEnabled + ", sessionDistributorServersAmount=" + this.sessionDistributorServersAmount + ", failingStrategyEnabled=" + this.failingStrategyEnabled + ", wrightSessionsToFsOnShutdownEnabled=" + this.wrightSessionsToFsOnShutdownEnabled + ", sdSessionsFSRootFolder='" + this.sdSessionsFSRootFolder + '\'' + ", sdSessionsFileExtension='" + this.sdSessionsFileExtension + '\'' + ", sdCacheEventQueueSize=" + this.sdCacheEventQueueSize + ", sdCacheEventQueueSleepTime=" + this.sdCacheEventQueueSleepTime + ", nodeIdSystemPropertyName='" + this.nodeIdSystemPropertyName + '\'' + ", maxSessionsCount=" + this.maxSessionsCount + ", sessionsLimitEnabled=" + this.sessionsLimitEnabled + '}';
    }

    private static class SessionDistributorConfigInstanceHolder {
        private static SessionDistributorServiceConfig INSTANCE = new SessionDistributorServiceConfig();

        private SessionDistributorConfigInstanceHolder() {
        }

        static {
            try {
                ConfigurationManager.INSTANCE.configure((Object)INSTANCE);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(SessionDistributorServiceConfig.class).error("SessionDistributorServiceConfig configuration failed. configuring defaults. " + e.getMessage());
            }
        }
    }
}

