/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.sessiondistributor;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.anotheria.anoprise.eventservice.Event;
import net.anotheria.anoprise.eventservice.EventChannel;
import net.anotheria.anoprise.eventservice.EventServiceFactory;
import net.anotheria.anoprise.eventservice.ProxyType;
import net.anotheria.anoprise.eventservice.util.QueueFullException;
import net.anotheria.anoprise.eventservice.util.QueuedEventSender;
import net.anotheria.anoprise.sessiondistributor.DistributedSessionAttribute;
import net.anotheria.anoprise.sessiondistributor.DistributedSessionVO;
import net.anotheria.anoprise.sessiondistributor.NoSuchDistributedSessionException;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorService;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorServiceConfig;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorServiceException;
import net.anotheria.anoprise.sessiondistributor.SessionsCountLimitReachedSessionDistributorServiceException;
import net.anotheria.anoprise.sessiondistributor.cache.SDCache;
import net.anotheria.anoprise.sessiondistributor.cache.SDCacheUtil;
import net.anotheria.anoprise.sessiondistributor.events.SessionDistributorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionDistributorServiceImpl
implements SessionDistributorService {
    private static Logger LOG = LoggerFactory.getLogger(SessionDistributorServiceImpl.class);
    public static final int SESSION_ID_LENGTH = 30;
    private SDCache sessions;
    private final SessionDistributorServiceConfig serviceConfig;
    private QueuedEventSender eventSender;
    private final Object lock = new Object();

    public SessionDistributorServiceImpl() {
        this.serviceConfig = SessionDistributorServiceConfig.getInstance();
        this.sessions = SDCacheUtil.createCache();
        this.initIntegration();
    }

    private void initIntegration() {
        EventChannel sessionDistributorEventChannel = EventServiceFactory.createEventService().obtainEventChannel("sessiondistributor_channel", ProxyType.PUSH_SUPPLIER_PROXY);
        this.eventSender = new QueuedEventSender("eventannounce", sessionDistributorEventChannel, this.serviceConfig.getSessionDistributorEventQueueSize(), this.serviceConfig.getSessionDistributorEventQueueSleepTime(), LOG);
        this.eventSender.start();
        if (this.serviceConfig.isWrightSessionsToFsOnShutdownEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    if (SessionDistributorServiceImpl.this.serviceConfig.isWrightSessionsToFsOnShutdownEnabled()) {
                        SDCacheUtil.save(SessionDistributorServiceImpl.this.sessions);
                    }
                }
            });
        }
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    SessionDistributorServiceImpl.this.cleanup();
                }
                catch (Exception e) {
                    LOG.error("Uncaught exception in cleanup() timer task", (Throwable)e);
                }
            }
        }, 0L, this.serviceConfig.getDistributedSessionsCleanUpInterval());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String createDistributedSession(String sessionId) throws SessionDistributorServiceException {
        LOG.debug("createDistributedSession(" + sessionId + ")");
        if (!this.serviceConfig.isSessionsLimitEnabled()) {
            return this.sessions.createSession(sessionId);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.sessions.getCount() >= this.serviceConfig.getMaxSessionsCount()) {
                throw new SessionsCountLimitReachedSessionDistributorServiceException(this.serviceConfig.getMaxSessionsCount());
            }
            return this.sessions.createSession(sessionId);
        }
    }

    @Override
    public void deleteDistributedSession(String sessionId) throws SessionDistributorServiceException {
        LOG.debug("deleteDistributedSession(" + sessionId + ")");
        this.sessions.removeSession(sessionId);
        Event delete = new Event("SessionDistributorService", SessionDistributorEvent.delete(sessionId));
        try {
            this.eventSender.push(delete);
        }
        catch (QueueFullException e) {
            LOG.error("Can't push Session delete event. Queue is Full. Event:" + delete);
        }
    }

    @Override
    public DistributedSessionVO restoreDistributedSession(String sessionId, String callerId) throws SessionDistributorServiceException {
        LOG.debug("restoreDistributedSession(" + sessionId + ", " + callerId + ")");
        DistributedSessionVO session = this.sessions.getSession(sessionId);
        Event restore = new Event("SessionDistributorService", SessionDistributorEvent.restore(session.getName(), callerId));
        LOG.debug("pushing event: " + restore);
        try {
            this.eventSender.push(restore);
        }
        catch (QueueFullException e) {
            LOG.error("Can't push Session restore event. Queue is Full. Event:" + restore);
        }
        LOG.debug("pushing finished");
        return session;
    }

    @Override
    public List<String> getDistributedSessionNames() throws SessionDistributorServiceException {
        return this.sessions.getSessionIds();
    }

    @Override
    public void updateSessionUserId(String sessionId, String userId) throws SessionDistributorServiceException {
        LOG.debug("updateSessionUserId(" + sessionId + ", " + userId + ")");
        this.sessions.updateSessionUserId(sessionId, userId);
    }

    @Override
    public void updateSessionEditorId(String sessionId, String editorId) throws SessionDistributorServiceException {
        LOG.debug("updateSessionEditorId(" + sessionId + ", " + editorId + ")");
        this.sessions.updateSessionEditorId(sessionId, editorId);
    }

    @Override
    public void addDistributedAttribute(String sessionId, DistributedSessionAttribute attribute) throws SessionDistributorServiceException {
        LOG.debug("addDistributedAttribute(" + sessionId + ", " + attribute + ")");
        this.sessions.addAttribute(sessionId, attribute);
    }

    @Override
    public void removeDistributedAttribute(String sessionId, String attributeName) throws SessionDistributorServiceException {
        LOG.debug("removeDistributedAttribute(" + sessionId + ", " + attributeName + ")");
        this.sessions.removeAttribute(sessionId, attributeName);
    }

    @Override
    public void keepDistributedSessionAlive(String sessionId) throws SessionDistributorServiceException {
        LOG.debug("keepDistributedSessionAlive(" + sessionId + ")");
        this.sessions.updateCallTime(sessionId);
    }

    private void cleanup() {
        int expiredCount = 0;
        int sizeBefore = this.sessions.getCount();
        ArrayList<String> cleanedSessionsIds = new ArrayList<String>();
        List<DistributedSessionVO> holders = this.sessions.getSessions();
        for (DistributedSessionVO session : holders) {
            if (!session.isExpired()) continue;
            try {
                this.sessions.removeSession(session.getName());
                ++expiredCount;
                cleanedSessionsIds.add(session.getName());
            }
            catch (NoSuchDistributedSessionException e) {
                LOG.warn("cleanup() - detected already removed session [" + session.getName() + "]! clustering enabled : " + this.serviceConfig.isMultipleInstancesEnabled());
            }
        }
        if (!cleanedSessionsIds.isEmpty()) {
            Event cleanUp = new Event("SessionDistributorService", SessionDistributorEvent.cleanUp(cleanedSessionsIds));
            try {
                LOG.debug("cleanup event sending: " + cleanUp);
                this.eventSender.push(cleanUp);
            }
            catch (QueueFullException e) {
                LOG.error("Can't push Session cleanUp event. Queue is Full. Event:" + cleanUp);
            }
        }
        LOG.info("Finished session distributor cleanup run, removed sessions: " + expiredCount + ", sizeBefore: " + sizeBefore + ", sizeAfter: " + this.sessions.getCount());
    }
}

