/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.sessiondistributor;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorServiceConfig;
import org.distributeme.core.ClientSideCallContext;
import org.distributeme.core.failing.FailDecision;
import org.distributeme.core.failing.FailingStrategy;
import org.distributeme.core.routing.Router;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionDistributorServiceMethodCallsRouter
implements Router,
FailingStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SessionDistributorServiceMethodCallsRouter.class);
    private static final int PARAMETER_POSITION = 0;
    private static final Set<String> routeModMethods = new HashSet<String>();
    private static final String UNDER_LINE = "_";
    private AtomicInteger delegateCallCounter;
    private SessionDistributorServiceConfig configuration = SessionDistributorServiceConfig.getInstance();

    public SessionDistributorServiceMethodCallsRouter() {
        this.delegateCallCounter = new AtomicInteger(0);
    }

    public FailDecision callFailed(ClientSideCallContext clientSideCallContext) {
        if (!this.configuration.isFailingStrategyEnabled()) {
            return FailDecision.fail();
        }
        if (clientSideCallContext.getCallCount() <= this.configuration.getSessionDistributorServersAmount()) {
            return FailDecision.retry();
        }
        return FailDecision.fail();
    }

    public String getServiceIdForCall(ClientSideCallContext callContext) {
        if (routeModMethods.contains(callContext.getMethodName()) && callContext.isFirstCall()) {
            return this.getModBasedServiceId(callContext);
        }
        return this.getRoundRobinBasedServiceId(callContext);
    }

    private String getModBasedServiceId(ClientSideCallContext callContext) {
        String result;
        List parameters = callContext.getParameters();
        if (parameters.size() < 1) {
            throw new AssertionError((Object)("Not properly configured router, parameter count is less than expected - actual: " + parameters.size() + ", expected: " + 0));
        }
        Object parameter = parameters.get(0);
        long parameterValue = this.getModableValue(parameter);
        int mod = this.configuration.getSessionDistributorServersAmount();
        String string = result = mod - 1 <= 0 ? callContext.getServiceId() : callContext.getServiceId() + UNDER_LINE + parameterValue % (long)mod;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning mod based result : " + result + " for " + callContext);
        }
        return result;
    }

    private String getRoundRobinBasedServiceId(ClientSideCallContext callContext) {
        String result;
        int callCounter = this.delegateCallCounter.get();
        int mod = this.configuration.getSessionDistributorServersAmount();
        if (this.delegateCallCounter.incrementAndGet() > mod - 1) {
            this.delegateCallCounter.set(0);
        }
        String serviceId = callContext.getServiceId();
        if (!callContext.isFirstCall()) {
            int instanceNumberPosition = serviceId.lastIndexOf(UNDER_LINE);
            serviceId = instanceNumberPosition > 0 ? serviceId.substring(0, instanceNumberPosition) : serviceId;
        }
        String string = result = mod - 1 <= 0 ? serviceId : serviceId + UNDER_LINE + callCounter;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Returning roundRobin based result : " + result + " for " + callContext);
        }
        return result;
    }

    private long getModableValue(Object o) {
        if (o instanceof String) {
            return Math.abs(((String)String.class.cast(o)).hashCode());
        }
        if (o == null) {
            throw new AssertionError((Object)"Null objects are not supported");
        }
        throw new AssertionError((Object)("Object " + o + " of type " + o.getClass() + " is not supported. Please use String"));
    }

    public void customize(String serviceId, String parameter) {
    }

    static {
        routeModMethods.add("createDistributedSession");
        routeModMethods.add("deleteDistributedSession");
        routeModMethods.add("restoreDistributedSession");
        routeModMethods.add("updateSessionUserId");
        routeModMethods.add("updateSessionEditorId");
        routeModMethods.add("addDistributedAttribute");
        routeModMethods.add("removeDistributedAttribute");
        routeModMethods.add("keepDistributedSessionAlive");
    }
}

