/*
 * Decompiled with CFR 0.152.
 */
package net.anotheria.anoprise.sessiondistributor.cache;

import net.anotheria.anoprise.fs.FSSaveableID;
import net.anotheria.anoprise.fs.FSService;
import net.anotheria.anoprise.fs.FSServiceConfig;
import net.anotheria.anoprise.fs.FSServiceConfigException;
import net.anotheria.anoprise.fs.FSServiceException;
import net.anotheria.anoprise.fs.FSServiceFactory;
import net.anotheria.anoprise.sessiondistributor.SessionDistributorServiceConfig;
import net.anotheria.anoprise.sessiondistributor.cache.SDCache;
import net.anotheria.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class SDCacheUtil {
    private static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    private static final Logger LOG = LoggerFactory.getLogger(SDCacheUtil.class);
    private static final String LOG_PREFIX = "SD_FS_PERSISTENCE: ";
    private static final FSService<SDCache> fsPersistence;

    public static SDCache createCache() {
        if (!SessionDistributorServiceConfig.getInstance().isWrightSessionsToFsOnShutdownEnabled()) {
            return new SDCache();
        }
        String cacheId = System.getProperty(SessionDistributorServiceConfig.getInstance().getNodeIdSystemPropertyName());
        cacheId = StringUtils.isEmpty((String)cacheId) ? "1000" : cacheId;
        try {
            SDCache cache = fsPersistence.read(new FSSaveableID(cacheId, cacheId));
            try {
                fsPersistence.delete(new FSSaveableID(cacheId, cacheId));
            }
            catch (FSServiceException e) {
                LOG.warn("SD_FS_PERSISTENCE: Deleting restored sessions cache  failed! CAUSE : " + e.getMessage());
            }
            return cache;
        }
        catch (FSServiceException fSSe) {
            LOG.warn("SD_FS_PERSISTENCE:  read(" + cacheId + ") failed - creating empty cache!", (Throwable)fSSe);
            return new SDCache();
        }
    }

    public static void save(SDCache sessionsCache) {
        if (sessionsCache == null) {
            throw new IllegalArgumentException("Invalid sessionsCache");
        }
        try {
            fsPersistence.save(sessionsCache);
        }
        catch (FSServiceException e) {
            LOG.warn("SD_FS_PERSISTENCE:  save(" + sessionsCache + ") failed!", (Throwable)e);
        }
    }

    static {
        try {
            SessionDistributorServiceConfig serviceConfig = SessionDistributorServiceConfig.getInstance();
            FSServiceConfig config = new FSServiceConfig(serviceConfig.getSdSessionsFSRootFolder(), serviceConfig.getSdSessionsFileExtension());
            fsPersistence = FSServiceFactory.createFSService(config);
        }
        catch (FSServiceConfigException fSSce) {
            LOG.error(FATAL, "SD_FS_PERSISTENCE: Unable to initialize FSService. ", (Throwable)fSSce);
            throw new RuntimeException(fSSce);
        }
    }
}

