/**
 ************************************************************************************
 *** AnoAccessApplicationDataServiceFixtureImpl.java                              ***
 *** The implementation of the IAnoAccessApplicationDataService for unit testing. ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                          ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net                   ***
 *** All Rights Reserved.                                                         ***
 ************************************************************************************
 *** Don't edit this code, if you aren't sure                                     ***
 *** that you do exactly know what you are doing!                                 ***
 *** It's better to invest time in the generator, as into the generated code.     ***
 ************************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessapplicationdata.service.fixture;

import java.util.List;
import java.util.Set;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.IAnoAccessApplicationDataService;
import net.anotheria.anosite.gen.anoaccessapplicationdata.service.AnoAccessApplicationDataServiceException;
import net.anotheria.asg.service.BaseFixtureService;
import net.anotheria.asg.service.IFixtureService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.ArrayList;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserData;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserDataXMLHelper;
import net.anotheria.anosite.gen.anoaccessapplicationdata.data.UserDataDocument;

public class AnoAccessApplicationDataServiceFixtureImpl extends BaseFixtureService implements IAnoAccessApplicationDataService, IFixtureService{

	private static AnoAccessApplicationDataServiceFixtureImpl instance;

	private Map<String, UserData> userdataMap;
	private AtomicInteger userdataIdHolder;

	private AnoAccessApplicationDataServiceFixtureImpl(){
		reset();
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.UserAccessGrantListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferAnoAccessApplicationDataListener());
	}

	static final AnoAccessApplicationDataServiceFixtureImpl getInstance(){
		if (instance==null){
			instance = new AnoAccessApplicationDataServiceFixtureImpl();
		}
		return instance;
	}

	@Override public void reset(){
		userdataMap = new ConcurrentHashMap<String, UserData>();
		userdataIdHolder = new AtomicInteger(0);

	}

	@Override public List<UserData> getUserDatas() throws AnoAccessApplicationDataServiceException {
		List<UserData> ret = new ArrayList<UserData>();
		ret.addAll(userdataMap.values());
		return ret;
	}

	@Override public List<UserData> getUserDatas(SortType sortType) throws AnoAccessApplicationDataServiceException {
		return StaticQuickSorter.sort(getUserDatas(), sortType);
	}

	@Override public void deleteUserData(UserData userdata) throws AnoAccessApplicationDataServiceException {
		deleteUserData(userdata.getId());
	}

	@Override public void deleteUserData(String id) throws AnoAccessApplicationDataServiceException {
		UserData old = userdataMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple UserData objects.
	 */
	@Override public void deleteUserDatas(List<UserData> list) throws AnoAccessApplicationDataServiceException {
		for (UserData userdata : list){
			deleteUserData(userdata);
		}
	}

	@Override public UserData getUserData(String id) throws AnoAccessApplicationDataServiceException {
		UserData userdata = userdataMap.get(id);
		if (userdata==null)
			throw new AnoAccessApplicationDataServiceException("No UserData with id "+id+" found");
		return userdata;
	}

	@Override public UserData importUserData(UserData userdata) throws AnoAccessApplicationDataServiceException {
		userdataMap.put(userdata.getId(), userdata);
		return userdata;
	}

	@Override public List<UserData> importUserDatas(List<UserData> list) throws AnoAccessApplicationDataServiceException {
		List<UserData> ret = new ArrayList<UserData>();
		for (UserData userdata : list)
			ret.add(importUserData(userdata));
		return ret;
	}

	@Override public UserData createUserData(UserData userdata) throws AnoAccessApplicationDataServiceException {
		String nextId = ""+userdataIdHolder.incrementAndGet();
		// //CMS Specific code
		UserDataDocument newUserdata = (UserDataDocument)userdata;
		newUserdata.renameTo(nextId);
		userdataMap.put(newUserdata.getId(), newUserdata);
		fireObjectCreatedEvent(newUserdata);
		return newUserdata;
	}

	/**
	 * Creates multiple new UserData objects.
	 * Returns the created versions.
	 */
	@Override public List<UserData> createUserDatas(List<UserData> list) throws AnoAccessApplicationDataServiceException {
		List<UserData> ret = new ArrayList<UserData>();
		for (UserData userdata : list)
			ret.add(createUserData(userdata));
		return ret;
	}

	/**
	 * Updates multiple new UserData objects.
	 * Returns the updated versions.
	 */
	@Override public List<UserData> updateUserDatas(List<UserData> list) throws AnoAccessApplicationDataServiceException {
		List<UserData> ret = new ArrayList<UserData>();
		for (UserData userdata : list)
			ret.add(updateUserData(userdata));
		return ret;
	}

	@Override public UserData updateUserData(UserData userdata) throws AnoAccessApplicationDataServiceException {
		UserData oldVersion = userdataMap.put(userdata.getId(), userdata);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, userdata);
		}
		return userdata;
	}

	@Override public List<UserData> getUserDatasByProperty(String propertyName, Object value) throws AnoAccessApplicationDataServiceException {
		List<UserData> list = getUserDatas();
		List<UserData> ret = new ArrayList<UserData>();
		for (UserData userdata : list){
			Object propertyValue = userdata.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(userdata);
		}
		return ret;
	}

	@Override public List<UserData> getUserDatasByProperty(String propertyName, Object value, SortType sortType) throws AnoAccessApplicationDataServiceException {
		return StaticQuickSorter.sort(getUserDatasByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on UserDatas
	 */
	@Override public QueryResult executeQueryOnUserDatas(DocumentQuery query) throws AnoAccessApplicationDataServiceException {
		List<UserData> allUserDatas = getUserDatas();
		QueryResult result = new QueryResult();
		for (int i=0; i<allUserDatas.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allUserDatas.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all UserData objects, where property matches.
	 */
	@Override public List<UserData> getUserDatasByProperty(QueryProperty... properties) throws AnoAccessApplicationDataServiceException {
		List<UserData> list = getUserDatas();
		if (properties==null || properties.length==0)
			return list;
		List<UserData> ret = new ArrayList<UserData>();
		for (UserData userdata : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = userdata.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(userdata);
		}
		return ret;
	}

	/**
	 * Returns all UserData objects, where property matches, sorted
	 */
	@Override public List<UserData> getUserDatasByProperty(SortType sortType, QueryProperty... property) throws AnoAccessApplicationDataServiceException {
		return StaticQuickSorter.sort(getUserDatasByProperty(property), sortType);
	}

	/**
	 * Returns UserData objects count.
	 */
	@Override public int getUserDatasCount() throws AnoAccessApplicationDataServiceException {
		return userdataMap.values().size();
	}

	/**
	 * Returns UserData objects segment.
	 */
	public List<UserData> getUserDatas(Segment aSegment) throws AnoAccessApplicationDataServiceException {
		return Slicer.slice(aSegment, getUserDatas()).getSliceData();
	}

	/**
	 * Returns UserData objects segment, where property matched.
	 */
	public List<UserData> getUserDatasByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<UserData> ret = new ArrayList<>();
		List<UserData> src = new ArrayList<>();
		src.addAll(userdataMap.values());
		for (UserData userdata : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(userdata.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(userdata);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns UserData objects segment, where property matched, sorted.
	 */
	public List<UserData> getUserDatasByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getUserDatasByProperty(aSegment, aProperty), aSortType);
	}


	public XMLNode exportUserDatasToXML(){
		XMLNode ret = new XMLNode("UserDatas");
		try{
			List<UserData> list = getUserDatas();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (UserData object : list)
				ret.addChildNode(UserDataXMLHelper.toXML(object));
			return ret;
		}
		catch(AnoAccessApplicationDataServiceException e){
			throw new RuntimeException("exportUserDatasToXML() failure: " , e);
		}
	}

	public XMLNode exportUserDatasToXML(List<UserData> list){
		XMLNode ret = new XMLNode("UserDatas");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (UserData object : list)
			ret.addChildNode(UserDataXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportUserDatasToXML(String languages[]){
		XMLNode ret = new XMLNode("UserDatas");
		try{
			List<UserData> list = getUserDatas();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (UserData object : list)
				ret.addChildNode(UserDataXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(AnoAccessApplicationDataServiceException e){
			throw new RuntimeException("exportUserDatasToXML() failure: " , e);
		}
	}

	public XMLNode exportUserDatasToXML(String languages[], List<UserData> list){
		XMLNode ret = new XMLNode("UserDatas");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (UserData object : list)
			ret.addChildNode(UserDataXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchUserData (final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessApplicationDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws AnoAccessApplicationDataServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query) throws AnoAccessApplicationDataServiceException {
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnUserDatas(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects

	@Override public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("AnoAccessApplicationData");

		ret.addChildNode(exportUserDatasToXML());

		return ret;
	}

}
