/**
 ********************************************************************************
 *** BasePermissionAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.anosite.gen.shared.action.BaseAnoAccessConfigurationAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BasePermissionAction extends BaseAnoAccessConfigurationAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Permissions";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "AnoAccessConfiguration";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Permission";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Permission permission) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("AnoAccessConfiguration.Permission").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Permission", permission, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Permission", permission, "priority");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.priority", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Permission", permission, "deny");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.deny", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Permission", permission, "constraints");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.constraints", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Permission", permission, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockPermissions(Permission permission, HttpServletRequest req) throws Exception{
		if(permission instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)permission;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getAnoAccessConfigurationService().updatePermission( permission);
			logger.info("Lock-OPERATION, document with id : ["+permission.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockPermissions(Permission permission, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(permission instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)permission;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getAnoAccessConfigurationService().updatePermission( permission);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+permission.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+permission.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkPermissions(Permission permission, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = permission instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)permission).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)permission).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockPermissions(permission, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdatePermissions(Permission permission, HttpServletRequest req) throws Exception{
		if(permission instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)permission, false, getUserId(req));
		}
		if (isTimeoutReached(permission)) {
			checkPermissions(permission, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(permission, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Permission permission){
		if (permission instanceof LockableObject) {
			LockableObject lock = (LockableObject)permission;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Permission permission, HttpServletRequest req){
		if (permission instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)permission;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
