/**
 ********************************************************************************
 *** BaseRoleAction.java                                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import net.anotheria.anosite.gen.shared.action.BaseAnoAccessConfigurationAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Role;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseRoleAction extends BaseAnoAccessConfigurationAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Roles";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "AnoAccessConfiguration";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "Role";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, Role role) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("AnoAccessConfiguration.Role").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Role", role, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Role", role, "permissions");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.permissions", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Role", role, "contextInitializers");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.contextInitializers", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("AnoAccessConfiguration.Role", role, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockRoles(Role role, HttpServletRequest req) throws Exception{
		if(role instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)role;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getAnoAccessConfigurationService().updateRole( role);
			logger.info("Lock-OPERATION, document with id : ["+role.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockRoles(Role role, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(role instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)role;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getAnoAccessConfigurationService().updateRole( role);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+role.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+role.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkRoles(Role role, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = role instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)role).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)role).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockRoles(role, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateRoles(Role role, HttpServletRequest req) throws Exception{
		if(role instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)role, false, getUserId(req));
		}
		if (isTimeoutReached(role)) {
			checkRoles(role, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(role, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(Role role){
		if (role instanceof LockableObject) {
			LockableObject lock = (LockableObject)role;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(Role role, HttpServletRequest req){
		if (role instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)role;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
