/**
 ********************************************************************************
 *** MultiOpRolesPermissionsAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.RoleFactory;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Role;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.PermissionsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.anoaccessconfiguration.bean.PermissionsQuickAddFB;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.PermissionSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpRolesPermissionsAction extends BaseRoleAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("anoaccessconfigurationRolePermissionsShow"))
			return anoaccessconfigurationRolePermissionsShow(mapping, req, res);
		if (path.equals("anoaccessconfigurationRolePermissionsAdd"))
			return anoaccessconfigurationRolePermissionsAdd(mapping, req, res);
		if (path.equals("anoaccessconfigurationRolePermissionsDelete"))
			return anoaccessconfigurationRolePermissionsDelete(mapping, req, res);
		if (path.equals("anoaccessconfigurationRolePermissionsMove"))
			return anoaccessconfigurationRolePermissionsMove(mapping, req, res);
		if (path.equals("anoaccessconfigurationRolePermissionsQuickAdd"))
			return anoaccessconfigurationRolePermissionsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand anoaccessconfigurationRolePermissionsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Role role = getAnoAccessConfigurationService().getRole(id);
		addBeanToRequest(req, "ownerId", id);
		checkRoles(role, req);

		PermissionsElementFB form = new PermissionsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(role.getId());
		addBeanToRequest(req, "anoaccessconfigurationRolePermissionsElementForm", form);

		PermissionsQuickAddFB quickAddForm = new PermissionsQuickAddFB() ;
		quickAddForm.setOwnerId(role.getId());
		addBeanToRequest(req, "anoaccessconfigurationRolePermissionsQuickAddForm", quickAddForm);


		//link permission to AnoAccessConfiguration.Permission
		List<Permission> permissions = getAnoAccessConfigurationService().getPermissions(new PermissionSortType(PermissionSortType.SORT_BY_NAME));
		List<LabelValueBean> permissionsValues = new ArrayList<LabelValueBean>(permissions.size());
		for (int i=0; i<permissions.size(); i++){
			net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission tmp_permission = (net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission) permissions.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_permission.getId(), tmp_permission.getName()+" ["+tmp_permission.getId()+"]" );
			permissionsValues.add(bean);
		}
		addBeanToRequest(req, "permissionValuesCollection", permissionsValues);
		// generate list ...
		int size = role.getPermissionsSize();
		List<PermissionsElementFB> beans = new ArrayList<PermissionsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = role.getPermissionsElement(i);
			PermissionsElementFB bean = new PermissionsElementFB();
			bean.setOwnerId(role.getId());
			bean.setPosition(i);
			bean.setPermission(value);
			try{
				Permission tmp_permission = getAnoAccessConfigurationService().getPermission(value);
				bean.setDescription(tmp_permission.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand anoaccessconfigurationRolePermissionsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Role roleCurr = getAnoAccessConfigurationService().getRole(id);
		canUpdateRoles(roleCurr, req);
		checkRoles(roleCurr, req);
		int position = getIntParameter(req, "pPosition");
		Role role = getAnoAccessConfigurationService().getRole(id);
		role.removePermissionsElement(position);
		getAnoAccessConfigurationService().updateRole(role);
		return anoaccessconfigurationRolePermissionsShow(mapping, req, res);
	}

	public ActionCommand anoaccessconfigurationRolePermissionsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Role role = getAnoAccessConfigurationService().getRole(id);
		canUpdateRoles(role, req);
		checkRoles(role, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(role, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(role, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(role, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(role, position);
		return anoaccessconfigurationRolePermissionsShow(mapping, req, res);
	}

	private void moveUp(Role role, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		role.swapPermissionsElement(position, position-1);
		getAnoAccessConfigurationService().updateRole(role);
	}

	private void moveTop(Role role, int position) throws ASGRuntimeException {
		List<String> targetList = role.getPermissions();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		role.setPermissions(targetList);
		getAnoAccessConfigurationService().updateRole(role);
	}

	private void moveDown(Role role, int position) throws ASGRuntimeException {
		if (position<role.getPermissionsSize()-1){
			role.swapPermissionsElement(position, position+1);
			getAnoAccessConfigurationService().updateRole(role);
		}
	}

	private void moveBottom(Role role, int position) throws ASGRuntimeException {
		List<String> targetList = role.getPermissions();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		role.setPermissions(targetList);
		getAnoAccessConfigurationService().updateRole(role);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand anoaccessconfigurationRolePermissionsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		PermissionsElementFB form = new PermissionsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Role role;
		role = getAnoAccessConfigurationService().getRole(id);
		canUpdateRoles(role, req);
		checkRoles(role, req);
		role.addPermissionsElement(form.getPermission());
		getAnoAccessConfigurationService().updateRole(role);
		return anoaccessconfigurationRolePermissionsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand anoaccessconfigurationRolePermissionsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		PermissionsQuickAddFB form = new PermissionsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Role role;
		role = getAnoAccessConfigurationService().getRole(id);
		canUpdateRoles(role, req);
		checkRoles(role, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				role.addPermissionsElement(""+i);
			}
		}
		getAnoAccessConfigurationService().updateRole(role);
		return anoaccessconfigurationRolePermissionsShow(mapping, req, res);
	}

}
