/**
 ********************************************************************************
 *** AccessOperationDocument.java                                             ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.data;

import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class AccessOperationDocument extends AbstractASGDocument implements AccessOperation, IComparable{

	public AccessOperationDocument() {
		super("");
	}

	public AccessOperationDocument(String id){
		super(id);
	}

	public AccessOperationDocument(AccessOperationDocument toClone){
		super(toClone);
	}

	AccessOperationDocument(AccessOperationBuilder builder){
		super("");
		setName(builder.name);
		setDescription(builder.description);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getDescription(){
		return getString(PROP_DESCRIPTION);
	}

	public void setDescription(String value){
		setString(PROP_DESCRIPTION, value);
	}


	public String toString(){
		String ret = "AccessOperation ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "description: "+getDescription();
		return ret;
	}


	public int compareTo(AccessOperation comparable){
		return compareTo(comparable, AccessOperationSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		AccessOperationDocument anotherDoc = (AccessOperationDocument) anotherComparable;
		switch(method){
			case AccessOperationSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case AccessOperationSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case AccessOperationSortType.SORT_BY_DESCRIPTION:
				return BasicComparable.compareString(getDescription(), anotherDoc.getDescription());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "AccessOperation";
	}

	public String getDefinedParentName(){
		return "AnoAccessConfiguration";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getDescription());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof AccessOperationDocument) && ((AccessOperationDocument)o).getId().equals(getId()));
	}
}
