/**
 ********************************************************************************
 *** AnoAccessConfigurationServiceImpl.java                                   ***
 *** The implementation of the IAnoAccessConfigurationService.                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ModuleAnoAccessConfiguration;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperationXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperationDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Role;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.RoleXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.RoleDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceException;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.PermissionXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.PermissionDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ConstraintXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ConstraintDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializerXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializerDocument;

public class AnoAccessConfigurationServiceImpl extends BasicCMSService implements IAnoAccessConfigurationService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static AnoAccessConfigurationServiceImpl instance;

	private AnoAccessConfigurationServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferAnoAccessConfigurationListener());
		addModuleListener(ModuleAnoAccessConfiguration.MODULE_ID, this);
	}

	static final AnoAccessConfigurationServiceImpl getInstance(){
		if (instance==null){
			instance = new AnoAccessConfigurationServiceImpl();
		}
		return instance;
	}

	private ModuleAnoAccessConfiguration _getModuleAnoAccessConfiguration(){
		return (ModuleAnoAccessConfiguration) getModule(ModuleAnoAccessConfiguration.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<AccessOperation> getAccessOperations(){
		List<AccessOperation> accessoperations = new ArrayList<>();
		accessoperations.addAll(_getModuleAnoAccessConfiguration().getAccessOperations());
		return accessoperations;
	}

	@Override
	public List<AccessOperation> getAccessOperations(SortType sortType){
		return StaticQuickSorter.sort(getAccessOperations(), sortType);
	}

	/**
	 * Returns the AccessOperation objects with the specified ids.
	 */
	public List<AccessOperation> getAccessOperations(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<AccessOperation> all = getAccessOperations();
		List<AccessOperation> ret = new ArrayList<>();
		for (AccessOperation accessoperation : all){
			if(ids.contains(accessoperation.getId())){
				ret.add(accessoperation);
			}
		}
		return ret;
	}

	/**
	 * Returns the AccessOperation objects with the specified ids, sorted by given sorttype.
	 */
	public List<AccessOperation> getAccessOperations(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getAccessOperations(ids), sortType);
	}

	@Override
	public void deleteAccessOperation(AccessOperation accessoperation){
		deleteAccessOperation(accessoperation.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(accessoperation);
		}
	}

	@Override
	public void deleteAccessOperation(String id){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		AccessOperation varValue = hasServiceListeners()?module.getAccessOperation(id):null;
		module.deleteAccessOperation(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteAccessOperations(List<AccessOperation> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (AccessOperation accessoperation : list){
			module.deleteAccessOperation(accessoperation.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public AccessOperation getAccessOperation(String id){
		return _getModuleAnoAccessConfiguration().getAccessOperation(id);
	}

	@Override
	public AccessOperation importAccessOperation(AccessOperation accessoperation){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.importAccessOperation((AccessOperationDocument)accessoperation);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(accessoperation);
		}
		return accessoperation;
	}

	@Override
	public List<AccessOperation> importAccessOperations(List<AccessOperation> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<AccessOperation> ret = new ArrayList<>();
		for (AccessOperation accessoperation : list){
			AccessOperation imported = module.importAccessOperation((AccessOperationDocument)accessoperation);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (AccessOperation accessoperation : ret)
				fireObjectImportedEvent(accessoperation);
		}
		return ret;
	}

	@Override
	public AccessOperation createAccessOperation(AccessOperation accessoperation){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.createAccessOperation((AccessOperationDocument)accessoperation);
		updateModule(module);
		fireObjectCreatedEvent(accessoperation);
		return accessoperation;
	}

	@Override
	/**
	 * Creates multiple new AccessOperation objects.
	 * Returns the created versions.
	 */
	public List<AccessOperation> createAccessOperations(List<AccessOperation> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<AccessOperation> ret = new ArrayList<>();
		for (AccessOperation accessoperation : list){
			AccessOperation created = module.createAccessOperation((AccessOperationDocument)accessoperation);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (AccessOperation accessoperation : ret)
				fireObjectCreatedEvent(accessoperation);
		}
		return ret;
	}

	@Override
	public AccessOperation updateAccessOperation(AccessOperation accessoperation){
		AccessOperation oldVersion = null;
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		if (hasServiceListeners())
			oldVersion = module.getAccessOperation(accessoperation.getId());
		module.updateAccessOperation((AccessOperationDocument)accessoperation);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, accessoperation);
		}
		return accessoperation;
	}

	@Override
	public List<AccessOperation> updateAccessOperations(List<AccessOperation> list){
		List<AccessOperation> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (AccessOperation accessoperation : list){
			if (oldList!=null)
				oldList.add(module.getAccessOperation(accessoperation.getId()));
			module.updateAccessOperation((AccessOperationDocument)accessoperation);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<AccessOperation> getAccessOperationsByProperty(String propertyName, Object value){
		List<AccessOperation> allAccessOperations = getAccessOperations();
		List<AccessOperation> ret = new ArrayList<>();
		for (int i=0; i<allAccessOperations.size(); i++){
			AccessOperation accessoperation = allAccessOperations.get(i);
			try{
				Property property = ((AccessOperationDocument)accessoperation).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(accessoperation);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(accessoperation);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(accessoperation);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<AccessOperation> getAccessOperationsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getAccessOperationsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on AccessOperations
	 */
	public QueryResult executeQueryOnAccessOperations(DocumentQuery query){
		List<AccessOperation> allAccessOperations = getAccessOperations();
		QueryResult result = new QueryResult();
		for (int i=0; i<allAccessOperations.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allAccessOperations.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all AccessOperation objects, where property matches.
	 */
	public List<AccessOperation> getAccessOperationsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<AccessOperation> ret = new ArrayList<>();
		List<AccessOperation> src = getAccessOperations();
		for ( AccessOperation accessoperation : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(accessoperation.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(accessoperation);
		}
		return ret;
	}

	/**
	 * Returns all AccessOperation objects, where property matches, sorted
	 */
	public List<AccessOperation> getAccessOperationsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getAccessOperationsByProperty(property), sortType);
	}

	/**
	 * Returns AccessOperation objects count.
	 */
	public int getAccessOperationsCount() {
		return _getModuleAnoAccessConfiguration().getAccessOperations().size();
	}

	/**
	 * Returns AccessOperation objects segment.
	 */
	public List<AccessOperation> getAccessOperations(Segment aSegment) {
		return Slicer.slice(aSegment, getAccessOperations()).getSliceData();
	}

	/**
	 * Returns AccessOperation objects segment, where property matched.
	 */
	public List<AccessOperation> getAccessOperationsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<AccessOperation> ret = new ArrayList<>();
		List<AccessOperation> src = getAccessOperations();
		for (AccessOperation accessoperation : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(accessoperation.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(accessoperation);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns AccessOperation objects segment, where property matched, sorted.
	 */
	public List<AccessOperation> getAccessOperationsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getAccessOperationsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchAccessOperation(final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		if (id.isEmpty() || addedDocuments.contains("AccessOperation" + id))
			return;

		try {
			final AccessOperationDocument accessoperation = _getModuleAnoAccessConfiguration().getAccessOperation(id);
			addedDocuments.add("AccessOperation" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(accessoperation);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "AnoAccessConfiguration");
			dataObject.put("document", "AnoAccessConfiguration_AccessOperation");

			data.put(dataObject);

		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this AccessOperation instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this AccessOperation instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredAccessOperation(final JSONObject data) throws AnoAccessConfigurationServiceException {
		try {
			String objectData = data.getString("object");
			AccessOperation accessoperation = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), AccessOperationDocument.class);

			try {
				updateAccessOperation(accessoperation);
			}catch(Exception e){
				importAccessOperation(accessoperation);
			}
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException("Problem with getting data from json AccessOperation instance :" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException("Problem with parsing data for this AccessOperation instance :" + e.getMessage());
		}
	}

	@Override
	public List<Role> getRoles(){
		List<Role> roles = new ArrayList<>();
		roles.addAll(_getModuleAnoAccessConfiguration().getRoles());
		return roles;
	}

	@Override
	public List<Role> getRoles(SortType sortType){
		return StaticQuickSorter.sort(getRoles(), sortType);
	}

	/**
	 * Returns the Role objects with the specified ids.
	 */
	public List<Role> getRoles(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Role> all = getRoles();
		List<Role> ret = new ArrayList<>();
		for (Role role : all){
			if(ids.contains(role.getId())){
				ret.add(role);
			}
		}
		return ret;
	}

	/**
	 * Returns the Role objects with the specified ids, sorted by given sorttype.
	 */
	public List<Role> getRoles(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getRoles(ids), sortType);
	}

	@Override
	public void deleteRole(Role role){
		deleteRole(role.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(role);
		}
	}

	@Override
	public void deleteRole(String id){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		Role varValue = hasServiceListeners()?module.getRole(id):null;
		module.deleteRole(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteRoles(List<Role> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (Role role : list){
			module.deleteRole(role.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Role getRole(String id){
		return _getModuleAnoAccessConfiguration().getRole(id);
	}

	@Override
	public Role importRole(Role role){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.importRole((RoleDocument)role);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(role);
		}
		return role;
	}

	@Override
	public List<Role> importRoles(List<Role> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<Role> ret = new ArrayList<>();
		for (Role role : list){
			Role imported = module.importRole((RoleDocument)role);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Role role : ret)
				fireObjectImportedEvent(role);
		}
		return ret;
	}

	@Override
	public Role createRole(Role role){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.createRole((RoleDocument)role);
		updateModule(module);
		fireObjectCreatedEvent(role);
		return role;
	}

	@Override
	/**
	 * Creates multiple new Role objects.
	 * Returns the created versions.
	 */
	public List<Role> createRoles(List<Role> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<Role> ret = new ArrayList<>();
		for (Role role : list){
			Role created = module.createRole((RoleDocument)role);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Role role : ret)
				fireObjectCreatedEvent(role);
		}
		return ret;
	}

	@Override
	public Role updateRole(Role role){
		Role oldVersion = null;
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		if (hasServiceListeners())
			oldVersion = module.getRole(role.getId());
		module.updateRole((RoleDocument)role);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, role);
		}
		return role;
	}

	@Override
	public List<Role> updateRoles(List<Role> list){
		List<Role> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (Role role : list){
			if (oldList!=null)
				oldList.add(module.getRole(role.getId()));
			module.updateRole((RoleDocument)role);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Role> getRolesByProperty(String propertyName, Object value){
		List<Role> allRoles = getRoles();
		List<Role> ret = new ArrayList<>();
		for (int i=0; i<allRoles.size(); i++){
			Role role = allRoles.get(i);
			try{
				Property property = ((RoleDocument)role).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(role);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(role);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(role);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Role> getRolesByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getRolesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Roles
	 */
	public QueryResult executeQueryOnRoles(DocumentQuery query){
		List<Role> allRoles = getRoles();
		QueryResult result = new QueryResult();
		for (int i=0; i<allRoles.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allRoles.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Role objects, where property matches.
	 */
	public List<Role> getRolesByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Role> ret = new ArrayList<>();
		List<Role> src = getRoles();
		for ( Role role : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(role.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(role);
		}
		return ret;
	}

	/**
	 * Returns all Role objects, where property matches, sorted
	 */
	public List<Role> getRolesByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getRolesByProperty(property), sortType);
	}

	/**
	 * Returns Role objects count.
	 */
	public int getRolesCount() {
		return _getModuleAnoAccessConfiguration().getRoles().size();
	}

	/**
	 * Returns Role objects segment.
	 */
	public List<Role> getRoles(Segment aSegment) {
		return Slicer.slice(aSegment, getRoles()).getSliceData();
	}

	/**
	 * Returns Role objects segment, where property matched.
	 */
	public List<Role> getRolesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Role> ret = new ArrayList<>();
		List<Role> src = getRoles();
		for (Role role : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(role.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(role);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Role objects segment, where property matched, sorted.
	 */
	public List<Role> getRolesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getRolesByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchRole(final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		if (id.isEmpty() || addedDocuments.contains("Role" + id))
			return;

		try {
			final RoleDocument role = _getModuleAnoAccessConfiguration().getRole(id);
			addedDocuments.add("Role" + id);


			if (!role.getPermissions().isEmpty()) {
				for (String aPermissionsId: role.getPermissions()) {
					getAnoAccessConfigurationService().fetchPermission(aPermissionsId, addedDocuments, data);
				}
			}
			if (!role.getContextInitializers().isEmpty()) {
				for (String aContextInitializersId: role.getContextInitializers()) {
					getAnoAccessConfigurationService().fetchContextInitializer(aContextInitializersId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(role);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "AnoAccessConfiguration");
			dataObject.put("document", "AnoAccessConfiguration_Role");

			data.put(dataObject);

		}catch(AnoAccessConfigurationServiceException e){
			throw new AnoAccessConfigurationServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this Role instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this Role instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredRole(final JSONObject data) throws AnoAccessConfigurationServiceException {
		try {
			String objectData = data.getString("object");
			Role role = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), RoleDocument.class);

			try {
				updateRole(role);
			}catch(Exception e){
				importRole(role);
			}
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException("Problem with getting data from json Role instance :" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException("Problem with parsing data for this Role instance :" + e.getMessage());
		}
	}

	@Override
	public List<Permission> getPermissions(){
		List<Permission> permissions = new ArrayList<>();
		permissions.addAll(_getModuleAnoAccessConfiguration().getPermissions());
		return permissions;
	}

	@Override
	public List<Permission> getPermissions(SortType sortType){
		return StaticQuickSorter.sort(getPermissions(), sortType);
	}

	/**
	 * Returns the Permission objects with the specified ids.
	 */
	public List<Permission> getPermissions(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Permission> all = getPermissions();
		List<Permission> ret = new ArrayList<>();
		for (Permission permission : all){
			if(ids.contains(permission.getId())){
				ret.add(permission);
			}
		}
		return ret;
	}

	/**
	 * Returns the Permission objects with the specified ids, sorted by given sorttype.
	 */
	public List<Permission> getPermissions(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getPermissions(ids), sortType);
	}

	@Override
	public void deletePermission(Permission permission){
		deletePermission(permission.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(permission);
		}
	}

	@Override
	public void deletePermission(String id){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		Permission varValue = hasServiceListeners()?module.getPermission(id):null;
		module.deletePermission(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deletePermissions(List<Permission> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (Permission permission : list){
			module.deletePermission(permission.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Permission getPermission(String id){
		return _getModuleAnoAccessConfiguration().getPermission(id);
	}

	@Override
	public Permission importPermission(Permission permission){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.importPermission((PermissionDocument)permission);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(permission);
		}
		return permission;
	}

	@Override
	public List<Permission> importPermissions(List<Permission> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<Permission> ret = new ArrayList<>();
		for (Permission permission : list){
			Permission imported = module.importPermission((PermissionDocument)permission);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Permission permission : ret)
				fireObjectImportedEvent(permission);
		}
		return ret;
	}

	@Override
	public Permission createPermission(Permission permission){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.createPermission((PermissionDocument)permission);
		updateModule(module);
		fireObjectCreatedEvent(permission);
		return permission;
	}

	@Override
	/**
	 * Creates multiple new Permission objects.
	 * Returns the created versions.
	 */
	public List<Permission> createPermissions(List<Permission> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<Permission> ret = new ArrayList<>();
		for (Permission permission : list){
			Permission created = module.createPermission((PermissionDocument)permission);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Permission permission : ret)
				fireObjectCreatedEvent(permission);
		}
		return ret;
	}

	@Override
	public Permission updatePermission(Permission permission){
		Permission oldVersion = null;
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		if (hasServiceListeners())
			oldVersion = module.getPermission(permission.getId());
		module.updatePermission((PermissionDocument)permission);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, permission);
		}
		return permission;
	}

	@Override
	public List<Permission> updatePermissions(List<Permission> list){
		List<Permission> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (Permission permission : list){
			if (oldList!=null)
				oldList.add(module.getPermission(permission.getId()));
			module.updatePermission((PermissionDocument)permission);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Permission> getPermissionsByProperty(String propertyName, Object value){
		List<Permission> allPermissions = getPermissions();
		List<Permission> ret = new ArrayList<>();
		for (int i=0; i<allPermissions.size(); i++){
			Permission permission = allPermissions.get(i);
			try{
				Property property = ((PermissionDocument)permission).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(permission);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(permission);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(permission);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Permission> getPermissionsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getPermissionsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Permissions
	 */
	public QueryResult executeQueryOnPermissions(DocumentQuery query){
		List<Permission> allPermissions = getPermissions();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPermissions.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPermissions.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Permission objects, where property matches.
	 */
	public List<Permission> getPermissionsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Permission> ret = new ArrayList<>();
		List<Permission> src = getPermissions();
		for ( Permission permission : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(permission.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(permission);
		}
		return ret;
	}

	/**
	 * Returns all Permission objects, where property matches, sorted
	 */
	public List<Permission> getPermissionsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getPermissionsByProperty(property), sortType);
	}

	/**
	 * Returns Permission objects count.
	 */
	public int getPermissionsCount() {
		return _getModuleAnoAccessConfiguration().getPermissions().size();
	}

	/**
	 * Returns Permission objects segment.
	 */
	public List<Permission> getPermissions(Segment aSegment) {
		return Slicer.slice(aSegment, getPermissions()).getSliceData();
	}

	/**
	 * Returns Permission objects segment, where property matched.
	 */
	public List<Permission> getPermissionsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Permission> ret = new ArrayList<>();
		List<Permission> src = getPermissions();
		for (Permission permission : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(permission.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(permission);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Permission objects segment, where property matched, sorted.
	 */
	public List<Permission> getPermissionsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPermissionsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchPermission(final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		if (id.isEmpty() || addedDocuments.contains("Permission" + id))
			return;

		try {
			final PermissionDocument permission = _getModuleAnoAccessConfiguration().getPermission(id);
			addedDocuments.add("Permission" + id);

			if (!StringUtils.isEmpty(permission.getAccessOperation()))
				getAnoAccessConfigurationService().fetchAccessOperation(permission.getAccessOperation(), addedDocuments, data);

			if (!permission.getConstraints().isEmpty()) {
				for (String aConstraintsId: permission.getConstraints()) {
					getAnoAccessConfigurationService().fetchConstraint(aConstraintsId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(permission);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "AnoAccessConfiguration");
			dataObject.put("document", "AnoAccessConfiguration_Permission");

			data.put(dataObject);

		}catch(AnoAccessConfigurationServiceException e){
			throw new AnoAccessConfigurationServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this Permission instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this Permission instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredPermission(final JSONObject data) throws AnoAccessConfigurationServiceException {
		try {
			String objectData = data.getString("object");
			Permission permission = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), PermissionDocument.class);

			try {
				updatePermission(permission);
			}catch(Exception e){
				importPermission(permission);
			}
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException("Problem with getting data from json Permission instance :" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException("Problem with parsing data for this Permission instance :" + e.getMessage());
		}
	}

	@Override
	public List<Constraint> getConstraints(){
		List<Constraint> constraints = new ArrayList<>();
		constraints.addAll(_getModuleAnoAccessConfiguration().getConstraints());
		return constraints;
	}

	@Override
	public List<Constraint> getConstraints(SortType sortType){
		return StaticQuickSorter.sort(getConstraints(), sortType);
	}

	/**
	 * Returns the Constraint objects with the specified ids.
	 */
	public List<Constraint> getConstraints(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<Constraint> all = getConstraints();
		List<Constraint> ret = new ArrayList<>();
		for (Constraint constraint : all){
			if(ids.contains(constraint.getId())){
				ret.add(constraint);
			}
		}
		return ret;
	}

	/**
	 * Returns the Constraint objects with the specified ids, sorted by given sorttype.
	 */
	public List<Constraint> getConstraints(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getConstraints(ids), sortType);
	}

	@Override
	public void deleteConstraint(Constraint constraint){
		deleteConstraint(constraint.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(constraint);
		}
	}

	@Override
	public void deleteConstraint(String id){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		Constraint varValue = hasServiceListeners()?module.getConstraint(id):null;
		module.deleteConstraint(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteConstraints(List<Constraint> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (Constraint constraint : list){
			module.deleteConstraint(constraint.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public Constraint getConstraint(String id){
		return _getModuleAnoAccessConfiguration().getConstraint(id);
	}

	@Override
	public Constraint importConstraint(Constraint constraint){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.importConstraint((ConstraintDocument)constraint);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(constraint);
		}
		return constraint;
	}

	@Override
	public List<Constraint> importConstraints(List<Constraint> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<Constraint> ret = new ArrayList<>();
		for (Constraint constraint : list){
			Constraint imported = module.importConstraint((ConstraintDocument)constraint);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Constraint constraint : ret)
				fireObjectImportedEvent(constraint);
		}
		return ret;
	}

	@Override
	public Constraint createConstraint(Constraint constraint){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.createConstraint((ConstraintDocument)constraint);
		updateModule(module);
		fireObjectCreatedEvent(constraint);
		return constraint;
	}

	@Override
	/**
	 * Creates multiple new Constraint objects.
	 * Returns the created versions.
	 */
	public List<Constraint> createConstraints(List<Constraint> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<Constraint> ret = new ArrayList<>();
		for (Constraint constraint : list){
			Constraint created = module.createConstraint((ConstraintDocument)constraint);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (Constraint constraint : ret)
				fireObjectCreatedEvent(constraint);
		}
		return ret;
	}

	@Override
	public Constraint updateConstraint(Constraint constraint){
		Constraint oldVersion = null;
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		if (hasServiceListeners())
			oldVersion = module.getConstraint(constraint.getId());
		module.updateConstraint((ConstraintDocument)constraint);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, constraint);
		}
		return constraint;
	}

	@Override
	public List<Constraint> updateConstraints(List<Constraint> list){
		List<Constraint> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (Constraint constraint : list){
			if (oldList!=null)
				oldList.add(module.getConstraint(constraint.getId()));
			module.updateConstraint((ConstraintDocument)constraint);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<Constraint> getConstraintsByProperty(String propertyName, Object value){
		List<Constraint> allConstraints = getConstraints();
		List<Constraint> ret = new ArrayList<>();
		for (int i=0; i<allConstraints.size(); i++){
			Constraint constraint = allConstraints.get(i);
			try{
				Property property = ((ConstraintDocument)constraint).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(constraint);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(constraint);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(constraint);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<Constraint> getConstraintsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getConstraintsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Constraints
	 */
	public QueryResult executeQueryOnConstraints(DocumentQuery query){
		List<Constraint> allConstraints = getConstraints();
		QueryResult result = new QueryResult();
		for (int i=0; i<allConstraints.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allConstraints.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Constraint objects, where property matches.
	 */
	public List<Constraint> getConstraintsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<Constraint> ret = new ArrayList<>();
		List<Constraint> src = getConstraints();
		for ( Constraint constraint : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(constraint.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(constraint);
		}
		return ret;
	}

	/**
	 * Returns all Constraint objects, where property matches, sorted
	 */
	public List<Constraint> getConstraintsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getConstraintsByProperty(property), sortType);
	}

	/**
	 * Returns Constraint objects count.
	 */
	public int getConstraintsCount() {
		return _getModuleAnoAccessConfiguration().getConstraints().size();
	}

	/**
	 * Returns Constraint objects segment.
	 */
	public List<Constraint> getConstraints(Segment aSegment) {
		return Slicer.slice(aSegment, getConstraints()).getSliceData();
	}

	/**
	 * Returns Constraint objects segment, where property matched.
	 */
	public List<Constraint> getConstraintsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Constraint> ret = new ArrayList<>();
		List<Constraint> src = getConstraints();
		for (Constraint constraint : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(constraint.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(constraint);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Constraint objects segment, where property matched, sorted.
	 */
	public List<Constraint> getConstraintsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getConstraintsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchConstraint(final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		if (id.isEmpty() || addedDocuments.contains("Constraint" + id))
			return;

		try {
			final ConstraintDocument constraint = _getModuleAnoAccessConfiguration().getConstraint(id);
			addedDocuments.add("Constraint" + id);


			if (!constraint.getContextInitializers().isEmpty()) {
				for (String aContextInitializersId: constraint.getContextInitializers()) {
					getAnoAccessConfigurationService().fetchContextInitializer(aContextInitializersId, addedDocuments, data);
				}
			}

			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(constraint);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "AnoAccessConfiguration");
			dataObject.put("document", "AnoAccessConfiguration_Constraint");

			data.put(dataObject);

		}catch(AnoAccessConfigurationServiceException e){
			throw new AnoAccessConfigurationServiceException("Problem with getting document from AnoAccessConfiguration" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this Constraint instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this Constraint instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredConstraint(final JSONObject data) throws AnoAccessConfigurationServiceException {
		try {
			String objectData = data.getString("object");
			Constraint constraint = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), ConstraintDocument.class);

			try {
				updateConstraint(constraint);
			}catch(Exception e){
				importConstraint(constraint);
			}
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException("Problem with getting data from json Constraint instance :" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException("Problem with parsing data for this Constraint instance :" + e.getMessage());
		}
	}

	@Override
	public List<ContextInitializer> getContextInitializers(){
		List<ContextInitializer> contextinitializers = new ArrayList<>();
		contextinitializers.addAll(_getModuleAnoAccessConfiguration().getContextInitializers());
		return contextinitializers;
	}

	@Override
	public List<ContextInitializer> getContextInitializers(SortType sortType){
		return StaticQuickSorter.sort(getContextInitializers(), sortType);
	}

	/**
	 * Returns the ContextInitializer objects with the specified ids.
	 */
	public List<ContextInitializer> getContextInitializers(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<ContextInitializer> all = getContextInitializers();
		List<ContextInitializer> ret = new ArrayList<>();
		for (ContextInitializer contextinitializer : all){
			if(ids.contains(contextinitializer.getId())){
				ret.add(contextinitializer);
			}
		}
		return ret;
	}

	/**
	 * Returns the ContextInitializer objects with the specified ids, sorted by given sorttype.
	 */
	public List<ContextInitializer> getContextInitializers(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getContextInitializers(ids), sortType);
	}

	@Override
	public void deleteContextInitializer(ContextInitializer contextinitializer){
		deleteContextInitializer(contextinitializer.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(contextinitializer);
		}
	}

	@Override
	public void deleteContextInitializer(String id){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		ContextInitializer varValue = hasServiceListeners()?module.getContextInitializer(id):null;
		module.deleteContextInitializer(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteContextInitializers(List<ContextInitializer> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (ContextInitializer contextinitializer : list){
			module.deleteContextInitializer(contextinitializer.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public ContextInitializer getContextInitializer(String id){
		return _getModuleAnoAccessConfiguration().getContextInitializer(id);
	}

	@Override
	public ContextInitializer importContextInitializer(ContextInitializer contextinitializer){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.importContextInitializer((ContextInitializerDocument)contextinitializer);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(contextinitializer);
		}
		return contextinitializer;
	}

	@Override
	public List<ContextInitializer> importContextInitializers(List<ContextInitializer> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<ContextInitializer> ret = new ArrayList<>();
		for (ContextInitializer contextinitializer : list){
			ContextInitializer imported = module.importContextInitializer((ContextInitializerDocument)contextinitializer);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (ContextInitializer contextinitializer : ret)
				fireObjectImportedEvent(contextinitializer);
		}
		return ret;
	}

	@Override
	public ContextInitializer createContextInitializer(ContextInitializer contextinitializer){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		module.createContextInitializer((ContextInitializerDocument)contextinitializer);
		updateModule(module);
		fireObjectCreatedEvent(contextinitializer);
		return contextinitializer;
	}

	@Override
	/**
	 * Creates multiple new ContextInitializer objects.
	 * Returns the created versions.
	 */
	public List<ContextInitializer> createContextInitializers(List<ContextInitializer> list){
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		List<ContextInitializer> ret = new ArrayList<>();
		for (ContextInitializer contextinitializer : list){
			ContextInitializer created = module.createContextInitializer((ContextInitializerDocument)contextinitializer);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (ContextInitializer contextinitializer : ret)
				fireObjectCreatedEvent(contextinitializer);
		}
		return ret;
	}

	@Override
	public ContextInitializer updateContextInitializer(ContextInitializer contextinitializer){
		ContextInitializer oldVersion = null;
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		if (hasServiceListeners())
			oldVersion = module.getContextInitializer(contextinitializer.getId());
		module.updateContextInitializer((ContextInitializerDocument)contextinitializer);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, contextinitializer);
		}
		return contextinitializer;
	}

	@Override
	public List<ContextInitializer> updateContextInitializers(List<ContextInitializer> list){
		List<ContextInitializer> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleAnoAccessConfiguration module = _getModuleAnoAccessConfiguration();
		for (ContextInitializer contextinitializer : list){
			if (oldList!=null)
				oldList.add(module.getContextInitializer(contextinitializer.getId()));
			module.updateContextInitializer((ContextInitializerDocument)contextinitializer);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<ContextInitializer> getContextInitializersByProperty(String propertyName, Object value){
		List<ContextInitializer> allContextInitializers = getContextInitializers();
		List<ContextInitializer> ret = new ArrayList<>();
		for (int i=0; i<allContextInitializers.size(); i++){
			ContextInitializer contextinitializer = allContextInitializers.get(i);
			try{
				Property property = ((ContextInitializerDocument)contextinitializer).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(contextinitializer);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(contextinitializer);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(contextinitializer);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<ContextInitializer> getContextInitializersByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getContextInitializersByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on ContextInitializers
	 */
	public QueryResult executeQueryOnContextInitializers(DocumentQuery query){
		List<ContextInitializer> allContextInitializers = getContextInitializers();
		QueryResult result = new QueryResult();
		for (int i=0; i<allContextInitializers.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allContextInitializers.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all ContextInitializer objects, where property matches.
	 */
	public List<ContextInitializer> getContextInitializersByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<ContextInitializer> ret = new ArrayList<>();
		List<ContextInitializer> src = getContextInitializers();
		for ( ContextInitializer contextinitializer : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(contextinitializer.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(contextinitializer);
		}
		return ret;
	}

	/**
	 * Returns all ContextInitializer objects, where property matches, sorted
	 */
	public List<ContextInitializer> getContextInitializersByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getContextInitializersByProperty(property), sortType);
	}

	/**
	 * Returns ContextInitializer objects count.
	 */
	public int getContextInitializersCount() {
		return _getModuleAnoAccessConfiguration().getContextInitializers().size();
	}

	/**
	 * Returns ContextInitializer objects segment.
	 */
	public List<ContextInitializer> getContextInitializers(Segment aSegment) {
		return Slicer.slice(aSegment, getContextInitializers()).getSliceData();
	}

	/**
	 * Returns ContextInitializer objects segment, where property matched.
	 */
	public List<ContextInitializer> getContextInitializersByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<ContextInitializer> ret = new ArrayList<>();
		List<ContextInitializer> src = getContextInitializers();
		for (ContextInitializer contextinitializer : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(contextinitializer.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(contextinitializer);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns ContextInitializer objects segment, where property matched, sorted.
	 */
	public List<ContextInitializer> getContextInitializersByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getContextInitializersByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchContextInitializer(final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		if (id.isEmpty() || addedDocuments.contains("ContextInitializer" + id))
			return;

		try {
			final ContextInitializerDocument contextinitializer = _getModuleAnoAccessConfiguration().getContextInitializer(id);
			addedDocuments.add("ContextInitializer" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(contextinitializer);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "AnoAccessConfiguration");
			dataObject.put("document", "AnoAccessConfiguration_ContextInitializer");

			data.put(dataObject);

		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this ContextInitializer instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException ("Problem with fetching data for this ContextInitializer instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredContextInitializer(final JSONObject data) throws AnoAccessConfigurationServiceException {
		try {
			String objectData = data.getString("object");
			ContextInitializer contextinitializer = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), ContextInitializerDocument.class);

			try {
				updateContextInitializer(contextinitializer);
			}catch(Exception e){
				importContextInitializer(contextinitializer);
			}
		}catch(JSONException e){
			throw new AnoAccessConfigurationServiceException("Problem with getting data from json ContextInitializer instance :" + e.getMessage());
		}catch(IOException e){
			throw new AnoAccessConfigurationServiceException("Problem with parsing data for this ContextInitializer instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws AnoAccessConfigurationServiceException {
		switch(documentName) {
			case DOCUMENT_ANOACCESSCONFIGURATION_ACCESSOPERATION:
				saveTransferredAccessOperation(data);
				break;
			case DOCUMENT_ANOACCESSCONFIGURATION_ROLE:
				saveTransferredRole(data);
				break;
			case DOCUMENT_ANOACCESSCONFIGURATION_PERMISSION:
				saveTransferredPermission(data);
				break;
			case DOCUMENT_ANOACCESSCONFIGURATION_CONSTRAINT:
				saveTransferredConstraint(data);
				break;
			case DOCUMENT_ANOACCESSCONFIGURATION_CONTEXTINITIALIZER:
				saveTransferredContextInitializer(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new AnoAccessConfigurationServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnAccessOperations(query).getEntries());
		ret.add(executeQueryOnRoles(query).getEntries());
		ret.add(executeQueryOnPermissions(query).getEntries());
		ret.add(executeQueryOnConstraints(query).getEntries());
		ret.add(executeQueryOnContextInitializers(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportAccessOperationsToXML(){
		XMLNode ret = new XMLNode("AccessOperations");
		List<AccessOperation> list = getAccessOperations();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (AccessOperation object : list)
			ret.addChildNode(AccessOperationXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportAccessOperationsToXML(List<AccessOperation> list){
		XMLNode ret = new XMLNode("AccessOperations");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (AccessOperation object : list)
			ret.addChildNode(AccessOperationXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportRolesToXML(){
		XMLNode ret = new XMLNode("Roles");
		List<Role> list = getRoles();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Role object : list)
			ret.addChildNode(RoleXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportRolesToXML(List<Role> list){
		XMLNode ret = new XMLNode("Roles");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Role object : list)
			ret.addChildNode(RoleXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPermissionsToXML(){
		XMLNode ret = new XMLNode("Permissions");
		List<Permission> list = getPermissions();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Permission object : list)
			ret.addChildNode(PermissionXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPermissionsToXML(List<Permission> list){
		XMLNode ret = new XMLNode("Permissions");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Permission object : list)
			ret.addChildNode(PermissionXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportConstraintsToXML(){
		XMLNode ret = new XMLNode("Constraints");
		List<Constraint> list = getConstraints();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Constraint object : list)
			ret.addChildNode(ConstraintXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportConstraintsToXML(List<Constraint> list){
		XMLNode ret = new XMLNode("Constraints");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Constraint object : list)
			ret.addChildNode(ConstraintXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportContextInitializersToXML(){
		XMLNode ret = new XMLNode("ContextInitializers");
		List<ContextInitializer> list = getContextInitializers();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (ContextInitializer object : list)
			ret.addChildNode(ContextInitializerXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportContextInitializersToXML(List<ContextInitializer> list){
		XMLNode ret = new XMLNode("ContextInitializers");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (ContextInitializer object : list)
			ret.addChildNode(ContextInitializerXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("AnoAccessConfiguration");

		ret.addChildNode(exportAccessOperationsToXML());
		ret.addChildNode(exportRolesToXML());
		ret.addChildNode(exportPermissionsToXML());
		ret.addChildNode(exportConstraintsToXML());
		ret.addChildNode(exportContextInitializersToXML());

		return ret;
	}
}
