/**
 **********************************************************************************
 *** AnoAccessConfigurationServiceFixtureImpl.java                              ***
 *** The implementation of the IAnoAccessConfigurationService for unit testing. ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                        ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net                 ***
 *** All Rights Reserved.                                                       ***
 **********************************************************************************
 *** Don't edit this code, if you aren't sure                                   ***
 *** that you do exactly know what you are doing!                               ***
 *** It's better to invest time in the generator, as into the generated code.   ***
 **********************************************************************************
 */

package net.anotheria.anosite.gen.anoaccessconfiguration.service.fixture;

import java.util.List;
import java.util.Set;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.IAnoAccessConfigurationService;
import net.anotheria.anosite.gen.anoaccessconfiguration.service.AnoAccessConfigurationServiceException;
import net.anotheria.asg.service.BaseFixtureService;
import net.anotheria.asg.service.IFixtureService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.ArrayList;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperation;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperationXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.AccessOperationDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Role;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.RoleXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.RoleDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Permission;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.PermissionXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.PermissionDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.Constraint;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ConstraintXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ConstraintDocument;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializer;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializerXMLHelper;
import net.anotheria.anosite.gen.anoaccessconfiguration.data.ContextInitializerDocument;

public class AnoAccessConfigurationServiceFixtureImpl extends BaseFixtureService implements IAnoAccessConfigurationService, IFixtureService{

	private static AnoAccessConfigurationServiceFixtureImpl instance;

	private Map<String, AccessOperation> accessoperationMap;
	private AtomicInteger accessoperationIdHolder;

	private Map<String, Role> roleMap;
	private AtomicInteger roleIdHolder;

	private Map<String, Permission> permissionMap;
	private AtomicInteger permissionIdHolder;

	private Map<String, Constraint> constraintMap;
	private AtomicInteger constraintIdHolder;

	private Map<String, ContextInitializer> contextinitializerMap;
	private AtomicInteger contextinitializerIdHolder;

	private AnoAccessConfigurationServiceFixtureImpl(){
		reset();
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferAnoAccessConfigurationListener());
	}

	static final AnoAccessConfigurationServiceFixtureImpl getInstance(){
		if (instance==null){
			instance = new AnoAccessConfigurationServiceFixtureImpl();
		}
		return instance;
	}

	@Override public void reset(){
		accessoperationMap = new ConcurrentHashMap<String, AccessOperation>();
		accessoperationIdHolder = new AtomicInteger(0);

		roleMap = new ConcurrentHashMap<String, Role>();
		roleIdHolder = new AtomicInteger(0);

		permissionMap = new ConcurrentHashMap<String, Permission>();
		permissionIdHolder = new AtomicInteger(0);

		constraintMap = new ConcurrentHashMap<String, Constraint>();
		constraintIdHolder = new AtomicInteger(0);

		contextinitializerMap = new ConcurrentHashMap<String, ContextInitializer>();
		contextinitializerIdHolder = new AtomicInteger(0);

	}

	@Override public List<AccessOperation> getAccessOperations() throws AnoAccessConfigurationServiceException {
		List<AccessOperation> ret = new ArrayList<AccessOperation>();
		ret.addAll(accessoperationMap.values());
		return ret;
	}

	@Override public List<AccessOperation> getAccessOperations(SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getAccessOperations(), sortType);
	}

	@Override public void deleteAccessOperation(AccessOperation accessoperation) throws AnoAccessConfigurationServiceException {
		deleteAccessOperation(accessoperation.getId());
	}

	@Override public void deleteAccessOperation(String id) throws AnoAccessConfigurationServiceException {
		AccessOperation old = accessoperationMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple AccessOperation objects.
	 */
	@Override public void deleteAccessOperations(List<AccessOperation> list) throws AnoAccessConfigurationServiceException {
		for (AccessOperation accessoperation : list){
			deleteAccessOperation(accessoperation);
		}
	}

	@Override public AccessOperation getAccessOperation(String id) throws AnoAccessConfigurationServiceException {
		AccessOperation accessoperation = accessoperationMap.get(id);
		if (accessoperation==null)
			throw new AnoAccessConfigurationServiceException("No AccessOperation with id "+id+" found");
		return accessoperation;
	}

	@Override public AccessOperation importAccessOperation(AccessOperation accessoperation) throws AnoAccessConfigurationServiceException {
		accessoperationMap.put(accessoperation.getId(), accessoperation);
		return accessoperation;
	}

	@Override public List<AccessOperation> importAccessOperations(List<AccessOperation> list) throws AnoAccessConfigurationServiceException {
		List<AccessOperation> ret = new ArrayList<AccessOperation>();
		for (AccessOperation accessoperation : list)
			ret.add(importAccessOperation(accessoperation));
		return ret;
	}

	@Override public AccessOperation createAccessOperation(AccessOperation accessoperation) throws AnoAccessConfigurationServiceException {
		String nextId = ""+accessoperationIdHolder.incrementAndGet();
		// //CMS Specific code
		AccessOperationDocument newAccessoperation = (AccessOperationDocument)accessoperation;
		newAccessoperation.renameTo(nextId);
		accessoperationMap.put(newAccessoperation.getId(), newAccessoperation);
		fireObjectCreatedEvent(newAccessoperation);
		return newAccessoperation;
	}

	/**
	 * Creates multiple new AccessOperation objects.
	 * Returns the created versions.
	 */
	@Override public List<AccessOperation> createAccessOperations(List<AccessOperation> list) throws AnoAccessConfigurationServiceException {
		List<AccessOperation> ret = new ArrayList<AccessOperation>();
		for (AccessOperation accessoperation : list)
			ret.add(createAccessOperation(accessoperation));
		return ret;
	}

	/**
	 * Updates multiple new AccessOperation objects.
	 * Returns the updated versions.
	 */
	@Override public List<AccessOperation> updateAccessOperations(List<AccessOperation> list) throws AnoAccessConfigurationServiceException {
		List<AccessOperation> ret = new ArrayList<AccessOperation>();
		for (AccessOperation accessoperation : list)
			ret.add(updateAccessOperation(accessoperation));
		return ret;
	}

	@Override public AccessOperation updateAccessOperation(AccessOperation accessoperation) throws AnoAccessConfigurationServiceException {
		AccessOperation oldVersion = accessoperationMap.put(accessoperation.getId(), accessoperation);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, accessoperation);
		}
		return accessoperation;
	}

	@Override public List<AccessOperation> getAccessOperationsByProperty(String propertyName, Object value) throws AnoAccessConfigurationServiceException {
		List<AccessOperation> list = getAccessOperations();
		List<AccessOperation> ret = new ArrayList<AccessOperation>();
		for (AccessOperation accessoperation : list){
			Object propertyValue = accessoperation.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(accessoperation);
		}
		return ret;
	}

	@Override public List<AccessOperation> getAccessOperationsByProperty(String propertyName, Object value, SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getAccessOperationsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on AccessOperations
	 */
	@Override public QueryResult executeQueryOnAccessOperations(DocumentQuery query) throws AnoAccessConfigurationServiceException {
		List<AccessOperation> allAccessOperations = getAccessOperations();
		QueryResult result = new QueryResult();
		for (int i=0; i<allAccessOperations.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allAccessOperations.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all AccessOperation objects, where property matches.
	 */
	@Override public List<AccessOperation> getAccessOperationsByProperty(QueryProperty... properties) throws AnoAccessConfigurationServiceException {
		List<AccessOperation> list = getAccessOperations();
		if (properties==null || properties.length==0)
			return list;
		List<AccessOperation> ret = new ArrayList<AccessOperation>();
		for (AccessOperation accessoperation : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = accessoperation.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(accessoperation);
		}
		return ret;
	}

	/**
	 * Returns all AccessOperation objects, where property matches, sorted
	 */
	@Override public List<AccessOperation> getAccessOperationsByProperty(SortType sortType, QueryProperty... property) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getAccessOperationsByProperty(property), sortType);
	}

	/**
	 * Returns AccessOperation objects count.
	 */
	@Override public int getAccessOperationsCount() throws AnoAccessConfigurationServiceException {
		return accessoperationMap.values().size();
	}

	/**
	 * Returns AccessOperation objects segment.
	 */
	public List<AccessOperation> getAccessOperations(Segment aSegment) throws AnoAccessConfigurationServiceException {
		return Slicer.slice(aSegment, getAccessOperations()).getSliceData();
	}

	/**
	 * Returns AccessOperation objects segment, where property matched.
	 */
	public List<AccessOperation> getAccessOperationsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<AccessOperation> ret = new ArrayList<>();
		List<AccessOperation> src = new ArrayList<>();
		src.addAll(accessoperationMap.values());
		for (AccessOperation accessoperation : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(accessoperation.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(accessoperation);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns AccessOperation objects segment, where property matched, sorted.
	 */
	public List<AccessOperation> getAccessOperationsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getAccessOperationsByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<Role> getRoles() throws AnoAccessConfigurationServiceException {
		List<Role> ret = new ArrayList<Role>();
		ret.addAll(roleMap.values());
		return ret;
	}

	@Override public List<Role> getRoles(SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getRoles(), sortType);
	}

	@Override public void deleteRole(Role role) throws AnoAccessConfigurationServiceException {
		deleteRole(role.getId());
	}

	@Override public void deleteRole(String id) throws AnoAccessConfigurationServiceException {
		Role old = roleMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple Role objects.
	 */
	@Override public void deleteRoles(List<Role> list) throws AnoAccessConfigurationServiceException {
		for (Role role : list){
			deleteRole(role);
		}
	}

	@Override public Role getRole(String id) throws AnoAccessConfigurationServiceException {
		Role role = roleMap.get(id);
		if (role==null)
			throw new AnoAccessConfigurationServiceException("No Role with id "+id+" found");
		return role;
	}

	@Override public Role importRole(Role role) throws AnoAccessConfigurationServiceException {
		roleMap.put(role.getId(), role);
		return role;
	}

	@Override public List<Role> importRoles(List<Role> list) throws AnoAccessConfigurationServiceException {
		List<Role> ret = new ArrayList<Role>();
		for (Role role : list)
			ret.add(importRole(role));
		return ret;
	}

	@Override public Role createRole(Role role) throws AnoAccessConfigurationServiceException {
		String nextId = ""+roleIdHolder.incrementAndGet();
		// //CMS Specific code
		RoleDocument newRole = (RoleDocument)role;
		newRole.renameTo(nextId);
		roleMap.put(newRole.getId(), newRole);
		fireObjectCreatedEvent(newRole);
		return newRole;
	}

	/**
	 * Creates multiple new Role objects.
	 * Returns the created versions.
	 */
	@Override public List<Role> createRoles(List<Role> list) throws AnoAccessConfigurationServiceException {
		List<Role> ret = new ArrayList<Role>();
		for (Role role : list)
			ret.add(createRole(role));
		return ret;
	}

	/**
	 * Updates multiple new Role objects.
	 * Returns the updated versions.
	 */
	@Override public List<Role> updateRoles(List<Role> list) throws AnoAccessConfigurationServiceException {
		List<Role> ret = new ArrayList<Role>();
		for (Role role : list)
			ret.add(updateRole(role));
		return ret;
	}

	@Override public Role updateRole(Role role) throws AnoAccessConfigurationServiceException {
		Role oldVersion = roleMap.put(role.getId(), role);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, role);
		}
		return role;
	}

	@Override public List<Role> getRolesByProperty(String propertyName, Object value) throws AnoAccessConfigurationServiceException {
		List<Role> list = getRoles();
		List<Role> ret = new ArrayList<Role>();
		for (Role role : list){
			Object propertyValue = role.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(role);
		}
		return ret;
	}

	@Override public List<Role> getRolesByProperty(String propertyName, Object value, SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getRolesByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Roles
	 */
	@Override public QueryResult executeQueryOnRoles(DocumentQuery query) throws AnoAccessConfigurationServiceException {
		List<Role> allRoles = getRoles();
		QueryResult result = new QueryResult();
		for (int i=0; i<allRoles.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allRoles.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Role objects, where property matches.
	 */
	@Override public List<Role> getRolesByProperty(QueryProperty... properties) throws AnoAccessConfigurationServiceException {
		List<Role> list = getRoles();
		if (properties==null || properties.length==0)
			return list;
		List<Role> ret = new ArrayList<Role>();
		for (Role role : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = role.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(role);
		}
		return ret;
	}

	/**
	 * Returns all Role objects, where property matches, sorted
	 */
	@Override public List<Role> getRolesByProperty(SortType sortType, QueryProperty... property) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getRolesByProperty(property), sortType);
	}

	/**
	 * Returns Role objects count.
	 */
	@Override public int getRolesCount() throws AnoAccessConfigurationServiceException {
		return roleMap.values().size();
	}

	/**
	 * Returns Role objects segment.
	 */
	public List<Role> getRoles(Segment aSegment) throws AnoAccessConfigurationServiceException {
		return Slicer.slice(aSegment, getRoles()).getSliceData();
	}

	/**
	 * Returns Role objects segment, where property matched.
	 */
	public List<Role> getRolesByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Role> ret = new ArrayList<>();
		List<Role> src = new ArrayList<>();
		src.addAll(roleMap.values());
		for (Role role : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(role.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(role);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Role objects segment, where property matched, sorted.
	 */
	public List<Role> getRolesByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getRolesByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<Permission> getPermissions() throws AnoAccessConfigurationServiceException {
		List<Permission> ret = new ArrayList<Permission>();
		ret.addAll(permissionMap.values());
		return ret;
	}

	@Override public List<Permission> getPermissions(SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getPermissions(), sortType);
	}

	@Override public void deletePermission(Permission permission) throws AnoAccessConfigurationServiceException {
		deletePermission(permission.getId());
	}

	@Override public void deletePermission(String id) throws AnoAccessConfigurationServiceException {
		Permission old = permissionMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple Permission objects.
	 */
	@Override public void deletePermissions(List<Permission> list) throws AnoAccessConfigurationServiceException {
		for (Permission permission : list){
			deletePermission(permission);
		}
	}

	@Override public Permission getPermission(String id) throws AnoAccessConfigurationServiceException {
		Permission permission = permissionMap.get(id);
		if (permission==null)
			throw new AnoAccessConfigurationServiceException("No Permission with id "+id+" found");
		return permission;
	}

	@Override public Permission importPermission(Permission permission) throws AnoAccessConfigurationServiceException {
		permissionMap.put(permission.getId(), permission);
		return permission;
	}

	@Override public List<Permission> importPermissions(List<Permission> list) throws AnoAccessConfigurationServiceException {
		List<Permission> ret = new ArrayList<Permission>();
		for (Permission permission : list)
			ret.add(importPermission(permission));
		return ret;
	}

	@Override public Permission createPermission(Permission permission) throws AnoAccessConfigurationServiceException {
		String nextId = ""+permissionIdHolder.incrementAndGet();
		// //CMS Specific code
		PermissionDocument newPermission = (PermissionDocument)permission;
		newPermission.renameTo(nextId);
		permissionMap.put(newPermission.getId(), newPermission);
		fireObjectCreatedEvent(newPermission);
		return newPermission;
	}

	/**
	 * Creates multiple new Permission objects.
	 * Returns the created versions.
	 */
	@Override public List<Permission> createPermissions(List<Permission> list) throws AnoAccessConfigurationServiceException {
		List<Permission> ret = new ArrayList<Permission>();
		for (Permission permission : list)
			ret.add(createPermission(permission));
		return ret;
	}

	/**
	 * Updates multiple new Permission objects.
	 * Returns the updated versions.
	 */
	@Override public List<Permission> updatePermissions(List<Permission> list) throws AnoAccessConfigurationServiceException {
		List<Permission> ret = new ArrayList<Permission>();
		for (Permission permission : list)
			ret.add(updatePermission(permission));
		return ret;
	}

	@Override public Permission updatePermission(Permission permission) throws AnoAccessConfigurationServiceException {
		Permission oldVersion = permissionMap.put(permission.getId(), permission);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, permission);
		}
		return permission;
	}

	@Override public List<Permission> getPermissionsByProperty(String propertyName, Object value) throws AnoAccessConfigurationServiceException {
		List<Permission> list = getPermissions();
		List<Permission> ret = new ArrayList<Permission>();
		for (Permission permission : list){
			Object propertyValue = permission.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(permission);
		}
		return ret;
	}

	@Override public List<Permission> getPermissionsByProperty(String propertyName, Object value, SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getPermissionsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Permissions
	 */
	@Override public QueryResult executeQueryOnPermissions(DocumentQuery query) throws AnoAccessConfigurationServiceException {
		List<Permission> allPermissions = getPermissions();
		QueryResult result = new QueryResult();
		for (int i=0; i<allPermissions.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allPermissions.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Permission objects, where property matches.
	 */
	@Override public List<Permission> getPermissionsByProperty(QueryProperty... properties) throws AnoAccessConfigurationServiceException {
		List<Permission> list = getPermissions();
		if (properties==null || properties.length==0)
			return list;
		List<Permission> ret = new ArrayList<Permission>();
		for (Permission permission : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = permission.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(permission);
		}
		return ret;
	}

	/**
	 * Returns all Permission objects, where property matches, sorted
	 */
	@Override public List<Permission> getPermissionsByProperty(SortType sortType, QueryProperty... property) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getPermissionsByProperty(property), sortType);
	}

	/**
	 * Returns Permission objects count.
	 */
	@Override public int getPermissionsCount() throws AnoAccessConfigurationServiceException {
		return permissionMap.values().size();
	}

	/**
	 * Returns Permission objects segment.
	 */
	public List<Permission> getPermissions(Segment aSegment) throws AnoAccessConfigurationServiceException {
		return Slicer.slice(aSegment, getPermissions()).getSliceData();
	}

	/**
	 * Returns Permission objects segment, where property matched.
	 */
	public List<Permission> getPermissionsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Permission> ret = new ArrayList<>();
		List<Permission> src = new ArrayList<>();
		src.addAll(permissionMap.values());
		for (Permission permission : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(permission.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(permission);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Permission objects segment, where property matched, sorted.
	 */
	public List<Permission> getPermissionsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getPermissionsByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<Constraint> getConstraints() throws AnoAccessConfigurationServiceException {
		List<Constraint> ret = new ArrayList<Constraint>();
		ret.addAll(constraintMap.values());
		return ret;
	}

	@Override public List<Constraint> getConstraints(SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getConstraints(), sortType);
	}

	@Override public void deleteConstraint(Constraint constraint) throws AnoAccessConfigurationServiceException {
		deleteConstraint(constraint.getId());
	}

	@Override public void deleteConstraint(String id) throws AnoAccessConfigurationServiceException {
		Constraint old = constraintMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple Constraint objects.
	 */
	@Override public void deleteConstraints(List<Constraint> list) throws AnoAccessConfigurationServiceException {
		for (Constraint constraint : list){
			deleteConstraint(constraint);
		}
	}

	@Override public Constraint getConstraint(String id) throws AnoAccessConfigurationServiceException {
		Constraint constraint = constraintMap.get(id);
		if (constraint==null)
			throw new AnoAccessConfigurationServiceException("No Constraint with id "+id+" found");
		return constraint;
	}

	@Override public Constraint importConstraint(Constraint constraint) throws AnoAccessConfigurationServiceException {
		constraintMap.put(constraint.getId(), constraint);
		return constraint;
	}

	@Override public List<Constraint> importConstraints(List<Constraint> list) throws AnoAccessConfigurationServiceException {
		List<Constraint> ret = new ArrayList<Constraint>();
		for (Constraint constraint : list)
			ret.add(importConstraint(constraint));
		return ret;
	}

	@Override public Constraint createConstraint(Constraint constraint) throws AnoAccessConfigurationServiceException {
		String nextId = ""+constraintIdHolder.incrementAndGet();
		// //CMS Specific code
		ConstraintDocument newConstraint = (ConstraintDocument)constraint;
		newConstraint.renameTo(nextId);
		constraintMap.put(newConstraint.getId(), newConstraint);
		fireObjectCreatedEvent(newConstraint);
		return newConstraint;
	}

	/**
	 * Creates multiple new Constraint objects.
	 * Returns the created versions.
	 */
	@Override public List<Constraint> createConstraints(List<Constraint> list) throws AnoAccessConfigurationServiceException {
		List<Constraint> ret = new ArrayList<Constraint>();
		for (Constraint constraint : list)
			ret.add(createConstraint(constraint));
		return ret;
	}

	/**
	 * Updates multiple new Constraint objects.
	 * Returns the updated versions.
	 */
	@Override public List<Constraint> updateConstraints(List<Constraint> list) throws AnoAccessConfigurationServiceException {
		List<Constraint> ret = new ArrayList<Constraint>();
		for (Constraint constraint : list)
			ret.add(updateConstraint(constraint));
		return ret;
	}

	@Override public Constraint updateConstraint(Constraint constraint) throws AnoAccessConfigurationServiceException {
		Constraint oldVersion = constraintMap.put(constraint.getId(), constraint);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, constraint);
		}
		return constraint;
	}

	@Override public List<Constraint> getConstraintsByProperty(String propertyName, Object value) throws AnoAccessConfigurationServiceException {
		List<Constraint> list = getConstraints();
		List<Constraint> ret = new ArrayList<Constraint>();
		for (Constraint constraint : list){
			Object propertyValue = constraint.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(constraint);
		}
		return ret;
	}

	@Override public List<Constraint> getConstraintsByProperty(String propertyName, Object value, SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getConstraintsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on Constraints
	 */
	@Override public QueryResult executeQueryOnConstraints(DocumentQuery query) throws AnoAccessConfigurationServiceException {
		List<Constraint> allConstraints = getConstraints();
		QueryResult result = new QueryResult();
		for (int i=0; i<allConstraints.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allConstraints.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all Constraint objects, where property matches.
	 */
	@Override public List<Constraint> getConstraintsByProperty(QueryProperty... properties) throws AnoAccessConfigurationServiceException {
		List<Constraint> list = getConstraints();
		if (properties==null || properties.length==0)
			return list;
		List<Constraint> ret = new ArrayList<Constraint>();
		for (Constraint constraint : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = constraint.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(constraint);
		}
		return ret;
	}

	/**
	 * Returns all Constraint objects, where property matches, sorted
	 */
	@Override public List<Constraint> getConstraintsByProperty(SortType sortType, QueryProperty... property) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getConstraintsByProperty(property), sortType);
	}

	/**
	 * Returns Constraint objects count.
	 */
	@Override public int getConstraintsCount() throws AnoAccessConfigurationServiceException {
		return constraintMap.values().size();
	}

	/**
	 * Returns Constraint objects segment.
	 */
	public List<Constraint> getConstraints(Segment aSegment) throws AnoAccessConfigurationServiceException {
		return Slicer.slice(aSegment, getConstraints()).getSliceData();
	}

	/**
	 * Returns Constraint objects segment, where property matched.
	 */
	public List<Constraint> getConstraintsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<Constraint> ret = new ArrayList<>();
		List<Constraint> src = new ArrayList<>();
		src.addAll(constraintMap.values());
		for (Constraint constraint : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(constraint.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(constraint);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns Constraint objects segment, where property matched, sorted.
	 */
	public List<Constraint> getConstraintsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getConstraintsByProperty(aSegment, aProperty), aSortType);
	}

	@Override public List<ContextInitializer> getContextInitializers() throws AnoAccessConfigurationServiceException {
		List<ContextInitializer> ret = new ArrayList<ContextInitializer>();
		ret.addAll(contextinitializerMap.values());
		return ret;
	}

	@Override public List<ContextInitializer> getContextInitializers(SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getContextInitializers(), sortType);
	}

	@Override public void deleteContextInitializer(ContextInitializer contextinitializer) throws AnoAccessConfigurationServiceException {
		deleteContextInitializer(contextinitializer.getId());
	}

	@Override public void deleteContextInitializer(String id) throws AnoAccessConfigurationServiceException {
		ContextInitializer old = contextinitializerMap.remove(id);
		if (old!=null){
			fireObjectDeletedEvent(old);
		}
	}

	/**
	 * Deletes multiple ContextInitializer objects.
	 */
	@Override public void deleteContextInitializers(List<ContextInitializer> list) throws AnoAccessConfigurationServiceException {
		for (ContextInitializer contextinitializer : list){
			deleteContextInitializer(contextinitializer);
		}
	}

	@Override public ContextInitializer getContextInitializer(String id) throws AnoAccessConfigurationServiceException {
		ContextInitializer contextinitializer = contextinitializerMap.get(id);
		if (contextinitializer==null)
			throw new AnoAccessConfigurationServiceException("No ContextInitializer with id "+id+" found");
		return contextinitializer;
	}

	@Override public ContextInitializer importContextInitializer(ContextInitializer contextinitializer) throws AnoAccessConfigurationServiceException {
		contextinitializerMap.put(contextinitializer.getId(), contextinitializer);
		return contextinitializer;
	}

	@Override public List<ContextInitializer> importContextInitializers(List<ContextInitializer> list) throws AnoAccessConfigurationServiceException {
		List<ContextInitializer> ret = new ArrayList<ContextInitializer>();
		for (ContextInitializer contextinitializer : list)
			ret.add(importContextInitializer(contextinitializer));
		return ret;
	}

	@Override public ContextInitializer createContextInitializer(ContextInitializer contextinitializer) throws AnoAccessConfigurationServiceException {
		String nextId = ""+contextinitializerIdHolder.incrementAndGet();
		// //CMS Specific code
		ContextInitializerDocument newContextinitializer = (ContextInitializerDocument)contextinitializer;
		newContextinitializer.renameTo(nextId);
		contextinitializerMap.put(newContextinitializer.getId(), newContextinitializer);
		fireObjectCreatedEvent(newContextinitializer);
		return newContextinitializer;
	}

	/**
	 * Creates multiple new ContextInitializer objects.
	 * Returns the created versions.
	 */
	@Override public List<ContextInitializer> createContextInitializers(List<ContextInitializer> list) throws AnoAccessConfigurationServiceException {
		List<ContextInitializer> ret = new ArrayList<ContextInitializer>();
		for (ContextInitializer contextinitializer : list)
			ret.add(createContextInitializer(contextinitializer));
		return ret;
	}

	/**
	 * Updates multiple new ContextInitializer objects.
	 * Returns the updated versions.
	 */
	@Override public List<ContextInitializer> updateContextInitializers(List<ContextInitializer> list) throws AnoAccessConfigurationServiceException {
		List<ContextInitializer> ret = new ArrayList<ContextInitializer>();
		for (ContextInitializer contextinitializer : list)
			ret.add(updateContextInitializer(contextinitializer));
		return ret;
	}

	@Override public ContextInitializer updateContextInitializer(ContextInitializer contextinitializer) throws AnoAccessConfigurationServiceException {
		ContextInitializer oldVersion = contextinitializerMap.put(contextinitializer.getId(), contextinitializer);
		if (oldVersion!=null){
				fireObjectUpdatedEvent(oldVersion, contextinitializer);
		}
		return contextinitializer;
	}

	@Override public List<ContextInitializer> getContextInitializersByProperty(String propertyName, Object value) throws AnoAccessConfigurationServiceException {
		List<ContextInitializer> list = getContextInitializers();
		List<ContextInitializer> ret = new ArrayList<ContextInitializer>();
		for (ContextInitializer contextinitializer : list){
			Object propertyValue = contextinitializer.getPropertyValue(propertyName);
			if (propertyValue!=null && propertyValue.equals(value))
				ret.add(contextinitializer);
		}
		return ret;
	}

	@Override public List<ContextInitializer> getContextInitializersByProperty(String propertyName, Object value, SortType sortType) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getContextInitializersByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on ContextInitializers
	 */
	@Override public QueryResult executeQueryOnContextInitializers(DocumentQuery query) throws AnoAccessConfigurationServiceException {
		List<ContextInitializer> allContextInitializers = getContextInitializers();
		QueryResult result = new QueryResult();
		for (int i=0; i<allContextInitializers.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allContextInitializers.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all ContextInitializer objects, where property matches.
	 */
	@Override public List<ContextInitializer> getContextInitializersByProperty(QueryProperty... properties) throws AnoAccessConfigurationServiceException {
		List<ContextInitializer> list = getContextInitializers();
		if (properties==null || properties.length==0)
			return list;
		List<ContextInitializer> ret = new ArrayList<ContextInitializer>();
		for (ContextInitializer contextinitializer : list){
			boolean mayPass = true;
			for (QueryProperty p : properties){
				Object propertyValue = contextinitializer.getPropertyValue(p.getName());
				if (mayPass && (propertyValue==null || (!(p.doesMatch(propertyValue)))))
					mayPass = false;
			}
			if (mayPass)
				ret.add(contextinitializer);
		}
		return ret;
	}

	/**
	 * Returns all ContextInitializer objects, where property matches, sorted
	 */
	@Override public List<ContextInitializer> getContextInitializersByProperty(SortType sortType, QueryProperty... property) throws AnoAccessConfigurationServiceException {
		return StaticQuickSorter.sort(getContextInitializersByProperty(property), sortType);
	}

	/**
	 * Returns ContextInitializer objects count.
	 */
	@Override public int getContextInitializersCount() throws AnoAccessConfigurationServiceException {
		return contextinitializerMap.values().size();
	}

	/**
	 * Returns ContextInitializer objects segment.
	 */
	public List<ContextInitializer> getContextInitializers(Segment aSegment) throws AnoAccessConfigurationServiceException {
		return Slicer.slice(aSegment, getContextInitializers()).getSliceData();
	}

	/**
	 * Returns ContextInitializer objects segment, where property matched.
	 */
	public List<ContextInitializer> getContextInitializersByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<ContextInitializer> ret = new ArrayList<>();
		List<ContextInitializer> src = new ArrayList<>();
		src.addAll(contextinitializerMap.values());
		for (ContextInitializer contextinitializer : src) {;
			boolean mayPass = true;
			for (QueryProperty qp : property) {;
				mayPass = mayPass && qp.doesMatch(contextinitializer.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(contextinitializer);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns ContextInitializer objects segment, where property matched, sorted.
	 */
	public List<ContextInitializer> getContextInitializersByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getContextInitializersByProperty(aSegment, aProperty), aSortType);
	}


	public XMLNode exportAccessOperationsToXML(){
		XMLNode ret = new XMLNode("AccessOperations");
		try{
			List<AccessOperation> list = getAccessOperations();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (AccessOperation object : list)
				ret.addChildNode(AccessOperationXMLHelper.toXML(object));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportAccessOperationsToXML() failure: " , e);
		}
	}

	public XMLNode exportAccessOperationsToXML(List<AccessOperation> list){
		XMLNode ret = new XMLNode("AccessOperations");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (AccessOperation object : list)
			ret.addChildNode(AccessOperationXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportAccessOperationsToXML(String languages[]){
		XMLNode ret = new XMLNode("AccessOperations");
		try{
			List<AccessOperation> list = getAccessOperations();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (AccessOperation object : list)
				ret.addChildNode(AccessOperationXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportAccessOperationsToXML() failure: " , e);
		}
	}

	public XMLNode exportAccessOperationsToXML(String languages[], List<AccessOperation> list){
		XMLNode ret = new XMLNode("AccessOperations");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (AccessOperation object : list)
			ret.addChildNode(AccessOperationXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchAccessOperation (final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	public XMLNode exportRolesToXML(){
		XMLNode ret = new XMLNode("Roles");
		try{
			List<Role> list = getRoles();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (Role object : list)
				ret.addChildNode(RoleXMLHelper.toXML(object));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportRolesToXML() failure: " , e);
		}
	}

	public XMLNode exportRolesToXML(List<Role> list){
		XMLNode ret = new XMLNode("Roles");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Role object : list)
			ret.addChildNode(RoleXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportRolesToXML(String languages[]){
		XMLNode ret = new XMLNode("Roles");
		try{
			List<Role> list = getRoles();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (Role object : list)
				ret.addChildNode(RoleXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportRolesToXML() failure: " , e);
		}
	}

	public XMLNode exportRolesToXML(String languages[], List<Role> list){
		XMLNode ret = new XMLNode("Roles");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Role object : list)
			ret.addChildNode(RoleXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchRole (final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	public XMLNode exportPermissionsToXML(){
		XMLNode ret = new XMLNode("Permissions");
		try{
			List<Permission> list = getPermissions();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (Permission object : list)
				ret.addChildNode(PermissionXMLHelper.toXML(object));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportPermissionsToXML() failure: " , e);
		}
	}

	public XMLNode exportPermissionsToXML(List<Permission> list){
		XMLNode ret = new XMLNode("Permissions");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Permission object : list)
			ret.addChildNode(PermissionXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportPermissionsToXML(String languages[]){
		XMLNode ret = new XMLNode("Permissions");
		try{
			List<Permission> list = getPermissions();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (Permission object : list)
				ret.addChildNode(PermissionXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportPermissionsToXML() failure: " , e);
		}
	}

	public XMLNode exportPermissionsToXML(String languages[], List<Permission> list){
		XMLNode ret = new XMLNode("Permissions");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Permission object : list)
			ret.addChildNode(PermissionXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchPermission (final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	public XMLNode exportConstraintsToXML(){
		XMLNode ret = new XMLNode("Constraints");
		try{
			List<Constraint> list = getConstraints();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (Constraint object : list)
				ret.addChildNode(ConstraintXMLHelper.toXML(object));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportConstraintsToXML() failure: " , e);
		}
	}

	public XMLNode exportConstraintsToXML(List<Constraint> list){
		XMLNode ret = new XMLNode("Constraints");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Constraint object : list)
			ret.addChildNode(ConstraintXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportConstraintsToXML(String languages[]){
		XMLNode ret = new XMLNode("Constraints");
		try{
			List<Constraint> list = getConstraints();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (Constraint object : list)
				ret.addChildNode(ConstraintXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportConstraintsToXML() failure: " , e);
		}
	}

	public XMLNode exportConstraintsToXML(String languages[], List<Constraint> list){
		XMLNode ret = new XMLNode("Constraints");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (Constraint object : list)
			ret.addChildNode(ConstraintXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchConstraint (final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	public XMLNode exportContextInitializersToXML(){
		XMLNode ret = new XMLNode("ContextInitializers");
		try{
			List<ContextInitializer> list = getContextInitializers();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (ContextInitializer object : list)
				ret.addChildNode(ContextInitializerXMLHelper.toXML(object));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportContextInitializersToXML() failure: " , e);
		}
	}

	public XMLNode exportContextInitializersToXML(List<ContextInitializer> list){
		XMLNode ret = new XMLNode("ContextInitializers");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (ContextInitializer object : list)
			ret.addChildNode(ContextInitializerXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportContextInitializersToXML(String languages[]){
		XMLNode ret = new XMLNode("ContextInitializers");
		try{
			List<ContextInitializer> list = getContextInitializers();
			ret.addAttribute(new XMLAttribute("count", list.size()));
			for (ContextInitializer object : list)
				ret.addChildNode(ContextInitializerXMLHelper.toXML(object, languages));
			return ret;
		}
		catch(AnoAccessConfigurationServiceException e){
			throw new RuntimeException("exportContextInitializersToXML() failure: " , e);
		}
	}

	public XMLNode exportContextInitializersToXML(String languages[], List<ContextInitializer> list){
		XMLNode ret = new XMLNode("ContextInitializers");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (ContextInitializer object : list)
			ret.addChildNode(ContextInitializerXMLHelper.toXML(object, languages));
		return ret;
	}

	public void fetchContextInitializer (final String id, Set<String> addedDocuments, JSONArray data) throws AnoAccessConfigurationServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws AnoAccessConfigurationServiceException {
		throw new UnsupportedOperationException(" not implemented and should not BE!");
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query) throws AnoAccessConfigurationServiceException {
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnAccessOperations(query).getEntries());
		ret.add(executeQueryOnRoles(query).getEntries());
		ret.add(executeQueryOnPermissions(query).getEntries());
		ret.add(executeQueryOnConstraints(query).getEntries());
		ret.add(executeQueryOnContextInitializers(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects

	@Override public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("AnoAccessConfiguration");

		ret.addChildNode(exportAccessOperationsToXML());
		ret.addChildNode(exportRolesToXML());
		ret.addChildNode(exportPermissionsToXML());
		ret.addChildNode(exportConstraintsToXML());
		ret.addChildNode(exportContextInitializersToXML());

		return ret;
	}

}
