/**
 ********************************************************************************
 *** MultiOpBrandsAttributesAction.java                                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asbrand.data.BrandFactory;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.bean.AttributesElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asbrand.bean.AttributesQuickAddFB;
import net.anotheria.anosite.gen.aswebdata.data.Attribute;
import net.anotheria.anosite.gen.aswebdata.data.AttributeSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBrandsAttributesAction extends BaseBrandAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asbrandBrandAttributesShow"))
			return asbrandBrandAttributesShow(mapping, req, res);
		if (path.equals("asbrandBrandAttributesAdd"))
			return asbrandBrandAttributesAdd(mapping, req, res);
		if (path.equals("asbrandBrandAttributesDelete"))
			return asbrandBrandAttributesDelete(mapping, req, res);
		if (path.equals("asbrandBrandAttributesMove"))
			return asbrandBrandAttributesMove(mapping, req, res);
		if (path.equals("asbrandBrandAttributesQuickAdd"))
			return asbrandBrandAttributesQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asbrandBrandAttributesShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Brand brand = getASBrandService().getBrand(id);
		addBeanToRequest(req, "ownerId", id);
		checkBrands(brand, req);

		AttributesElementFB form = new AttributesElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(brand.getId());
		addBeanToRequest(req, "asbrandBrandAttributesElementForm", form);

		AttributesQuickAddFB quickAddForm = new AttributesQuickAddFB() ;
		quickAddForm.setOwnerId(brand.getId());
		addBeanToRequest(req, "asbrandBrandAttributesQuickAddForm", quickAddForm);


		//link attribute to ASWebData.Attribute
		List<Attribute> attributes = getASWebDataService().getAttributes(new AttributeSortType(AttributeSortType.SORT_BY_NAME));
		List<LabelValueBean> attributesValues = new ArrayList<LabelValueBean>(attributes.size());
		for (int i=0; i<attributes.size(); i++){
			net.anotheria.anosite.gen.aswebdata.data.Attribute tmp_attribute = (net.anotheria.anosite.gen.aswebdata.data.Attribute) attributes.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_attribute.getId(), tmp_attribute.getName()+" ["+tmp_attribute.getId()+"]" );
			attributesValues.add(bean);
		}
		addBeanToRequest(req, "attributeValuesCollection", attributesValues);
		// generate list ...
		int size = brand.getAttributesSize();
		List<AttributesElementFB> beans = new ArrayList<AttributesElementFB>(size);
		for (int i=0; i<size; i++){
			String value = brand.getAttributesElement(i);
			AttributesElementFB bean = new AttributesElementFB();
			bean.setOwnerId(brand.getId());
			bean.setPosition(i);
			bean.setAttribute(value);
			try{
				Attribute tmp_attribute = getASWebDataService().getAttribute(value);
				bean.setDescription(tmp_attribute.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asbrandBrandAttributesDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Brand brandCurr = getASBrandService().getBrand(id);
		canUpdateBrands(brandCurr, req);
		checkBrands(brandCurr, req);
		int position = getIntParameter(req, "pPosition");
		Brand brand = getASBrandService().getBrand(id);
		brand.removeAttributesElement(position);
		getASBrandService().updateBrand(brand);
		return asbrandBrandAttributesShow(mapping, req, res);
	}

	public ActionCommand asbrandBrandAttributesMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Brand brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(brand, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(brand, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(brand, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(brand, position);
		return asbrandBrandAttributesShow(mapping, req, res);
	}

	private void moveUp(Brand brand, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		brand.swapAttributesElement(position, position-1);
		getASBrandService().updateBrand(brand);
	}

	private void moveTop(Brand brand, int position) throws ASGRuntimeException {
		List<String> targetList = brand.getAttributes();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		brand.setAttributes(targetList);
		getASBrandService().updateBrand(brand);
	}

	private void moveDown(Brand brand, int position) throws ASGRuntimeException {
		if (position<brand.getAttributesSize()-1){
			brand.swapAttributesElement(position, position+1);
			getASBrandService().updateBrand(brand);
		}
	}

	private void moveBottom(Brand brand, int position) throws ASGRuntimeException {
		List<String> targetList = brand.getAttributes();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		brand.setAttributes(targetList);
		getASBrandService().updateBrand(brand);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asbrandBrandAttributesAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		AttributesElementFB form = new AttributesElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Brand brand;
		brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		brand.addAttributesElement(form.getAttribute());
		getASBrandService().updateBrand(brand);
		return asbrandBrandAttributesShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asbrandBrandAttributesQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		AttributesQuickAddFB form = new AttributesQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Brand brand;
		brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				brand.addAttributesElement(""+i);
			}
		}
		getASBrandService().updateBrand(brand);
		return asbrandBrandAttributesShow(mapping, req, res);
	}

}
