/**
 ********************************************************************************
 *** MultiOpBrandsUrlsToMapAction.java                                        ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asbrand.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asbrand.data.BrandFactory;
import net.anotheria.anosite.gen.asbrand.data.Brand;
import net.anotheria.anosite.gen.asbrand.bean.UrlsToMapElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBrandsUrlsToMapAction extends BaseBrandAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asbrandBrandUrlsToMapShow"))
			return asbrandBrandUrlsToMapShow(mapping, req, res);
		if (path.equals("asbrandBrandUrlsToMapAdd"))
			return asbrandBrandUrlsToMapAdd(mapping, req, res);
		if (path.equals("asbrandBrandUrlsToMapDelete"))
			return asbrandBrandUrlsToMapDelete(mapping, req, res);
		if (path.equals("asbrandBrandUrlsToMapMove"))
			return asbrandBrandUrlsToMapMove(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asbrandBrandUrlsToMapShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Brand brand = getASBrandService().getBrand(id);
		addBeanToRequest(req, "ownerId", id);
		checkBrands(brand, req);

		UrlsToMapElementFB form = new UrlsToMapElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(brand.getId());
		addBeanToRequest(req, "asbrandBrandUrlsToMapElementForm", form);

		// generate list ...
		int size = brand.getUrlsToMapSize();
		List<UrlsToMapElementFB> beans = new ArrayList<UrlsToMapElementFB>(size);
		for (int i=0; i<size; i++){
			String value = brand.getUrlsToMapElement(i);
			UrlsToMapElementFB bean = new UrlsToMapElementFB();
			bean.setOwnerId(brand.getId());
			bean.setPosition(i);
			bean.setUrlToMap(value);
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asbrandBrandUrlsToMapDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Brand brandCurr = getASBrandService().getBrand(id);
		canUpdateBrands(brandCurr, req);
		checkBrands(brandCurr, req);
		int position = getIntParameter(req, "pPosition");
		Brand brand = getASBrandService().getBrand(id);
		brand.removeUrlsToMapElement(position);
		getASBrandService().updateBrand(brand);
		return asbrandBrandUrlsToMapShow(mapping, req, res);
	}

	public ActionCommand asbrandBrandUrlsToMapMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Brand brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(brand, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(brand, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(brand, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(brand, position);
		return asbrandBrandUrlsToMapShow(mapping, req, res);
	}

	private void moveUp(Brand brand, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		brand.swapUrlsToMapElement(position, position-1);
		getASBrandService().updateBrand(brand);
	}

	private void moveTop(Brand brand, int position) throws ASGRuntimeException {
		List<String> targetList = brand.getUrlsToMap();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		brand.setUrlsToMap(targetList);
		getASBrandService().updateBrand(brand);
	}

	private void moveDown(Brand brand, int position) throws ASGRuntimeException {
		if (position<brand.getUrlsToMapSize()-1){
			brand.swapUrlsToMapElement(position, position+1);
			getASBrandService().updateBrand(brand);
		}
	}

	private void moveBottom(Brand brand, int position) throws ASGRuntimeException {
		List<String> targetList = brand.getUrlsToMap();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		brand.setUrlsToMap(targetList);
		getASBrandService().updateBrand(brand);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asbrandBrandUrlsToMapAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		UrlsToMapElementFB form = new UrlsToMapElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Brand brand;
		brand = getASBrandService().getBrand(id);
		canUpdateBrands(brand, req);
		checkBrands(brand, req);
		brand.addUrlsToMapElement(form.getUrlToMap());
		getASBrandService().updateBrand(brand);
		return asbrandBrandUrlsToMapShow(mapping, req, res);
	}

}
