/**
 ********************************************************************************
 *** BaseActionMappingDefAction.java                                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomaction.action;

import net.anotheria.anosite.gen.shared.action.BaseActionsAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.ascustomaction.data.ActionMappingDef;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BaseActionMappingDefAction extends BaseActionsAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Mappings";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASCustomAction";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "ActionMappingDef";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, ActionMappingDef actionmappingdef) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASCustomAction.ActionMappingDef").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomAction.ActionMappingDef", actionmappingdef, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomAction.ActionMappingDef", actionmappingdef, "url");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.url", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomAction.ActionMappingDef", actionmappingdef, "parameters");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.parameters", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomAction.ActionMappingDef", actionmappingdef, "command");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.command", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASCustomAction.ActionMappingDef", actionmappingdef, "localizationBundles");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.localizationBundles", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockActionMappingDefs(ActionMappingDef actionmappingdef, HttpServletRequest req) throws Exception{
		if(actionmappingdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)actionmappingdef;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASCustomActionService().updateActionMappingDef( actionmappingdef);
			logger.info("Lock-OPERATION, document with id : ["+actionmappingdef.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockActionMappingDefs(ActionMappingDef actionmappingdef, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(actionmappingdef instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)actionmappingdef;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASCustomActionService().updateActionMappingDef( actionmappingdef);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+actionmappingdef.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+actionmappingdef.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkActionMappingDefs(ActionMappingDef actionmappingdef, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = actionmappingdef instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)actionmappingdef).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)actionmappingdef).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockActionMappingDefs(actionmappingdef, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdateActionMappingDefs(ActionMappingDef actionmappingdef, HttpServletRequest req) throws Exception{
		if(actionmappingdef instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)actionmappingdef, false, getUserId(req));
		}
		if (isTimeoutReached(actionmappingdef)) {
			checkActionMappingDefs(actionmappingdef, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(actionmappingdef, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(ActionMappingDef actionmappingdef){
		if (actionmappingdef instanceof LockableObject) {
			LockableObject lock = (LockableObject)actionmappingdef;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(ActionMappingDef actionmappingdef, HttpServletRequest req){
		if (actionmappingdef instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)actionmappingdef;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
