/**
 ********************************************************************************
 *** MultiOpDialogCustomBoxTypesAction.java                                   ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomdata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxTypeFactory;
import net.anotheria.anosite.gen.ascustomdata.data.CustomBoxType;
import net.anotheria.anosite.gen.ascustomdata.bean.EditCustomBoxTypeFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogCustomBoxTypesAction extends BaseCustomBoxTypeAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("ascustomdataCustomBoxTypeDelete"))
			return ascustomdataCustomBoxTypeDelete(mapping, req, res);
		if (path.equals("ascustomdataCustomBoxTypeDuplicate"))
			return ascustomdataCustomBoxTypeDuplicate(mapping, req, res);
		if (path.equals("ascustomdataCustomBoxTypeUpdate"))
			return ascustomdataCustomBoxTypeUpdate(mapping, req, res);
		if (path.equals("ascustomdataCustomBoxTypeClose"))
			return ascustomdataCustomBoxTypeClose(mapping, req, res);
		if (path.equals("ascustomdataCustomBoxTypeLock"))
			return ascustomdataCustomBoxTypeLock(mapping, req, res);
		if (path.equals("ascustomdataCustomBoxTypeUnLock"))
			return ascustomdataCustomBoxTypeUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand ascustomdataCustomBoxTypeDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			CustomBoxType customboxtypeCurr = getASCustomDataService().getCustomBoxType(id);
			if (customboxtypeCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)customboxtypeCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASCustomDataService().deleteCustomBoxType(id);
		}
		res.sendRedirect("ascustomdataCustomBoxTypeShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand ascustomdataCustomBoxTypeDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		CustomBoxType customboxtypeSrc = getASCustomDataService().getCustomBoxType(id);
		CustomBoxType customboxtypeDest = CustomBoxTypeFactory.createCustomBoxType(customboxtypeSrc);


		CustomBoxType customboxtypeCreated = getASCustomDataService().createCustomBoxType(customboxtypeDest);
		res.sendRedirect("ascustomdataCustomBoxTypeEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+customboxtypeCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand ascustomdataCustomBoxTypeUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditCustomBoxTypeFB form = new EditCustomBoxTypeFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		CustomBoxType customboxtype = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		customboxtype = (CustomBoxType)getASCustomDataService().getCustomBoxType(form.getId()).clone();
	}else{
		customboxtype = CustomBoxTypeFactory.createCustomBoxType();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	customboxtype.setName(form.getName());
	customboxtype.setRendererpage(form.getRendererpage());

	CustomBoxType updatedCopy = null;
	if (create){
		updatedCopy = getASCustomDataService().createCustomBoxType(customboxtype);
	}else{
		canUpdateCustomBoxTypes(customboxtype, req);
		checkCustomBoxTypes(customboxtype, req);
		updatedCopy = getASCustomDataService().updateCustomBoxType(customboxtype);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("ascustomdataCustomBoxTypeEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(customboxtype, req);
		res.sendRedirect("ascustomdataCustomBoxTypeShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(CustomBoxType customboxtype, HttpServletRequest req) throws Exception{
	if(((LockableObject)customboxtype).isLocked())
		unLockCustomBoxTypes(customboxtype, req, false);
}

public ActionCommand ascustomdataCustomBoxTypeLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	CustomBoxType customboxtypeCurr = id != null && !id.equals("") ? getASCustomDataService().getCustomBoxType(id) : null;
	if(customboxtypeCurr != null && customboxtypeCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)customboxtypeCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockCustomBoxTypes(customboxtypeCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, customboxtypeCurr));
	return null;
}

public ActionCommand ascustomdataCustomBoxTypeUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	CustomBoxType customboxtypeCurr = id != null && !id.equals("") ? getASCustomDataService().getCustomBoxType(id) : null;
	if(customboxtypeCurr != null && customboxtypeCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)customboxtypeCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockCustomBoxTypes(customboxtypeCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, customboxtypeCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, CustomBoxType item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "ascustomdataCustomBoxTypeShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "ascustomdataCustomBoxTypeEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "ascustomdataCustomBoxTypeShow?ts="+System.currentTimeMillis();
}

public ActionCommand ascustomdataCustomBoxTypeClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	CustomBoxType customboxtypeCurr = id != null && !id.equals("") ? getASCustomDataService().getCustomBoxType(id) : null;
	if(customboxtypeCurr != null && customboxtypeCurr instanceof LockableObject && ((LockableObject)customboxtypeCurr).isLocked()) 
		unLockCustomBoxTypes(customboxtypeCurr, req, false);
	res.sendRedirect("ascustomdataCustomBoxTypeShow?ts="+System.currentTimeMillis());
	return null;
}

}
