/**
 ********************************************************************************
 *** CustomGuardDefRestResource.java                                          ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.ascustomdata.rest;

import java.util.List;
import net.anotheria.anoprise.metafactory.MetaFactory;
import net.anotheria.anoprise.metafactory.MetaFactoryException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import org.codehaus.jettison.json.JSONArray;
import net.anotheria.anosite.gen.shared.util.ParserUtilService;
import net.anotheria.anosite.gen.ascustomdata.data.CustomGuardDef;
import net.anotheria.anosite.gen.ascustomdata.service.IASCustomDataService;
import net.anotheria.anosite.gen.ascustomdata.service.ASCustomDataServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path("/customguarddef")
public class CustomGuardDefRestResource{

	private static final Logger LOGGER = LoggerFactory.getLogger(CustomGuardDefRestResource.class);
	private IASCustomDataService ascustomdataService;
	private Gson gson;
	private GsonBuilder builder;

	public CustomGuardDefRestResource() {
		builder = new GsonBuilder();
		builder.setPrettyPrinting();
		gson = builder.create();

		try {
			ascustomdataService = MetaFactory.get(IASCustomDataService.class);
		}catch(MetaFactoryException e){
			LOGGER.error("Unable to create service: I ASCustomDataService", e);
			throw new RuntimeException("Unable to create service", e);
		}
	}

	@GET
	@Produces("application/json;charset=utf-8")
	public Response getObjects() {

		List<CustomGuardDef> result = null;
		try {
			result = ascustomdataService.getCustomGuardDefs();
		}catch(ASCustomDataServiceException e){
			LOGGER.error("Unable to getCustomGuardDefs", e);
			return Response.status(500).build();
		}

		return Response.status(201).entity(gson.toJson(result)).build();
	}

	@GET
	@Path("/{id}")
	@Produces("application/json;charset=utf-8")
	public Response getObject(@PathParam("id") String id) {

		CustomGuardDef result = null;
		try {
			result = ascustomdataService.getCustomGuardDef(id);
		}catch(ASCustomDataServiceException e){
			LOGGER.error("Unable to getCustomGuardDef by id", e);
			return Response.status(500).build();
		}

		return Response.status(201).entity(gson.toJson(result)).build();
	}

	@POST
	@Consumes("application/json;charset=utf-8")
	public Response createTransferredObject(String input) {

		try {
			JSONArray array = new JSONArray(input);
			ParserUtilService.getInstance().addToQueueParsingDocuments(array);
		}catch(Exception e){
			LOGGER.error("Unable to parsing transferred objects", e);
			return Response.status(500).build();
		}
		return Response.status(201).build();
	}
}
