/**
 ********************************************************************************
 *** MultiOpDialogExperimentsAction.java                                      ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asexperiment.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asexperiment.data.ExperimentFactory;
import net.anotheria.anosite.gen.asexperiment.data.Experiment;
import net.anotheria.anosite.gen.asexperiment.bean.EditExperimentFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;

public class MultiOpDialogExperimentsAction extends BaseExperimentAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asexperimentExperimentDelete"))
			return asexperimentExperimentDelete(mapping, req, res);
		if (path.equals("asexperimentExperimentDuplicate"))
			return asexperimentExperimentDuplicate(mapping, req, res);
		if (path.equals("asexperimentExperimentUpdate"))
			return asexperimentExperimentUpdate(mapping, req, res);
		if (path.equals("asexperimentExperimentClose"))
			return asexperimentExperimentClose(mapping, req, res);
		if (path.equals("asexperimentExperimentLock"))
			return asexperimentExperimentLock(mapping, req, res);
		if (path.equals("asexperimentExperimentUnLock"))
			return asexperimentExperimentUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asexperimentExperimentDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Experiment experimentCurr = getASExperimentService().getExperiment(id);
			if (experimentCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)experimentCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASExperimentService().deleteExperiment(id);
		}
		res.sendRedirect("asexperimentExperimentShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asexperimentExperimentDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Experiment experimentSrc = getASExperimentService().getExperiment(id);
		Experiment experimentDest = ExperimentFactory.createExperiment(experimentSrc);


		Experiment experimentCreated = getASExperimentService().createExperiment(experimentDest);
		res.sendRedirect("asexperimentExperimentEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+experimentCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asexperimentExperimentUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditExperimentFB form = new EditExperimentFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Experiment experiment = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		experiment = (Experiment)getASExperimentService().getExperiment(form.getId()).clone();
	}else{
		experiment = ExperimentFactory.createExperiment();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	experiment.setName(form.getName());
	experiment.setActive(form.isActive());
	experiment.setDistribution(form.getDistribution());
	experiment.setDescription(form.getDescription());
	experiment.setVariant1(form.getVariant1());
	experiment.setVariant2(form.getVariant2());
	experiment.setVariant3(form.getVariant3());
	experiment.setVariant4(form.getVariant4());
	experiment.setVariant5(form.getVariant5());
	experiment.setVariant6(form.getVariant6());
	experiment.setVariant7(form.getVariant7());
	experiment.setVariant8(form.getVariant8());
	experiment.setVariant9(form.getVariant9());
	experiment.setVariant10(form.getVariant10());

	Experiment updatedCopy = null;
	if (create){
		updatedCopy = getASExperimentService().createExperiment(experiment);
	}else{
		canUpdateExperiments(experiment, req);
		checkExperiments(experiment, req);
		updatedCopy = getASExperimentService().updateExperiment(experiment);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asexperimentExperimentEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(experiment, req);
		res.sendRedirect("asexperimentExperimentShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Experiment experiment, HttpServletRequest req) throws Exception{
	if(((LockableObject)experiment).isLocked())
		unLockExperiments(experiment, req, false);
}

public ActionCommand asexperimentExperimentLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Experiment experimentCurr = id != null && !id.equals("") ? getASExperimentService().getExperiment(id) : null;
	if(experimentCurr != null && experimentCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)experimentCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockExperiments(experimentCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, experimentCurr));
	return null;
}

public ActionCommand asexperimentExperimentUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Experiment experimentCurr = id != null && !id.equals("") ? getASExperimentService().getExperiment(id) : null;
	if(experimentCurr != null && experimentCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)experimentCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockExperiments(experimentCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, experimentCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Experiment item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asexperimentExperimentShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asexperimentExperimentEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asexperimentExperimentShow?ts="+System.currentTimeMillis();
}

public ActionCommand asexperimentExperimentClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Experiment experimentCurr = id != null && !id.equals("") ? getASExperimentService().getExperiment(id) : null;
	if(experimentCurr != null && experimentCurr instanceof LockableObject && ((LockableObject)experimentCurr).isLocked()) 
		unLockExperiments(experimentCurr, req, false);
	res.sendRedirect("asexperimentExperimentShow?ts="+System.currentTimeMillis());
	return null;
}

}
