/**
 ********************************************************************************
 *** MultiOpBrandFeaturesGuardsAction.java                                    ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfeature.data.BrandFeatureFactory;
import net.anotheria.anosite.gen.asfeature.data.BrandFeature;
import net.anotheria.anosite.gen.asfeature.bean.GuardsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asfeature.bean.GuardsQuickAddFB;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDefSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpBrandFeaturesGuardsAction extends BaseBrandFeatureAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asfeatureBrandFeatureGuardsShow"))
			return asfeatureBrandFeatureGuardsShow(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureGuardsAdd"))
			return asfeatureBrandFeatureGuardsAdd(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureGuardsDelete"))
			return asfeatureBrandFeatureGuardsDelete(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureGuardsMove"))
			return asfeatureBrandFeatureGuardsMove(mapping, req, res);
		if (path.equals("asfeatureBrandFeatureGuardsQuickAdd"))
			return asfeatureBrandFeatureGuardsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asfeatureBrandFeatureGuardsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		BrandFeature brandfeature = getASFeatureService().getBrandFeature(id);
		addBeanToRequest(req, "ownerId", id);
		checkBrandFeatures(brandfeature, req);

		GuardsElementFB form = new GuardsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(brandfeature.getId());
		addBeanToRequest(req, "asfeatureBrandFeatureGuardsElementForm", form);

		GuardsQuickAddFB quickAddForm = new GuardsQuickAddFB() ;
		quickAddForm.setOwnerId(brandfeature.getId());
		addBeanToRequest(req, "asfeatureBrandFeatureGuardsQuickAddForm", quickAddForm);


		//link guard to ASFederatedData.GuardDef
		List<GuardDef> guarddefs = getASFederatedDataService().getGuardDefs(new GuardDefSortType(GuardDefSortType.SORT_BY_NAME));
		List<LabelValueBean> guarddefsValues = new ArrayList<LabelValueBean>(guarddefs.size());
		for (int i=0; i<guarddefs.size(); i++){
			net.anotheria.anosite.gen.asfederateddata.data.GuardDef tmp_guarddef = (net.anotheria.anosite.gen.asfederateddata.data.GuardDef) guarddefs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_guarddef.getId(), tmp_guarddef.getName()+" ["+tmp_guarddef.getId()+"]" );
			guarddefsValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", guarddefsValues);
		// generate list ...
		int size = brandfeature.getGuardsSize();
		List<GuardsElementFB> beans = new ArrayList<GuardsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = brandfeature.getGuardsElement(i);
			GuardsElementFB bean = new GuardsElementFB();
			bean.setOwnerId(brandfeature.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				GuardDef tmp_guarddef = getASFederatedDataService().getGuardDef(value);
				bean.setDescription(tmp_guarddef.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asfeatureBrandFeatureGuardsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		BrandFeature brandfeatureCurr = getASFeatureService().getBrandFeature(id);
		canUpdateBrandFeatures(brandfeatureCurr, req);
		checkBrandFeatures(brandfeatureCurr, req);
		int position = getIntParameter(req, "pPosition");
		BrandFeature brandfeature = getASFeatureService().getBrandFeature(id);
		brandfeature.removeGuardsElement(position);
		getASFeatureService().updateBrandFeature(brandfeature);
		return asfeatureBrandFeatureGuardsShow(mapping, req, res);
	}

	public ActionCommand asfeatureBrandFeatureGuardsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		BrandFeature brandfeature = getASFeatureService().getBrandFeature(id);
		canUpdateBrandFeatures(brandfeature, req);
		checkBrandFeatures(brandfeature, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(brandfeature, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(brandfeature, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(brandfeature, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(brandfeature, position);
		return asfeatureBrandFeatureGuardsShow(mapping, req, res);
	}

	private void moveUp(BrandFeature brandfeature, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		brandfeature.swapGuardsElement(position, position-1);
		getASFeatureService().updateBrandFeature(brandfeature);
	}

	private void moveTop(BrandFeature brandfeature, int position) throws ASGRuntimeException {
		List<String> targetList = brandfeature.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		brandfeature.setGuards(targetList);
		getASFeatureService().updateBrandFeature(brandfeature);
	}

	private void moveDown(BrandFeature brandfeature, int position) throws ASGRuntimeException {
		if (position<brandfeature.getGuardsSize()-1){
			brandfeature.swapGuardsElement(position, position+1);
			getASFeatureService().updateBrandFeature(brandfeature);
		}
	}

	private void moveBottom(BrandFeature brandfeature, int position) throws ASGRuntimeException {
		List<String> targetList = brandfeature.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		brandfeature.setGuards(targetList);
		getASFeatureService().updateBrandFeature(brandfeature);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asfeatureBrandFeatureGuardsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsElementFB form = new GuardsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		BrandFeature brandfeature;
		brandfeature = getASFeatureService().getBrandFeature(id);
		canUpdateBrandFeatures(brandfeature, req);
		checkBrandFeatures(brandfeature, req);
		brandfeature.addGuardsElement(form.getGuard());
		getASFeatureService().updateBrandFeature(brandfeature);
		return asfeatureBrandFeatureGuardsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asfeatureBrandFeatureGuardsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsQuickAddFB form = new GuardsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		BrandFeature brandfeature;
		brandfeature = getASFeatureService().getBrandFeature(id);
		canUpdateBrandFeatures(brandfeature, req);
		checkBrandFeatures(brandfeature, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				brandfeature.addGuardsElement(""+i);
			}
		}
		getASFeatureService().updateBrandFeature(brandfeature);
		return asfeatureBrandFeatureGuardsShow(mapping, req, res);
	}

}
