/**
 ********************************************************************************
 *** MultiOpFeaturesGuardsAction.java                                         ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.action;

import java.util.List;
import java.util.ArrayList;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfeature.data.FeatureFactory;
import net.anotheria.anosite.gen.asfeature.data.Feature;
import net.anotheria.anosite.gen.asfeature.bean.GuardsElementFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.anosite.gen.asfeature.bean.GuardsQuickAddFB;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDef;
import net.anotheria.anosite.gen.asfederateddata.data.GuardDefSortType;
import net.anotheria.webutils.bean.LabelValueBean;
import net.anotheria.anodoc.data.NoSuchDocumentException;
import net.anotheria.util.StringUtils;
import net.anotheria.asg.exception.ASGRuntimeException;

public class MultiOpFeaturesGuardsAction extends BaseFeatureAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateContainerMultiOpAction

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asfeatureFeatureGuardsShow"))
			return asfeatureFeatureGuardsShow(mapping, req, res);
		if (path.equals("asfeatureFeatureGuardsAdd"))
			return asfeatureFeatureGuardsAdd(mapping, req, res);
		if (path.equals("asfeatureFeatureGuardsDelete"))
			return asfeatureFeatureGuardsDelete(mapping, req, res);
		if (path.equals("asfeatureFeatureGuardsMove"))
			return asfeatureFeatureGuardsMove(mapping, req, res);
		if (path.equals("asfeatureFeatureGuardsQuickAdd"))
			return asfeatureFeatureGuardsQuickAdd(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListShowActionMethod

	public ActionCommand asfeatureFeatureGuardsShow(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Feature feature = getASFeatureService().getFeature(id);
		addBeanToRequest(req, "ownerId", id);
		checkFeatures(feature, req);

		GuardsElementFB form = new GuardsElementFB() ;
		form.setPosition(-1);
		form.setOwnerId(feature.getId());
		addBeanToRequest(req, "asfeatureFeatureGuardsElementForm", form);

		GuardsQuickAddFB quickAddForm = new GuardsQuickAddFB() ;
		quickAddForm.setOwnerId(feature.getId());
		addBeanToRequest(req, "asfeatureFeatureGuardsQuickAddForm", quickAddForm);


		//link guard to ASFederatedData.GuardDef
		List<GuardDef> guarddefs = getASFederatedDataService().getGuardDefs(new GuardDefSortType(GuardDefSortType.SORT_BY_NAME));
		List<LabelValueBean> guarddefsValues = new ArrayList<LabelValueBean>(guarddefs.size());
		for (int i=0; i<guarddefs.size(); i++){
			net.anotheria.anosite.gen.asfederateddata.data.GuardDef tmp_guarddef = (net.anotheria.anosite.gen.asfederateddata.data.GuardDef) guarddefs.get(i);
			LabelValueBean bean = new LabelValueBean(tmp_guarddef.getId(), tmp_guarddef.getName()+" ["+tmp_guarddef.getId()+"]" );
			guarddefsValues.add(bean);
		}
		addBeanToRequest(req, "guardValuesCollection", guarddefsValues);
		// generate list ...
		int size = feature.getGuardsSize();
		List<GuardsElementFB> beans = new ArrayList<GuardsElementFB>(size);
		for (int i=0; i<size; i++){
			String value = feature.getGuardsElement(i);
			GuardsElementFB bean = new GuardsElementFB();
			bean.setOwnerId(feature.getId());
			bean.setPosition(i);
			bean.setGuard(value);
			try{
				GuardDef tmp_guarddef = getASFederatedDataService().getGuardDef(value);
				bean.setDescription(tmp_guarddef.getName());
			}catch(NoSuchDocumentException e){
				bean.setDescription("*** DELETED ***");
			}
			beans.add(bean);
		}
		addBeanToRequest(req, "elements", beans);
		return mapping.success();
	}

	public ActionCommand asfeatureFeatureGuardsDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		Feature featureCurr = getASFeatureService().getFeature(id);
		canUpdateFeatures(featureCurr, req);
		checkFeatures(featureCurr, req);
		int position = getIntParameter(req, "pPosition");
		Feature feature = getASFeatureService().getFeature(id);
		feature.removeGuardsElement(position);
		getASFeatureService().updateFeature(feature);
		return asfeatureFeatureGuardsShow(mapping, req, res);
	}

	public ActionCommand asfeatureFeatureGuardsMove(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, "ownerId");
		int position = getIntParameter(req, "pPosition");
		String direction = getStringParameter(req, "dir");
		Feature feature = getASFeatureService().getFeature(id);
		canUpdateFeatures(feature, req);
		checkFeatures(feature, req);
		if ("top".equalsIgnoreCase(direction))
			moveTop(feature, position);
		if ("up".equalsIgnoreCase(direction))
			moveUp(feature, position);
		if ("down".equalsIgnoreCase(direction))
			moveDown(feature, position);
		if ("bottom".equalsIgnoreCase(direction))
			moveBottom(feature, position);
		return asfeatureFeatureGuardsShow(mapping, req, res);
	}

	private void moveUp(Feature feature, int position) throws ASGRuntimeException {
		if (position==0) 
			return;
		feature.swapGuardsElement(position, position-1);
		getASFeatureService().updateFeature(feature);
	}

	private void moveTop(Feature feature, int position) throws ASGRuntimeException {
		List<String> targetList = feature.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(0, toSwap);
		feature.setGuards(targetList);
		getASFeatureService().updateFeature(feature);
	}

	private void moveDown(Feature feature, int position) throws ASGRuntimeException {
		if (position<feature.getGuardsSize()-1){
			feature.swapGuardsElement(position, position+1);
			getASFeatureService().updateFeature(feature);
		}
	}

	private void moveBottom(Feature feature, int position) throws ASGRuntimeException {
		List<String> targetList = feature.getGuards();
		String toSwap = targetList.remove(position);
		targetList.add(toSwap);
		feature.setGuards(targetList);
		getASFeatureService().updateFeature(feature);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListAddRowActionMethod

	public ActionCommand asfeatureFeatureGuardsAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsElementFB form = new GuardsElementFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Feature feature;
		feature = getASFeatureService().getFeature(id);
		canUpdateFeatures(feature, req);
		checkFeatures(feature, req);
		feature.addGuardsElement(form.getGuard());
		getASFeatureService().updateFeature(feature);
		return asfeatureFeatureGuardsShow(mapping, req, res);
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateListQuickAddActionMethod

	public ActionCommand asfeatureFeatureGuardsQuickAdd(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		GuardsQuickAddFB form = new GuardsQuickAddFB();
		PopulateUtility.populate(form, req);
		String id = form.getOwnerId();
		Feature feature;
		feature = getASFeatureService().getFeature(id);
		canUpdateFeatures(feature, req);
		checkFeatures(feature, req);
		String paramIdsToAdd = form.getQuickAddIds();

		String idParameters[] = StringUtils.tokenize(paramIdsToAdd, ',');
		for (String anIdParam : idParameters){
			String ids[] = StringUtils.tokenize(anIdParam, '-');
			for (int i=Integer.parseInt(ids[0]); i<=Integer.parseInt(ids[ids.length-1]); i++){
				feature.addGuardsElement(""+i);
			}
		}
		getASFeatureService().updateFeature(feature);
		return asfeatureFeatureGuardsShow(mapping, req, res);
	}

}
