/**
 ********************************************************************************
 *** ModuleASFeature.java                                                     ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfeature.data;

import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.DocumentList;
import net.anotheria.anodoc.data.IDHolder;
import net.anotheria.anodoc.data.NoSuchDocumentListException;
import java.util.List;

public class ModuleASFeature extends Module{


	public static final String MODULE_ID = "asfeature";

	public static final String LIST_FEATURE = "list_feature";
	public static final String ID_HOLDER_FEATURE = IDHolder.DOC_ID_HOLDER_PRE+"feature";
	public static final String LIST_BRANDFEATURE = "list_brandfeature";
	public static final String ID_HOLDER_BRANDFEATURE = IDHolder.DOC_ID_HOLDER_PRE+"brandfeature";

	public ModuleASFeature(){
		super(MODULE_ID);
	}

	@SuppressWarnings("unchecked")
	private DocumentList<FeatureDocument> _getFeatures(){
		try{
			return getList(LIST_FEATURE);
		}catch(NoSuchDocumentListException e){
			return new DocumentList<FeatureDocument>(LIST_FEATURE);
		}
	}

	private void _updateFeatures(DocumentList<FeatureDocument> list){
		putList(list);
	}

	public List<FeatureDocument> getFeatures(){
		return _getFeatures().getList();
	}

	public FeatureDocument getFeature(String id){
		return _getFeatures().getDocumentById(id);
	}

	public void updateFeature(FeatureDocument feature){
		DocumentList<FeatureDocument> features = _getFeatures();
		features.removeDocumentById(feature.getId());
		feature.setLastUpdateNow();
		feature.setCallContextAuthor();
		features.addDocument(feature);
		_updateFeatures(features);
	}

	public void deleteFeature(String id){
		DocumentList<FeatureDocument> entries = _getFeatures();
		entries.removeDocumentById(id);
		_updateFeatures(entries);
	}

	public FeatureDocument createFeature(FeatureDocument feature ){
		IDHolder idh = _getIdHolder(ID_HOLDER_FEATURE);
		int id = idh.getNextIdInt();
		feature.renameTo(""+id);
		putDocument(idh);

		DocumentList<FeatureDocument> entries = _getFeatures();
		feature.setLastUpdateNow();
		feature.setCallContextAuthor();
		entries.addDocument(feature);
		_updateFeatures(entries);
		return feature;
	}

	public FeatureDocument importFeature(FeatureDocument feature ){
		IDHolder idh = _getIdHolder(ID_HOLDER_FEATURE);
		idh.adjustTill(feature.getId());
		putDocument(idh);

		DocumentList<FeatureDocument> entries = _getFeatures();
		feature.setLastUpdateNow();
		feature.setCallContextAuthor();
		entries.addDocument(feature);
		_updateFeatures(entries);
		return feature;
	}


	@SuppressWarnings("unchecked")
	private DocumentList<BrandFeatureDocument> _getBrandFeatures(){
		try{
			return getList(LIST_BRANDFEATURE);
		}catch(NoSuchDocumentListException e){
			return new DocumentList<BrandFeatureDocument>(LIST_BRANDFEATURE);
		}
	}

	private void _updateBrandFeatures(DocumentList<BrandFeatureDocument> list){
		putList(list);
	}

	public List<BrandFeatureDocument> getBrandFeatures(){
		return _getBrandFeatures().getList();
	}

	public BrandFeatureDocument getBrandFeature(String id){
		return _getBrandFeatures().getDocumentById(id);
	}

	public void updateBrandFeature(BrandFeatureDocument brandfeature){
		DocumentList<BrandFeatureDocument> brandfeatures = _getBrandFeatures();
		brandfeatures.removeDocumentById(brandfeature.getId());
		brandfeature.setLastUpdateNow();
		brandfeature.setCallContextAuthor();
		brandfeatures.addDocument(brandfeature);
		_updateBrandFeatures(brandfeatures);
	}

	public void deleteBrandFeature(String id){
		DocumentList<BrandFeatureDocument> entries = _getBrandFeatures();
		entries.removeDocumentById(id);
		_updateBrandFeatures(entries);
	}

	public BrandFeatureDocument createBrandFeature(BrandFeatureDocument brandfeature ){
		IDHolder idh = _getIdHolder(ID_HOLDER_BRANDFEATURE);
		int id = idh.getNextIdInt();
		brandfeature.renameTo(""+id);
		putDocument(idh);

		DocumentList<BrandFeatureDocument> entries = _getBrandFeatures();
		brandfeature.setLastUpdateNow();
		brandfeature.setCallContextAuthor();
		entries.addDocument(brandfeature);
		_updateBrandFeatures(entries);
		return brandfeature;
	}

	public BrandFeatureDocument importBrandFeature(BrandFeatureDocument brandfeature ){
		IDHolder idh = _getIdHolder(ID_HOLDER_BRANDFEATURE);
		idh.adjustTill(brandfeature.getId());
		putDocument(idh);

		DocumentList<BrandFeatureDocument> entries = _getBrandFeatures();
		brandfeature.setLastUpdateNow();
		brandfeature.setCallContextAuthor();
		entries.addDocument(brandfeature);
		_updateBrandFeatures(entries);
		return brandfeature;
	}


}
