/**
 ********************************************************************************
 *** ShowBoxTypesAction.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asfederateddata.action;

import java.util.List;
import java.util.ArrayList;
import net.anotheria.asg.util.decorators.IAttributeDecorator;
import net.anotheria.asg.util.filter.DocumentFilter;
import net.anotheria.util.NumberUtils;
import net.anotheria.asg.util.action.ActionUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import net.anotheria.anosite.gen.asfederateddata.data.BoxType;
import net.anotheria.anosite.gen.asfederateddata.bean.BoxTypeListItemBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;
import net.anotheria.anosite.gen.asfederateddata.bean.BoxTypeListItemBeanSortType;
import net.anotheria.util.sorter.Sorter;
import net.anotheria.util.sorter.QuickSorter;

public class ShowBoxTypesAction extends BaseBoxTypeAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateShowAction

	public static final String SA_SORT_TYPE = SA_SORT_TYPE_PREFIX+"BoxType";
	public static final String SA_FILTER = SA_FILTER_PREFIX+"BoxType";
	private static Logger log = LoggerFactory.getLogger(ShowBoxTypesAction.class);
	private Sorter<BoxTypeListItemBean> sorter;

	private DocumentFilter nameFilterAZ;

	public ShowBoxTypesAction(){
		sorter = new QuickSorter<BoxTypeListItemBean>();
		try{ 
			nameFilterAZ = (DocumentFilter) Class.forName("net.anotheria.asg.util.filter.AZDocumentFilter").newInstance();
		} catch(Exception e){
			log.error(MarkerFactory.getMarker("FATAL"), "Couldn't instantiate filter:", e);
		}
	}
	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String filterParameter0 = "";
		try{ 
			filterParameter0 = getStringParameter(req, "pFilter0");
			addBeanToSession(req, SA_FILTER+"0", filterParameter0);
		}catch(Exception ignored){
			// no filter parameter given, tring to check in the session.
			filterParameter0 = (String)getBeanFromSession(req, SA_FILTER+"0");
			if (filterParameter0==null)
				filterParameter0 = "";
		}
		req.setAttribute("currentFilterParameter0", filterParameter0);

		int sortMethod = BoxTypeListItemBeanSortType.SORT_BY_DEFAULT;
		boolean sortOrder = getSortOder(req);
		boolean sortParamSet = false;

		try{
			sortMethod = getIntParameter(req, PARAM_SORT_TYPE);
			sortParamSet = true;
		}catch(Exception ignored){}

		try{
			String sortMethodName = getStringParameter(req, PARAM_SORT_TYPE_NAME);
			sortMethod = BoxTypeListItemBeanSortType.name2method(sortMethodName);
			sortParamSet = true;
		}catch(Exception ignored){}

		BoxTypeListItemBeanSortType sortType = null;
		if (sortParamSet){
			sortType = new BoxTypeListItemBeanSortType(sortMethod, sortOrder);
			addBeanToSession(req, SA_SORT_TYPE, sortType);
		}else{
			sortType = (BoxTypeListItemBeanSortType)getBeanFromSession(req, SA_SORT_TYPE);
			if (sortType==null)
				sortType = new BoxTypeListItemBeanSortType(sortMethod, sortOrder);
		}
		req.setAttribute("currentSortCode", sortType.getMethodAndOrderCode());

		List<BoxType> _unfiltered_boxtypes = getASFederatedDataService().getBoxTypes();
		List<BoxType> boxtypes = new ArrayList<BoxType>();
		for (int i=0; i<_unfiltered_boxtypes.size(); i++){
			boolean mayPass = true;
			mayPass = mayPass && (nameFilterAZ.mayPass(_unfiltered_boxtypes.get(i), "name", filterParameter0));
			if (mayPass)
				boxtypes.add(_unfiltered_boxtypes.get(i));
		}
		List<BoxTypeListItemBean> beans = new ArrayList<BoxTypeListItemBean>(boxtypes.size());
		for (BoxType boxtype : boxtypes){
			BoxTypeListItemBean bean = makeBoxTypeListItemBean(boxtype);
			beans.add(bean);
		}

		beans = sorter.sort(beans, sortType);
		beans = ActionUtils.sliceDataAndSavePagingInformation(req, beans);
		addBeanToRequest(req, "boxtypes", beans);
		addBeanToRequest(req, "nameFilterAZ", nameFilterAZ.getTriggerer("name"));
		return mapping.success();
	}

	protected BoxTypeListItemBean makeBoxTypeListItemBean(BoxType boxtype) {
		BoxTypeListItemBean bean = new BoxTypeListItemBean();
		bean.setPlainId(boxtype.getId());
		bean.setId(boxtype.getId());
		bean.setName(boxtype.getName());
		bean.setRendererpage(boxtype.getRendererpage());
		bean.setDocumentLastUpdateTimestamp(NumberUtils.makeISO8601TimestampString(boxtype.getLastUpdateTimestamp()));
		return bean;
	}
}
