/**
 ********************************************************************************
 *** ASGenericActionServiceImpl.java                                          ***
 *** The implementation of the IASGenericActionService.                       ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asgenericaction.service;

import java.nio.charset.Charset;
import java.util.List;
import java.util.ArrayList;
import java.util.Set;
import net.anotheria.anodoc.data.Module;
import net.anotheria.anodoc.data.Property;
import net.anotheria.anodoc.data.NoSuchPropertyException;
import net.anotheria.util.sorter.SortType;
import net.anotheria.util.sorter.StaticQuickSorter;
import net.anotheria.util.slicer.Segment;
import net.anotheria.util.slicer.Slicer;
import net.anotheria.anosite.gen.asgenericaction.data.ModuleASGenericAction;
import net.anotheria.anosite.gen.shared.service.BasicCMSService;
import net.anotheria.anodoc.query2.DocumentQuery;
import net.anotheria.anodoc.query2.QueryResult;
import net.anotheria.anodoc.query2.QueryResultEntry;
import net.anotheria.anodoc.query2.QueryProperty;
import net.anotheria.util.StringUtils;
import net.anotheria.util.xml.XMLNode;
import net.anotheria.util.xml.XMLAttribute;
import net.anotheria.asg.util.listener.IModuleListener;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import net.anotheria.anodoc.util.mapper.ObjectMapperUtil;
import net.anotheria.anosite.gen.shared.util.DocumentName;
import net.anotheria.anosite.gen.asgenericaction.data.GenericActionDef;
import net.anotheria.anosite.gen.asgenericaction.data.GenericActionDefXMLHelper;
import net.anotheria.anosite.gen.asgenericaction.data.GenericActionDefDocument;

public class ASGenericActionServiceImpl extends BasicCMSService implements IASGenericActionService, IModuleListener{

	// Generated by: class net.anotheria.asg.generator.model.docs.CMSBasedServiceGenerator.generateImplementation

	private static ASGenericActionServiceImpl instance;

	private ASGenericActionServiceImpl(){
		addServiceListener(new net.anotheria.anosite.cms.listener.CRUDLogListener());
		addServiceListener(new net.anotheria.anosite.cms.listener.AutoTransferAsGenericActionListener());
		addModuleListener(ModuleASGenericAction.MODULE_ID, this);
	}

	static final ASGenericActionServiceImpl getInstance(){
		if (instance==null){
			instance = new ASGenericActionServiceImpl();
		}
		return instance;
	}

	private ModuleASGenericAction _getModuleASGenericAction(){
		return (ModuleASGenericAction) getModule(ModuleASGenericAction.MODULE_ID);
	}

	@Override
	public void moduleLoaded(Module module){
		firePersistenceChangedEvent();
	}

	@Override
	public List<GenericActionDef> getGenericActionDefs(){
		List<GenericActionDef> genericactiondefs = new ArrayList<>();
		genericactiondefs.addAll(_getModuleASGenericAction().getGenericActionDefs());
		return genericactiondefs;
	}

	@Override
	public List<GenericActionDef> getGenericActionDefs(SortType sortType){
		return StaticQuickSorter.sort(getGenericActionDefs(), sortType);
	}

	/**
	 * Returns the GenericActionDef objects with the specified ids.
	 */
	public List<GenericActionDef> getGenericActionDefs(List<String> ids){
		if (ids==null || ids.size()==0)
			return new ArrayList<>(0);
		List<GenericActionDef> all = getGenericActionDefs();
		List<GenericActionDef> ret = new ArrayList<>();
		for (GenericActionDef genericactiondef : all){
			if(ids.contains(genericactiondef.getId())){
				ret.add(genericactiondef);
			}
		}
		return ret;
	}

	/**
	 * Returns the GenericActionDef objects with the specified ids, sorted by given sorttype.
	 */
	public List<GenericActionDef> getGenericActionDefs(List<String> ids, SortType sortType){
		return StaticQuickSorter.sort(getGenericActionDefs(ids), sortType);
	}

	@Override
	public void deleteGenericActionDef(GenericActionDef genericactiondef){
		deleteGenericActionDef(genericactiondef.getId());
		if (hasServiceListeners()){
			fireObjectDeletedEvent(genericactiondef);
		}
	}

	@Override
	public void deleteGenericActionDef(String id){
		ModuleASGenericAction module = _getModuleASGenericAction();
		GenericActionDef varValue = hasServiceListeners()?module.getGenericActionDef(id):null;
		module.deleteGenericActionDef(id);
		updateModule(module);
		if(varValue!=null){
			fireObjectDeletedEvent(varValue);
		}
	}

	@Override
	public void deleteGenericActionDefs(List<GenericActionDef> list){
		ModuleASGenericAction module = _getModuleASGenericAction();
		for (GenericActionDef genericactiondef : list){
			module.deleteGenericActionDef(genericactiondef.getId());
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (int t=0; t<list.size(); t++)
				fireObjectDeletedEvent(list.get(t));
		}
	}

	@Override
	public GenericActionDef getGenericActionDef(String id){
		return _getModuleASGenericAction().getGenericActionDef(id);
	}

	@Override
	public GenericActionDef importGenericActionDef(GenericActionDef genericactiondef){
		ModuleASGenericAction module = _getModuleASGenericAction();
		module.importGenericActionDef((GenericActionDefDocument)genericactiondef);
		updateModule(module);
		if (hasServiceListeners()){
			fireObjectImportedEvent(genericactiondef);
		}
		return genericactiondef;
	}

	@Override
	public List<GenericActionDef> importGenericActionDefs(List<GenericActionDef> list){
		ModuleASGenericAction module = _getModuleASGenericAction();
		List<GenericActionDef> ret = new ArrayList<>();
		for (GenericActionDef genericactiondef : list){
			GenericActionDef imported = module.importGenericActionDef((GenericActionDefDocument)genericactiondef);
			ret.add(imported);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (GenericActionDef genericactiondef : ret)
				fireObjectImportedEvent(genericactiondef);
		}
		return ret;
	}

	@Override
	public GenericActionDef createGenericActionDef(GenericActionDef genericactiondef){
		ModuleASGenericAction module = _getModuleASGenericAction();
		module.createGenericActionDef((GenericActionDefDocument)genericactiondef);
		updateModule(module);
		fireObjectCreatedEvent(genericactiondef);
		return genericactiondef;
	}

	@Override
	/**
	 * Creates multiple new GenericActionDef objects.
	 * Returns the created versions.
	 */
	public List<GenericActionDef> createGenericActionDefs(List<GenericActionDef> list){
		ModuleASGenericAction module = _getModuleASGenericAction();
		List<GenericActionDef> ret = new ArrayList<>();
		for (GenericActionDef genericactiondef : list){
			GenericActionDef created = module.createGenericActionDef((GenericActionDefDocument)genericactiondef);
			ret.add(created);
		}
		updateModule(module);
		if (hasServiceListeners()){
			for (GenericActionDef genericactiondef : ret)
				fireObjectCreatedEvent(genericactiondef);
		}
		return ret;
	}

	@Override
	public GenericActionDef updateGenericActionDef(GenericActionDef genericactiondef){
		GenericActionDef oldVersion = null;
		ModuleASGenericAction module = _getModuleASGenericAction();
		if (hasServiceListeners())
			oldVersion = module.getGenericActionDef(genericactiondef.getId());
		module.updateGenericActionDef((GenericActionDefDocument)genericactiondef);
		updateModule(module);
		if (oldVersion != null){
			fireObjectUpdatedEvent(oldVersion, genericactiondef);
		}
		return genericactiondef;
	}

	@Override
	public List<GenericActionDef> updateGenericActionDefs(List<GenericActionDef> list){
		List<GenericActionDef> oldList = null;
		if (hasServiceListeners())
			oldList = new ArrayList<>(list.size());
		ModuleASGenericAction module = _getModuleASGenericAction();
		for (GenericActionDef genericactiondef : list){
			if (oldList!=null)
				oldList.add(module.getGenericActionDef(genericactiondef.getId()));
			module.updateGenericActionDef((GenericActionDefDocument)genericactiondef);
		}
		updateModule(module);
		if (oldList!=null){
			for (int t=0; t<list.size(); t++)
				fireObjectUpdatedEvent(oldList.get(t), list.get(t));
		}
		return list;
	}

	@Override
	public List<GenericActionDef> getGenericActionDefsByProperty(String propertyName, Object value){
		List<GenericActionDef> allGenericActionDefs = getGenericActionDefs();
		List<GenericActionDef> ret = new ArrayList<>();
		for (int i=0; i<allGenericActionDefs.size(); i++){
			GenericActionDef genericactiondef = allGenericActionDefs.get(i);
			try{
				Property property = ((GenericActionDefDocument)genericactiondef).getProperty(propertyName);
				if (property.getValue()==null && value==null){
					ret.add(genericactiondef);
				}else{
					if (value!=null && property.getValue().equals(value))
						ret.add(genericactiondef);
				}
			}catch(NoSuchPropertyException nspe){
				if (value==null)
					ret.add(genericactiondef);
			}catch(Exception ignored){}
		}
		return ret;
	}

	public List<GenericActionDef> getGenericActionDefsByProperty(String propertyName, Object value, SortType sortType){
		return StaticQuickSorter.sort(getGenericActionDefsByProperty(propertyName, value), sortType);
	}
	/**
	 * Executes a query on GenericActionDefs
	 */
	public QueryResult executeQueryOnGenericActionDefs(DocumentQuery query){
		List<GenericActionDef> allGenericActionDefs = getGenericActionDefs();
		QueryResult result = new QueryResult();
		for (int i=0; i<allGenericActionDefs.size(); i++){
			List<QueryResultEntry> partialResult = query.match(allGenericActionDefs.get(i));
			result.add(partialResult);
		}
		return result;
	}

	/**
	 * Returns all GenericActionDef objects, where property matches.
	 */
	public List<GenericActionDef> getGenericActionDefsByProperty(QueryProperty... property){
		//first the slow version, the fast version is a todo.
		List<GenericActionDef> ret = new ArrayList<>();
		List<GenericActionDef> src = getGenericActionDefs();
		for ( GenericActionDef genericactiondef : src){
			boolean mayPass = true;
			for (QueryProperty qp : property){
				mayPass = mayPass && qp.doesMatch(genericactiondef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(genericactiondef);
		}
		return ret;
	}

	/**
	 * Returns all GenericActionDef objects, where property matches, sorted
	 */
	public List<GenericActionDef> getGenericActionDefsByProperty(SortType sortType, QueryProperty... property){
		return StaticQuickSorter.sort(getGenericActionDefsByProperty(property), sortType);
	}

	/**
	 * Returns GenericActionDef objects count.
	 */
	public int getGenericActionDefsCount() {
		return _getModuleASGenericAction().getGenericActionDefs().size();
	}

	/**
	 * Returns GenericActionDef objects segment.
	 */
	public List<GenericActionDef> getGenericActionDefs(Segment aSegment) {
		return Slicer.slice(aSegment, getGenericActionDefs()).getSliceData();
	}

	/**
	 * Returns GenericActionDef objects segment, where property matched.
	 */
	public List<GenericActionDef> getGenericActionDefsByProperty(Segment aSegment, QueryProperty... property) {
		int pLimit = aSegment.getElementsPerSlice();
		int pOffset = aSegment.getSliceNumber() * aSegment.getElementsPerSlice() - aSegment.getElementsPerSlice();
		List<GenericActionDef> ret = new ArrayList<>();
		List<GenericActionDef> src = getGenericActionDefs();
		for (GenericActionDef genericactiondef : src) {
			boolean mayPass = true;
			for (QueryProperty qp : property) {
				mayPass = mayPass && qp.doesMatch(genericactiondef.getPropertyValue(qp.getName()));
			}
			if (mayPass)
				ret.add(genericactiondef);
			if (ret.size() > pOffset + pLimit)
				break;
		}
		return Slicer.slice(aSegment, ret).getSliceData();
	}

	/**
	 * Returns GenericActionDef objects segment, where property matched, sorted.
	 */
	public List<GenericActionDef> getGenericActionDefsByProperty(Segment aSegment, SortType aSortType, QueryProperty... aProperty){
		return StaticQuickSorter.sort(getGenericActionDefsByProperty(aSegment, aProperty), aSortType);
	}

	@Override
	public void fetchGenericActionDef(final String id, Set<String> addedDocuments, JSONArray data) throws ASGenericActionServiceException {
		if (id.isEmpty() || addedDocuments.contains("GenericActionDef" + id))
			return;

		try {
			final GenericActionDefDocument genericactiondef = _getModuleASGenericAction().getGenericActionDef(id);
			addedDocuments.add("GenericActionDef" + id);



			JSONObject dataObject = new JSONObject();
			String jsonObject = ObjectMapperUtil.getMapperInstance().writeValueAsString(genericactiondef);
			dataObject.put("object", jsonObject);
			dataObject.put("service", "ASGenericAction");
			dataObject.put("document", "ASGenericAction_GenericActionDef");

			data.put(dataObject);

		}catch(IOException e){
			throw new ASGenericActionServiceException ("Problem with fetching data for this GenericActionDef instance object:" + e.getMessage());
		}catch(JSONException e){
			throw new ASGenericActionServiceException ("Problem with fetching data for this GenericActionDef instance in json :" + e.getMessage());
		}
	}

	private void saveTransferredGenericActionDef(final JSONObject data) throws ASGenericActionServiceException {
		try {
			String objectData = data.getString("object");
			GenericActionDef genericactiondef = ObjectMapperUtil.getMapperInstance().readValue(objectData.getBytes(Charset.forName("UTF-8")), GenericActionDefDocument.class);

			try {
				updateGenericActionDef(genericactiondef);
			}catch(Exception e){
				importGenericActionDef(genericactiondef);
			}
		}catch(JSONException e){
			throw new ASGenericActionServiceException("Problem with getting data from json GenericActionDef instance :" + e.getMessage());
		}catch(IOException e){
			throw new ASGenericActionServiceException("Problem with parsing data for this GenericActionDef instance :" + e.getMessage());
		}
	}

	public void executeParsingForDocument (final DocumentName documentName, final JSONObject data) throws ASGenericActionServiceException {
		switch(documentName) {
			case DOCUMENT_ASGENERICACTION_GENERICACTIONDEF:
				saveTransferredGenericActionDef(data);
				break;
			default:
				log.info("There is no correct document: " + documentName + "in this service");
				throw new ASGenericActionServiceException("No such document");
		}
	}

	/**
	 * Executes a query on all data objects (documents, vo) which are part of this module and managed by this service
	 */
	public QueryResult executeQueryOnAllObjects(DocumentQuery query){
		QueryResult ret = new QueryResult();
		ret.add(executeQueryOnGenericActionDefs(query).getEntries());
		return ret;
	} //executeQueryOnAllObjects


	public XMLNode exportGenericActionDefsToXML(){
		XMLNode ret = new XMLNode("GenericActionDefs");
		List<GenericActionDef> list = getGenericActionDefs();
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (GenericActionDef object : list)
			ret.addChildNode(GenericActionDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportGenericActionDefsToXML(List<GenericActionDef> list){
		XMLNode ret = new XMLNode("GenericActionDefs");
		ret.addAttribute(new XMLAttribute("count", list.size()));
		for (GenericActionDef object : list)
			ret.addChildNode(GenericActionDefXMLHelper.toXML(object));
		return ret;
	}

	public XMLNode exportToXML(){
		XMLNode ret = new XMLNode("ASGenericAction");

		ret.addChildNode(exportGenericActionDefsToXML());

		return ret;
	}
}
