/**
 ********************************************************************************
 *** BasePageLayoutAction.java                                                ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aslayoutdata.action;

import net.anotheria.anosite.gen.shared.action.BaseLayoutAction;
import jakarta.servlet.http.HttpServletRequest;
import net.anotheria.anosite.gen.aslayoutdata.data.PageLayout;
import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.exeption.LockingException;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperRegistry;
import net.anotheria.asg.util.helper.cmsview.CMSViewHelperUtil;

public abstract class BasePageLayoutAction extends BaseLayoutAction{

// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateBaseAction


	private final Logger logger = LoggerFactory.getLogger("cms-lock-log");
	protected String getTitle(){
		return "Layout";
	} //getTitle

	protected String getCurrentModuleDefName(){
		return "ASLayoutData";
	} //getCurrentModuleDefName

	protected String getCurrentDocumentDefName(){
		return "PageLayout";
	} //getCurrentDocumentDefName

	protected void addFieldExplanations(HttpServletRequest req, PageLayout pagelayout) {
		if (!CMSViewHelperRegistry.getCMSViewHelpers("ASLayoutData.PageLayout").isEmpty()) {
			String fieldDescription = null;
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASLayoutData.PageLayout", pagelayout, "name");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.name", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASLayoutData.PageLayout", pagelayout, "layoutpage");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.layoutpage", fieldDescription);
			fieldDescription = CMSViewHelperUtil.getFieldExplanation("ASLayoutData.PageLayout", pagelayout, "description");
			if (fieldDescription!=null && fieldDescription.length()>0)
				req.setAttribute("description.description", fieldDescription);
		} //
	} //addFieldExplanations END


	/**
	 * Executing locking. Actually.
	 */
	protected void lockPageLayouts(PageLayout pagelayout, HttpServletRequest req) throws Exception{
		if(pagelayout instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagelayout;
			lock.setLocked(true);
			lock.setLockerId(getUserId(req));
			lock.setLockingTime(System.currentTimeMillis());
			getASLayoutDataService().updatePageLayout( pagelayout);
			logger.info("Lock-OPERATION, document with id : ["+pagelayout.getId()+"] was locked by: " + getUserId(req));
			addLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing unlocking. Actually.
	 */
	protected void unLockPageLayouts(PageLayout pagelayout, HttpServletRequest req, boolean unlockByTimeoout) throws Exception{
		if(pagelayout instanceof AbstractASGDocument){
			AbstractASGDocument lock = (AbstractASGDocument)pagelayout;
			lock.setLocked(false);
			lock.setLockerId("");
			lock.setLockingTime(0);
			getASLayoutDataService().updatePageLayout( pagelayout);
			if (!unlockByTimeoout){
			   logger.info("UnLock-OPERATION, document with id : ["+pagelayout.getId()+"] was unlocked by: " + getUserId(req) +"  with 'admin' role :" + isUserInRole(req, "admin") );
			 } else { 
			   logger.info("UnLock-OPERATION, document with id : ["+pagelayout.getId()+"] was unlocked by: timeOut");
			}
			removeLockedAttribute(req, lock);
		}
	}
	/**
	 * Executing auto-unlocking check....
	 */
	protected void checkPageLayouts(PageLayout pagelayout, HttpServletRequest req) throws Exception{
		boolean shouldUnlock = pagelayout instanceof AbstractASGDocument && 
 	 	 	 	 ((AbstractASGDocument)pagelayout).isLocked() && 
 	 	 	 	 ( System.currentTimeMillis() >= ((AbstractASGDocument)pagelayout).getLockingTime() + getLockingTimeout());
		if(shouldUnlock)
			unLockPageLayouts(pagelayout, req, true);
	}
	/**
	 * Checking UpdateCapability rights
	 */
	protected void canUpdatePageLayouts(PageLayout pagelayout, HttpServletRequest req) throws Exception{
		if(pagelayout instanceof LockableObject ){
		//Actually - simplest Check! --  exception - if anything happens!!!!
			DocumentLockingHelper.update.checkExecutionPermission((LockableObject)pagelayout, false, getUserId(req));
		}
		if (isTimeoutReached(pagelayout)) {
			checkPageLayouts(pagelayout, req);
			throw new LockingException(getUserId(req)+" . Document can't be updated! Due to lock - timeout!!!");
		}
		if (wasUnlockedByAdmin(pagelayout, req)) {
			throw new LockingException(getUserId(req)+" . Document can't be updated! It was unlocked by user in 'admin' role!!!");
		}
	}
	/**
	 */
	private boolean isTimeoutReached(PageLayout pagelayout){
		if (pagelayout instanceof LockableObject) {
			LockableObject lock = (LockableObject)pagelayout;
			return lock.isLocked() && lock.getLockingTime() + getLockingTimeout() <= System.currentTimeMillis();
		}
		return false;
	}
	/**
	 */
	private boolean wasUnlockedByAdmin(PageLayout pagelayout, HttpServletRequest req){
		if (pagelayout instanceof AbstractASGDocument) {
			AbstractASGDocument lock = (AbstractASGDocument)pagelayout;
			return !lock.isLocked() && containsLockedAttribute(req, lock);
		}
		return false;
	}
}
