/**
 ********************************************************************************
 *** PageLayoutDocument.java                                                  ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.aslayoutdata.data;

import net.anotheria.asg.data.AbstractASGDocument;
import net.anotheria.util.crypt.MD5Util;
import net.anotheria.util.sorter.IComparable;
import net.anotheria.util.BasicComparable;

public class PageLayoutDocument extends AbstractASGDocument implements PageLayout, IComparable{

	public PageLayoutDocument() {
		super("");
	}

	public PageLayoutDocument(String id){
		super(id);
	}

	public PageLayoutDocument(PageLayoutDocument toClone){
		super(toClone);
	}

	PageLayoutDocument(PageLayoutBuilder builder){
		super("");
		setName(builder.name);
		setLayoutpage(builder.layoutpage);
		setDescription(builder.description);
		setStyle(builder.style);
	}

	public String getName(){
		return getString(PROP_NAME);
	}

	public void setName(String value){
		setString(PROP_NAME, value);
	}

	public String getLayoutpage(){
		return getString(PROP_LAYOUTPAGE);
	}

	public void setLayoutpage(String value){
		setString(PROP_LAYOUTPAGE, value);
	}

	public String getDescription(){
		return getString(PROP_DESCRIPTION);
	}

	public void setDescription(String value){
		setString(PROP_DESCRIPTION, value);
	}

	public String getStyle(){
		return getString(LINK_PROP_STYLE);
	}

	public void setStyle(String value){
		setString(LINK_PROP_STYLE, value);
	}


	public String toString(){
		String ret = "PageLayout ";
		ret += "["+getId()+"] ";
		ret += "name: "+getName();
		ret += ", ";
		ret += "layoutpage: "+getLayoutpage();
		ret += ", ";
		ret += "description: "+getDescription();
		return ret;
	}


	public int compareTo(PageLayout comparable){
		return compareTo(comparable, PageLayoutSortType.SORT_BY_DEFAULT);
	}

	public int compareTo(IComparable anotherComparable, int method){
		PageLayoutDocument anotherDoc = (PageLayoutDocument) anotherComparable;
		switch(method){
			case PageLayoutSortType.SORT_BY_ID:
				return BasicComparable.compareString(getId(), anotherDoc.getId());
			case PageLayoutSortType.SORT_BY_NAME:
				return BasicComparable.compareString(getName(), anotherDoc.getName());
			case PageLayoutSortType.SORT_BY_LAYOUTPAGE:
				return BasicComparable.compareString(getLayoutpage(), anotherDoc.getLayoutpage());
			case PageLayoutSortType.SORT_BY_DESCRIPTION:
				return BasicComparable.compareString(getDescription(), anotherDoc.getDescription());
			case PageLayoutSortType.SORT_BY_STYLE:
				return BasicComparable.compareString(getStyle(), anotherDoc.getStyle());
			default:
				throw new RuntimeException("Sort method "+method+" is not supported.");
		}
	}

	public String getDefinedName(){
		return "PageLayout";
	}

	public String getDefinedParentName(){
		return "ASLayoutData";
	}

	public String getFootprint(){
		StringBuilder footprint = new StringBuilder();
		footprint.append(getName());
		footprint.append(getLayoutpage());
		footprint.append(getDescription());
		footprint.append(getStyle());
		return MD5Util.getMD5Hash(footprint);
	}

	public boolean equals(Object o){
		return o == this || ((o instanceof PageLayoutDocument) && ((PageLayoutDocument)o).getId().equals(getId()));
	}
}
