/**
 ********************************************************************************
 *** MultiOpDialogImagesAction.java                                           ***
 *** generated by AnoSiteGenerator (ASG), Version: 3.2.2                      ***
 *** Copyright (C) 2005 - 2023 Anotheria.net, www.anotheria.net               ***
 *** All Rights Reserved.                                                     ***
 ********************************************************************************
 *** Don't edit this code, if you aren't sure                                 ***
 *** that you do exactly know what you are doing!                             ***
 *** It's better to invest time in the generator, as into the generated code. ***
 ********************************************************************************
 */

package net.anotheria.anosite.gen.asresourcedata.action;

import net.anotheria.util.NumberUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.anotheria.maf.action.ActionCommand;
import net.anotheria.maf.action.ActionMapping;
import java.util.List;
import java.util.ArrayList;
import net.anotheria.anosite.gen.asresourcedata.data.ImageFactory;
import net.anotheria.anosite.gen.asresourcedata.data.Image;
import net.anotheria.anosite.gen.asresourcedata.bean.EditImageFB;
import net.anotheria.asg.util.bean.PopulateUtility;
import net.anotheria.asg.data.LockableObject;
import net.anotheria.asg.util.locking.helper.DocumentLockingHelper;
import net.anotheria.asg.data.MultilingualObject;
import net.anotheria.webutils.filehandling.actions.FileStorage;
import net.anotheria.webutils.filehandling.beans.TemporaryFileHolder;
import java.lang.reflect.Method;
import java.lang.reflect.InvocationTargetException;
import net.anotheria.util.StringUtils;
import org.apache.commons.text.WordUtils;

public class MultiOpDialogImagesAction extends BaseImageAction{

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateMultiOpDialogAction


	@Override
	public ActionCommand execute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		return super.execute(mapping, req, res);
	} //execute

	public ActionCommand anoDocExecute(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String path = stripPath(mapping.getPath());
		if (path.equals("asresourcedataImageDelete"))
			return asresourcedataImageDelete(mapping, req, res);
		if (path.equals("asresourcedataImageDuplicate"))
			return asresourcedataImageDuplicate(mapping, req, res);
		if (path.equals("asresourcedataImageUpdate"))
			return asresourcedataImageUpdate(mapping, req, res);
		if (path.equals("asresourcedataImageClose"))
			return asresourcedataImageClose(mapping, req, res);
		if (path.equals("asresourcedataImageCopyLang"))
			return asresourcedataImageCopyLang(mapping, req, res);
		if (path.equals("asresourcedataImageSwitchMultilang"))
			return asresourcedataImageSwitchMultilang(mapping, req, res);
		if (path.equals("asresourcedataImageLock"))
			return asresourcedataImageLock(mapping, req, res);
		if (path.equals("asresourcedataImageUnLock"))
			return asresourcedataImageUnLock(mapping, req, res);
		throw new IllegalArgumentException("Unknown path: "+path);
	}

	public ActionCommand asresourcedataImageDelete(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String[] iDs = req.getParameterValues(PARAM_ID);
		if (iDs == null){
			throw new RuntimeException("Parameter " + PARAM_ID + " is not set.");
		}
		for (String id : iDs){
			Image imageCurr = getASResourceDataService().getImage(id);
			if (imageCurr instanceof LockableObject){ 
				LockableObject lockable = (LockableObject)imageCurr;
				DocumentLockingHelper.delete.checkExecutionPermission(lockable, false, getUserId(req));
			}
			getASResourceDataService().deleteImage(id);
			FileStorage.removeFilePermanently( imageCurr.getImage() );
		}
		res.sendRedirect("asresourcedataImageShow?ts="+System.currentTimeMillis());
		return null;
	}

	public ActionCommand asresourcedataImageDuplicate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		String id = getStringParameter(req, PARAM_ID);
		Image imageSrc = getASResourceDataService().getImage(id);
		Image imageDest = ImageFactory.createImage(imageSrc);

		imageDest.setImage(FileStorage.cloneFilePermanently( imageDest.getImage() ));

		Image imageCreated = getASResourceDataService().createImage(imageDest);
		res.sendRedirect("asresourcedataImageEdit?ts="+System.currentTimeMillis()+"&"+PARAM_ID+"="+imageCreated.getId());

		return null;
	}

	// Generated by: class net.anotheria.asg.generator.view.action.ModuleActionsGenerator.generateUpdateActionMethod

	public ActionCommand asresourcedataImageUpdate(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
		EditImageFB form = new EditImageFB();
		PopulateUtility.populate(form, req);
		boolean create = false;
		Image image = null;
		if (form.getId()==null) {
		res.sendRedirect("asresourcedataLocalizationBundleShow?ts="+System.currentTimeMillis());
		return null;
	}
	if (form.getId().length()>0){
		image = (Image)getASResourceDataService().getImage(form.getId()).clone();
	}else{
		image = ImageFactory.createImage();
		create = true;
	}

	String nextAction = req.getParameter("nextAction");
	if (nextAction == null || nextAction.length() == 0)
		nextAction = "close";

	//skipped id because it's readonly.
	image.setName(form.getName());
	image.setTitle(form.getTitle());
	image.setAliasEN(form.getAliasEN());
	image.setAliasDE(form.getAliasDE());
	image.setAltEN(form.getAltEN());
	image.setAltDE(form.getAltDE());
	//handle image
	TemporaryFileHolder holder_image = FileStorage.getTemporaryFile(req,"image");
	if (holder_image!=null && holder_image.getData()!=null){
		FileStorage.removeFilePermanently( image.getImage() );
		FileStorage.storeFilePermanently(req, holder_image.getFileName(),"image");
		image.setImage(holder_image.getFileName());
		FileStorage.removeTemporaryFile(req,"image");
	}

	// delete image method start
	String fieldName = req.getParameter("fieldName");
	String fileName = req.getParameter("fileName");

	if (!StringUtils.isEmpty(fieldName) && !StringUtils.isEmpty(fileName)) {
		String setMethodName = "set"+WordUtils.capitalize(fieldName);
		Class<?> c = image.getClass();
		try{
			Method m = c.getDeclaredMethod(setMethodName, new Class[]{String.class});
			m.invoke(image, new Object[]{""});
			FileStorage.removeFilePermanently(fileName);
		}catch (NoSuchMethodException e){
			e.printStackTrace();
		}catch (InvocationTargetException ignored) {
			ignored.printStackTrace();
		}
	}
	// delete image method end


	Image updatedCopy = null;
	if (create){
		updatedCopy = getASResourceDataService().createImage(image);
	}else{
		canUpdateImages(image, req);
		checkImages(image, req);
		updatedCopy = getASResourceDataService().updateImage(image);
	}
	if (nextAction.equalsIgnoreCase("stay")){
		res.sendRedirect("asresourcedataImageEdit?ts="+System.currentTimeMillis()+"&pId="+updatedCopy.getId());
	}else{
		unlockAfterUpdate(image, req);
		res.sendRedirect("asresourcedataImageShow?ts="+System.currentTimeMillis());
	}
	return null;
}
/**
 * Simply unlocks document after updation.
 */
private void unlockAfterUpdate(Image image, HttpServletRequest req) throws Exception{
	if(((LockableObject)image).isLocked())
		unLockImages(image, req, false);
}

public ActionCommand asresourcedataImageCopyLang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String sourceLanguage = req.getParameter("pSrcLang");
	if (sourceLanguage==null || sourceLanguage.length()==0)
		throw new RuntimeException("No source language");

	String destLanguage = req.getParameter("pDestLang");
	if (destLanguage==null || destLanguage.length()==0)
		throw new RuntimeException("No destination language");

	String id = getStringParameter(req, PARAM_ID);
	Image image = getASResourceDataService().getImage(id);
	canUpdateImages(image, req);
	checkImages(image, req);
	image.copyLANG2LANG(sourceLanguage, destLanguage);
	getASResourceDataService().updateImage(image);
	res.sendRedirect("asresourcedataImageEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataImageSwitchMultilang(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	String value = getStringParameter(req, "value");
	Image image = getASResourceDataService().getImage(id);
	canUpdateImages(image, req);
	checkImages(image, req);
	((MultilingualObject)image).setMultilingualDisabledInstance(Boolean.valueOf(value));
	getASResourceDataService().updateImage(image);
	res.sendRedirect("asresourcedataImageEdit?ts="+System.currentTimeMillis()+"&pId="+id);
	return null;
}

public ActionCommand asresourcedataImageLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Image imageCurr = id != null && !id.equals("") ? getASResourceDataService().getImage(id) : null;
	if(imageCurr != null && imageCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)imageCurr;
		DocumentLockingHelper.lock.checkExecutionPermission(lockable,false,getUserId(req));
		lockImages(imageCurr, req);
	}
	res.sendRedirect(getRedirectUrl(req, imageCurr));
	return null;
}

public ActionCommand asresourcedataImageUnLock(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Image imageCurr = id != null && !id.equals("") ? getASResourceDataService().getImage(id) : null;
	if(imageCurr != null && imageCurr instanceof LockableObject){ 
		LockableObject lockable = (LockableObject)imageCurr;
		DocumentLockingHelper.unLock.checkExecutionPermission(lockable,isUserInRole(req, "admin"),getUserId(req));
		unLockImages(imageCurr, req, false);
	}
	res.sendRedirect(getRedirectUrl(req, imageCurr));
	return null;
}

/**
 * Simplest method for redirect url creation. nextAction == showEdit - going to 'editView', to 'listView' otherwise. 
 */
private String getRedirectUrl(HttpServletRequest req, Image item){
	String nextAction = req.getParameter("nextAction");
	if (item==null || nextAction == null || nextAction.length() == 0)
		return "asresourcedataImageShow?ts="+System.currentTimeMillis();
	else
		return nextAction.equals("showEdit") ? "asresourcedataImageEdit?ts="+System.currentTimeMillis()+"&pId="+item.getId()
		       : "asresourcedataImageShow?ts="+System.currentTimeMillis();
}

public ActionCommand asresourcedataImageClose(ActionMapping mapping, HttpServletRequest req, HttpServletResponse res) throws Exception{
	String id = getStringParameter(req, PARAM_ID);
	Image imageCurr = id != null && !id.equals("") ? getASResourceDataService().getImage(id) : null;
	if(imageCurr != null && imageCurr instanceof LockableObject && ((LockableObject)imageCurr).isLocked()) 
		unLockImages(imageCurr, req, false);
	res.sendRedirect("asresourcedataImageShow?ts="+System.currentTimeMillis());
	return null;
}

}
